/****************************************************************************
 *
 * <:copyright-BRCM:2015:DUAL/GPL:voice
 * 
 *    Copyright (c) 2015 Broadcom 
 *    All Rights Reserved
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, version 2, as published by
 * the Free Software Foundation (the "GPL").
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * 
 * A copy of the GPL is available at http://www.broadcom.com/licenses/GPLv2.php, or by
 * writing to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 * 
 * :>
 *
 ***************************************************************************/
#include <linux/delay.h>
#include <dsphal_pcm.h>
#include <bcm_pinmux.h>

#ifdef BRCM_NTR_SUPPORT
#include <apm_regs.h>
#endif

void pcm_pinmux()
{
#ifdef BRCM_NTR_SUPPORT
   /* Configuring NTR clock input via GPIO for 4915 */
   bcm_set_pinmux(14, BP_PINMUX_VAL_1 >> BP_PINMUX_VAL_SHIFT); /* NTR_IN  */  
   bcm_set_pinmux(15, BP_PINMUX_VAL_1 >> BP_PINMUX_VAL_SHIFT); /* NTR_OUT */ 
#endif /* BRCM_NTR_SUPPORT */
}

void pcm_cfg_dpll_div(void)
{
#ifdef BRCM_NTR_SUPPORT
   TOPCTRL->AdslClockSample |= 0x10000000; 
   
   /* Local clk is generated via DPLL NCO @ 65.536Mhz
    * Ref clk @ 256KHz 
    * Phase comparator compares both clocks @ 8Khz
    * 8Khz = 65.536Mhz / (8191+1) = 8Khz / (31+1)
    * local_div = 8191, ref_div = 31 */
   DPLL->dpll_div = (31 << DPLL_REF_DIV_SHIFT) | 8191;
   DHLOG_INFO("%s: DPLL programmed for refclk @ 256KHz\n", __func__);
#endif /* BRCM_NTR_SUPPORT */
}
