/****************************************************************************
 *
 * <:copyright-BRCM:2015:DUAL/GPL:voice
 * 
 *    Copyright (c) 2015 Broadcom 
 *    All Rights Reserved
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, version 2, as published by
 * the Free Software Foundation (the "GPL").
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * 
 * A copy of the GPL is available at http://www.broadcom.com/licenses/GPLv2.php, or by
 * writing to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 * 
 * :>
 *
 ***************************************************************************/
#include <linux/delay.h>

#include <dsphal_pcm.h>
#include <bcm_pinmux.h>


#ifdef BRCM_NTR_SUPPORT
#include <apm_regs.h>
#endif

void pcm_pinmux()
{
#ifdef BRCM_NTR_SUPPORT
   /* Configuring NTR clock input via GPIO 63146 */
   bcm_set_pinmux(19, BP_PINMUX_VAL_3 >> BP_PINMUX_VAL_SHIFT); //NTR_INOUT
#endif /* BRCM_NTR_SUPPORT */
}


void pcm_cfg_dpll_div(void)
{
#ifdef BRCM_NTR_SUPPORT
   TOPCTRL->AdslClockSample |= 0x20000000; //VDSL_NTR[1] @ 8Khz   
   /* Local clk is generated via DPLL NCO @ 65.536Mhz
    * Ref clk from VDSL_NTR[1] is @ 8kHz
    * Phase comparator compares both clocks @ 8Khz
    * 8Khz = 65.536Mhz / (8191+1) = 8khz / (0+1)
    * local_div = 8191, ref_div = 0 */
   DPLL->dpll_div = (0  << DPLL_REF_DIV_SHIFT) | 8191;
   DHLOG_INFO("%s: DPLL programmed for NCO refclk @ 8khz\n",
            __func__);
#endif /* BRCM_NTR_SUPPORT */
}

