/*
   Copyright (c) 2015 Broadcom Corporation
   All Rights Reserved

    <:label-BRCM:2015:DUAL/GPL:standard
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 2, as published by
    the Free Software Foundation (the "GPL").
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    
    A copy of the GPL is available at http://www.broadcom.com/licenses/GPLv2.php, or by
    writing to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
    
:>
*/

/*
 *  Created on: July 2018
 */

/*
 * Phy driver for external 2.5G phys: MaxLinear MXL3711
 */

#include "phy_drv.h"
#include "phy_drv_mii.h"

static int _mxl_phy_read_status(phy_dev_t *phy_dev)
{
    phy_dev->link = 1;
    phy_dev->speed = PHY_SPEED_2500;
    phy_dev->duplex = PHY_DUPLEX_FULL;
    phy_dev->pause_rx = 0;
    phy_dev->pause_tx = 0;

    return 0;
}

static int _mxl_phy_caps_get(phy_dev_t *phy_dev, int caps_type, uint32_t *pcaps)
{
    uint32_t caps = 0;

    if (caps_type != CAPS_TYPE_ADVERTISE)
        return 0;

    //caps |= PHY_CAP_AUTONEG;
    caps |= PHY_CAP_2500;
    *pcaps = caps;

    return 0;
}

static int _mxl_phy_drv_init(phy_drv_t *phy_drv)
{
    phy_drv->initialized = 1;

    return 0;
}

phy_drv_t phy_drv_ext_mxl =
{
    .phy_type = PHY_TYPE_EXT_MXL,
    .name = "EXT_MXL",
    .read_status = _mxl_phy_read_status,
    .caps_get = _mxl_phy_caps_get,
    .phyid_get = mii_phyid_get,
    .drv_init = _mxl_phy_drv_init,
};
