/*
   Copyright (c) 2015 Broadcom
   All Rights Reserved

    <:label-BRCM:2015:DUAL/GPL:standard
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 2, as published by
    the Free Software Foundation (the "GPL").
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    
    A copy of the GPL is available at http://www.broadcom.com/licenses/GPLv2.php, or by
    writing to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
    
:>
*/

#include "ru.h"

#if RU_INCLUDE_FIELD_DB
/******************************************************************************
 * Field: XPORT_INTR_CPU_STATUS_RESERVED0
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_STATUS_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    XPORT_INTR_CPU_STATUS_RESERVED0_FIELD_MASK,
    0,
    XPORT_INTR_CPU_STATUS_RESERVED0_FIELD_WIDTH,
    XPORT_INTR_CPU_STATUS_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_STATUS_LINK_DOWN_INTR
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_STATUS_LINK_DOWN_INTR_FIELD =
{
    "LINK_DOWN_INTR",
#if RU_INCLUDE_DESC
    "",
    "Link down interrupt for P3:P0. Interrupt corresponds to the attached PHY/interface link down event.",
#endif
    XPORT_INTR_CPU_STATUS_LINK_DOWN_INTR_FIELD_MASK,
    0,
    XPORT_INTR_CPU_STATUS_LINK_DOWN_INTR_FIELD_WIDTH,
    XPORT_INTR_CPU_STATUS_LINK_DOWN_INTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_STATUS_LINK_UP_INTR
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_STATUS_LINK_UP_INTR_FIELD =
{
    "LINK_UP_INTR",
#if RU_INCLUDE_DESC
    "",
    "Link up interrupt for P3:P0. Interrupt corresponds to the attached PHY/interface link up event.",
#endif
    XPORT_INTR_CPU_STATUS_LINK_UP_INTR_FIELD_MASK,
    0,
    XPORT_INTR_CPU_STATUS_LINK_UP_INTR_FIELD_WIDTH,
    XPORT_INTR_CPU_STATUS_LINK_UP_INTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_STATUS_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_STATUS_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_FIELD =
{
    "TX_TIMESYNC_FIFO_ENTRY_VALID_INTR",
#if RU_INCLUDE_DESC
    "",
    "PTP timestamp available for read. Bits [3:0] correspond to XLMAC ports 3 down to 0.",
#endif
    XPORT_INTR_CPU_STATUS_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_FIELD_MASK,
    0,
    XPORT_INTR_CPU_STATUS_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_FIELD_WIDTH,
    XPORT_INTR_CPU_STATUS_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_STATUS_XLMAC_INTR
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_STATUS_XLMAC_INTR_FIELD =
{
    "XLMAC_INTR",
#if RU_INCLUDE_DESC
    "",
    "Interrupt generated by XLMAC signaling various events as described in XLMAC_INTR_STATUS."
    "Bits [3:0] correspond to XLMAC ports 3 down to 0.",
#endif
    XPORT_INTR_CPU_STATUS_XLMAC_INTR_FIELD_MASK,
    0,
    XPORT_INTR_CPU_STATUS_XLMAC_INTR_FIELD_WIDTH,
    XPORT_INTR_CPU_STATUS_XLMAC_INTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_STATUS_MAC_REG_ERR_INTR
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_STATUS_MAC_REG_ERR_INTR_FIELD =
{
    "MAC_REG_ERR_INTR",
#if RU_INCLUDE_DESC
    "",
    "mac_reg_err_intr.\n"
    "XLMAC register transaction error",
#endif
    XPORT_INTR_CPU_STATUS_MAC_REG_ERR_INTR_FIELD_MASK,
    0,
    XPORT_INTR_CPU_STATUS_MAC_REG_ERR_INTR_FIELD_WIDTH,
    XPORT_INTR_CPU_STATUS_MAC_REG_ERR_INTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_STATUS_MAB_STATUS_INTR
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_STATUS_MAB_STATUS_INTR_FIELD =
{
    "MAB_STATUS_INTR",
#if RU_INCLUDE_DESC
    "",
    "Asserted when any of statuses get set in MSBUS Adaptation Block Status Register(s).",
#endif
    XPORT_INTR_CPU_STATUS_MAB_STATUS_INTR_FIELD_MASK,
    0,
    XPORT_INTR_CPU_STATUS_MAB_STATUS_INTR_FIELD_WIDTH,
    XPORT_INTR_CPU_STATUS_MAB_STATUS_INTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_STATUS_MIB_REG_ERR_INTR
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_STATUS_MIB_REG_ERR_INTR_FIELD =
{
    "MIB_REG_ERR_INTR",
#if RU_INCLUDE_DESC
    "",
    "mib_reg_err_intr.\n"
    "MIB register transaction error.",
#endif
    XPORT_INTR_CPU_STATUS_MIB_REG_ERR_INTR_FIELD_MASK,
    0,
    XPORT_INTR_CPU_STATUS_MIB_REG_ERR_INTR_FIELD_WIDTH,
    XPORT_INTR_CPU_STATUS_MIB_REG_ERR_INTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_STATUS_UBUS_ERR_INTR
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_STATUS_UBUS_ERR_INTR_FIELD =
{
    "UBUS_ERR_INTR",
#if RU_INCLUDE_DESC
    "",
    "UBUS transaction error.",
#endif
    XPORT_INTR_CPU_STATUS_UBUS_ERR_INTR_FIELD_MASK,
    0,
    XPORT_INTR_CPU_STATUS_UBUS_ERR_INTR_FIELD_WIDTH,
    XPORT_INTR_CPU_STATUS_UBUS_ERR_INTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_SET_RESERVED0
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_SET_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    XPORT_INTR_CPU_SET_RESERVED0_FIELD_MASK,
    0,
    XPORT_INTR_CPU_SET_RESERVED0_FIELD_WIDTH,
    XPORT_INTR_CPU_SET_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_SET_LINK_DOWN_INTR
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_SET_LINK_DOWN_INTR_FIELD =
{
    "LINK_DOWN_INTR",
#if RU_INCLUDE_DESC
    "",
    "Link down interrupt for P3:P0. Interrupt corresponds to the attached PHY/interface link down event.",
#endif
    XPORT_INTR_CPU_SET_LINK_DOWN_INTR_FIELD_MASK,
    0,
    XPORT_INTR_CPU_SET_LINK_DOWN_INTR_FIELD_WIDTH,
    XPORT_INTR_CPU_SET_LINK_DOWN_INTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_SET_LINK_UP_INTR
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_SET_LINK_UP_INTR_FIELD =
{
    "LINK_UP_INTR",
#if RU_INCLUDE_DESC
    "",
    "Link up interrupt for P3:P0. Interrupt corresponds to the attached PHY/interface link up event.",
#endif
    XPORT_INTR_CPU_SET_LINK_UP_INTR_FIELD_MASK,
    0,
    XPORT_INTR_CPU_SET_LINK_UP_INTR_FIELD_WIDTH,
    XPORT_INTR_CPU_SET_LINK_UP_INTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_SET_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_SET_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_FIELD =
{
    "TX_TIMESYNC_FIFO_ENTRY_VALID_INTR",
#if RU_INCLUDE_DESC
    "",
    "PTP timestamp available for read. Bits [3:0] correspond to XLMAC ports 3 down to 0.",
#endif
    XPORT_INTR_CPU_SET_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_FIELD_MASK,
    0,
    XPORT_INTR_CPU_SET_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_FIELD_WIDTH,
    XPORT_INTR_CPU_SET_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_SET_XLMAC_INTR
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_SET_XLMAC_INTR_FIELD =
{
    "XLMAC_INTR",
#if RU_INCLUDE_DESC
    "",
    "Interrupt generated by XLMAC signaling various events as described in XLMAC_INTR_STATUS."
    "Bits [3:0] correspond to XLMAC ports 3 down to 0.",
#endif
    XPORT_INTR_CPU_SET_XLMAC_INTR_FIELD_MASK,
    0,
    XPORT_INTR_CPU_SET_XLMAC_INTR_FIELD_WIDTH,
    XPORT_INTR_CPU_SET_XLMAC_INTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_SET_MAC_REG_ERR_INTR
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_SET_MAC_REG_ERR_INTR_FIELD =
{
    "MAC_REG_ERR_INTR",
#if RU_INCLUDE_DESC
    "",
    "mac_reg_err_intr.\n"
    "XLMAC register transaction error",
#endif
    XPORT_INTR_CPU_SET_MAC_REG_ERR_INTR_FIELD_MASK,
    0,
    XPORT_INTR_CPU_SET_MAC_REG_ERR_INTR_FIELD_WIDTH,
    XPORT_INTR_CPU_SET_MAC_REG_ERR_INTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_SET_MAB_STATUS_INTR
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_SET_MAB_STATUS_INTR_FIELD =
{
    "MAB_STATUS_INTR",
#if RU_INCLUDE_DESC
    "",
    "Asserted when any of statuses get set in MSBUS Adaptation Block Status Register(s).",
#endif
    XPORT_INTR_CPU_SET_MAB_STATUS_INTR_FIELD_MASK,
    0,
    XPORT_INTR_CPU_SET_MAB_STATUS_INTR_FIELD_WIDTH,
    XPORT_INTR_CPU_SET_MAB_STATUS_INTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_SET_MIB_REG_ERR_INTR
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_SET_MIB_REG_ERR_INTR_FIELD =
{
    "MIB_REG_ERR_INTR",
#if RU_INCLUDE_DESC
    "",
    "mib_reg_err_intr.\n"
    "MIB register transaction error.",
#endif
    XPORT_INTR_CPU_SET_MIB_REG_ERR_INTR_FIELD_MASK,
    0,
    XPORT_INTR_CPU_SET_MIB_REG_ERR_INTR_FIELD_WIDTH,
    XPORT_INTR_CPU_SET_MIB_REG_ERR_INTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_SET_UBUS_ERR_INTR
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_SET_UBUS_ERR_INTR_FIELD =
{
    "UBUS_ERR_INTR",
#if RU_INCLUDE_DESC
    "",
    "UBUS transaction error.",
#endif
    XPORT_INTR_CPU_SET_UBUS_ERR_INTR_FIELD_MASK,
    0,
    XPORT_INTR_CPU_SET_UBUS_ERR_INTR_FIELD_WIDTH,
    XPORT_INTR_CPU_SET_UBUS_ERR_INTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_CLEAR_RESERVED0
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_CLEAR_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    XPORT_INTR_CPU_CLEAR_RESERVED0_FIELD_MASK,
    0,
    XPORT_INTR_CPU_CLEAR_RESERVED0_FIELD_WIDTH,
    XPORT_INTR_CPU_CLEAR_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_CLEAR_LINK_DOWN_INTR
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_CLEAR_LINK_DOWN_INTR_FIELD =
{
    "LINK_DOWN_INTR",
#if RU_INCLUDE_DESC
    "",
    "Link down interrupt for P3:P0. Interrupt corresponds to the attached PHY/interface link down event.",
#endif
    XPORT_INTR_CPU_CLEAR_LINK_DOWN_INTR_FIELD_MASK,
    0,
    XPORT_INTR_CPU_CLEAR_LINK_DOWN_INTR_FIELD_WIDTH,
    XPORT_INTR_CPU_CLEAR_LINK_DOWN_INTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_CLEAR_LINK_UP_INTR
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_CLEAR_LINK_UP_INTR_FIELD =
{
    "LINK_UP_INTR",
#if RU_INCLUDE_DESC
    "",
    "Link up interrupt for P3:P0. Interrupt corresponds to the attached PHY/interface link up event.",
#endif
    XPORT_INTR_CPU_CLEAR_LINK_UP_INTR_FIELD_MASK,
    0,
    XPORT_INTR_CPU_CLEAR_LINK_UP_INTR_FIELD_WIDTH,
    XPORT_INTR_CPU_CLEAR_LINK_UP_INTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_CLEAR_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_CLEAR_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_FIELD =
{
    "TX_TIMESYNC_FIFO_ENTRY_VALID_INTR",
#if RU_INCLUDE_DESC
    "",
    "PTP timestamp available for read. Bits [3:0] correspond to XLMAC ports 3 down to 0.",
#endif
    XPORT_INTR_CPU_CLEAR_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_FIELD_MASK,
    0,
    XPORT_INTR_CPU_CLEAR_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_FIELD_WIDTH,
    XPORT_INTR_CPU_CLEAR_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_CLEAR_XLMAC_INTR
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_CLEAR_XLMAC_INTR_FIELD =
{
    "XLMAC_INTR",
#if RU_INCLUDE_DESC
    "",
    "Interrupt generated by XLMAC signaling various events as described in XLMAC_INTR_STATUS."
    "Bits [3:0] correspond to XLMAC ports 3 down to 0.",
#endif
    XPORT_INTR_CPU_CLEAR_XLMAC_INTR_FIELD_MASK,
    0,
    XPORT_INTR_CPU_CLEAR_XLMAC_INTR_FIELD_WIDTH,
    XPORT_INTR_CPU_CLEAR_XLMAC_INTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_CLEAR_MAC_REG_ERR_INTR
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_CLEAR_MAC_REG_ERR_INTR_FIELD =
{
    "MAC_REG_ERR_INTR",
#if RU_INCLUDE_DESC
    "",
    "mac_reg_err_intr.\n"
    "XLMAC register transaction error",
#endif
    XPORT_INTR_CPU_CLEAR_MAC_REG_ERR_INTR_FIELD_MASK,
    0,
    XPORT_INTR_CPU_CLEAR_MAC_REG_ERR_INTR_FIELD_WIDTH,
    XPORT_INTR_CPU_CLEAR_MAC_REG_ERR_INTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_CLEAR_MAB_STATUS_INTR
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_CLEAR_MAB_STATUS_INTR_FIELD =
{
    "MAB_STATUS_INTR",
#if RU_INCLUDE_DESC
    "",
    "Asserted when any of statuses get set in MSBUS Adaptation Block Status Register(s).",
#endif
    XPORT_INTR_CPU_CLEAR_MAB_STATUS_INTR_FIELD_MASK,
    0,
    XPORT_INTR_CPU_CLEAR_MAB_STATUS_INTR_FIELD_WIDTH,
    XPORT_INTR_CPU_CLEAR_MAB_STATUS_INTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_CLEAR_MIB_REG_ERR_INTR
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_CLEAR_MIB_REG_ERR_INTR_FIELD =
{
    "MIB_REG_ERR_INTR",
#if RU_INCLUDE_DESC
    "",
    "mib_reg_err_intr.\n"
    "MIB register transaction error.",
#endif
    XPORT_INTR_CPU_CLEAR_MIB_REG_ERR_INTR_FIELD_MASK,
    0,
    XPORT_INTR_CPU_CLEAR_MIB_REG_ERR_INTR_FIELD_WIDTH,
    XPORT_INTR_CPU_CLEAR_MIB_REG_ERR_INTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_CLEAR_UBUS_ERR_INTR
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_CLEAR_UBUS_ERR_INTR_FIELD =
{
    "UBUS_ERR_INTR",
#if RU_INCLUDE_DESC
    "",
    "UBUS transaction error.",
#endif
    XPORT_INTR_CPU_CLEAR_UBUS_ERR_INTR_FIELD_MASK,
    0,
    XPORT_INTR_CPU_CLEAR_UBUS_ERR_INTR_FIELD_WIDTH,
    XPORT_INTR_CPU_CLEAR_UBUS_ERR_INTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_MASK_STATUS_RESERVED0
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_MASK_STATUS_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    XPORT_INTR_CPU_MASK_STATUS_RESERVED0_FIELD_MASK,
    0,
    XPORT_INTR_CPU_MASK_STATUS_RESERVED0_FIELD_WIDTH,
    XPORT_INTR_CPU_MASK_STATUS_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_MASK_STATUS_LINK_DOWN_INTR_MASK
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_MASK_STATUS_LINK_DOWN_INTR_MASK_FIELD =
{
    "LINK_DOWN_INTR_MASK",
#if RU_INCLUDE_DESC
    "",
    "This bit corresponds to the mask for link down interrupt. See register description above for details of how to use this bit.",
#endif
    XPORT_INTR_CPU_MASK_STATUS_LINK_DOWN_INTR_MASK_FIELD_MASK,
    0,
    XPORT_INTR_CPU_MASK_STATUS_LINK_DOWN_INTR_MASK_FIELD_WIDTH,
    XPORT_INTR_CPU_MASK_STATUS_LINK_DOWN_INTR_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_MASK_STATUS_LINK_UP_INTR_MASK
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_MASK_STATUS_LINK_UP_INTR_MASK_FIELD =
{
    "LINK_UP_INTR_MASK",
#if RU_INCLUDE_DESC
    "",
    "This bit corresponds to the mask for link up interrupt. See register description above for details of how to use this bit.",
#endif
    XPORT_INTR_CPU_MASK_STATUS_LINK_UP_INTR_MASK_FIELD_MASK,
    0,
    XPORT_INTR_CPU_MASK_STATUS_LINK_UP_INTR_MASK_FIELD_WIDTH,
    XPORT_INTR_CPU_MASK_STATUS_LINK_UP_INTR_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_MASK_STATUS_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_MASK
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_MASK_STATUS_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_MASK_FIELD =
{
    "TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_MASK",
#if RU_INCLUDE_DESC
    "",
    "This bit corresponds to the mask for  tx timesync fifo entry valid interrupt. See register description above for details of how to use this bit.",
#endif
    XPORT_INTR_CPU_MASK_STATUS_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_MASK_FIELD_MASK,
    0,
    XPORT_INTR_CPU_MASK_STATUS_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_MASK_FIELD_WIDTH,
    XPORT_INTR_CPU_MASK_STATUS_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_MASK_STATUS_XLMAC_INTR_MASK
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_MASK_STATUS_XLMAC_INTR_MASK_FIELD =
{
    "XLMAC_INTR_MASK",
#if RU_INCLUDE_DESC
    "",
    "This bit corresponds to the mask for xlmac interrupt. See register description above for details of how to use this bit.",
#endif
    XPORT_INTR_CPU_MASK_STATUS_XLMAC_INTR_MASK_FIELD_MASK,
    0,
    XPORT_INTR_CPU_MASK_STATUS_XLMAC_INTR_MASK_FIELD_WIDTH,
    XPORT_INTR_CPU_MASK_STATUS_XLMAC_INTR_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_MASK_STATUS_MAC_REG_ERR_INTR_MASK
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_MASK_STATUS_MAC_REG_ERR_INTR_MASK_FIELD =
{
    "MAC_REG_ERR_INTR_MASK",
#if RU_INCLUDE_DESC
    "",
    "This bit corresponds to the mask for mac register error interrupt. See register description above for details of how to use this bit.",
#endif
    XPORT_INTR_CPU_MASK_STATUS_MAC_REG_ERR_INTR_MASK_FIELD_MASK,
    0,
    XPORT_INTR_CPU_MASK_STATUS_MAC_REG_ERR_INTR_MASK_FIELD_WIDTH,
    XPORT_INTR_CPU_MASK_STATUS_MAC_REG_ERR_INTR_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_MASK_STATUS_MAB_STATUS_INTR_MASK
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_MASK_STATUS_MAB_STATUS_INTR_MASK_FIELD =
{
    "MAB_STATUS_INTR_MASK",
#if RU_INCLUDE_DESC
    "",
    "This bit corresponds to the mask for msbus adaptation block status interrupt. See register description above for details of how to use this bit.",
#endif
    XPORT_INTR_CPU_MASK_STATUS_MAB_STATUS_INTR_MASK_FIELD_MASK,
    0,
    XPORT_INTR_CPU_MASK_STATUS_MAB_STATUS_INTR_MASK_FIELD_WIDTH,
    XPORT_INTR_CPU_MASK_STATUS_MAB_STATUS_INTR_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_MASK_STATUS_MIB_REG_ERR_INTR_MASK
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_MASK_STATUS_MIB_REG_ERR_INTR_MASK_FIELD =
{
    "MIB_REG_ERR_INTR_MASK",
#if RU_INCLUDE_DESC
    "",
    "This bit corresponds to the mask for mib register error interrupt. See register description above for details of how to use this bit.",
#endif
    XPORT_INTR_CPU_MASK_STATUS_MIB_REG_ERR_INTR_MASK_FIELD_MASK,
    0,
    XPORT_INTR_CPU_MASK_STATUS_MIB_REG_ERR_INTR_MASK_FIELD_WIDTH,
    XPORT_INTR_CPU_MASK_STATUS_MIB_REG_ERR_INTR_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_MASK_STATUS_UBUS_ERR_INTR_MASK
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_MASK_STATUS_UBUS_ERR_INTR_MASK_FIELD =
{
    "UBUS_ERR_INTR_MASK",
#if RU_INCLUDE_DESC
    "",
    "This bit corresponds to the mask for ubus error interrupt. See register description above for details of how to use this bit.",
#endif
    XPORT_INTR_CPU_MASK_STATUS_UBUS_ERR_INTR_MASK_FIELD_MASK,
    0,
    XPORT_INTR_CPU_MASK_STATUS_UBUS_ERR_INTR_MASK_FIELD_WIDTH,
    XPORT_INTR_CPU_MASK_STATUS_UBUS_ERR_INTR_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_MASK_SET_RESERVED0
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_MASK_SET_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    XPORT_INTR_CPU_MASK_SET_RESERVED0_FIELD_MASK,
    0,
    XPORT_INTR_CPU_MASK_SET_RESERVED0_FIELD_WIDTH,
    XPORT_INTR_CPU_MASK_SET_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_MASK_SET_LINK_DOWN_INTR_MASK
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_MASK_SET_LINK_DOWN_INTR_MASK_FIELD =
{
    "LINK_DOWN_INTR_MASK",
#if RU_INCLUDE_DESC
    "",
    "This bit corresponds to the mask for link down interrupt. See register description above for details of how to use this bit.",
#endif
    XPORT_INTR_CPU_MASK_SET_LINK_DOWN_INTR_MASK_FIELD_MASK,
    0,
    XPORT_INTR_CPU_MASK_SET_LINK_DOWN_INTR_MASK_FIELD_WIDTH,
    XPORT_INTR_CPU_MASK_SET_LINK_DOWN_INTR_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_MASK_SET_LINK_UP_INTR_MASK
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_MASK_SET_LINK_UP_INTR_MASK_FIELD =
{
    "LINK_UP_INTR_MASK",
#if RU_INCLUDE_DESC
    "",
    "This bit corresponds to the mask for link up interrupt. See register description above for details of how to use this bit.",
#endif
    XPORT_INTR_CPU_MASK_SET_LINK_UP_INTR_MASK_FIELD_MASK,
    0,
    XPORT_INTR_CPU_MASK_SET_LINK_UP_INTR_MASK_FIELD_WIDTH,
    XPORT_INTR_CPU_MASK_SET_LINK_UP_INTR_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_MASK_SET_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_MASK
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_MASK_SET_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_MASK_FIELD =
{
    "TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_MASK",
#if RU_INCLUDE_DESC
    "",
    "This bit corresponds to the mask for  tx timesync fifo entry valid interrupt. See register description above for details of how to use this bit.",
#endif
    XPORT_INTR_CPU_MASK_SET_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_MASK_FIELD_MASK,
    0,
    XPORT_INTR_CPU_MASK_SET_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_MASK_FIELD_WIDTH,
    XPORT_INTR_CPU_MASK_SET_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_MASK_SET_XLMAC_INTR_MASK
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_MASK_SET_XLMAC_INTR_MASK_FIELD =
{
    "XLMAC_INTR_MASK",
#if RU_INCLUDE_DESC
    "",
    "This bit corresponds to the mask for xlmac interrupt. See register description above for details of how to use this bit.",
#endif
    XPORT_INTR_CPU_MASK_SET_XLMAC_INTR_MASK_FIELD_MASK,
    0,
    XPORT_INTR_CPU_MASK_SET_XLMAC_INTR_MASK_FIELD_WIDTH,
    XPORT_INTR_CPU_MASK_SET_XLMAC_INTR_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_MASK_SET_MAC_REG_ERR_INTR_MASK
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_MASK_SET_MAC_REG_ERR_INTR_MASK_FIELD =
{
    "MAC_REG_ERR_INTR_MASK",
#if RU_INCLUDE_DESC
    "",
    "This bit corresponds to the mask for mac register error interrupt. See register description above for details of how to use this bit.",
#endif
    XPORT_INTR_CPU_MASK_SET_MAC_REG_ERR_INTR_MASK_FIELD_MASK,
    0,
    XPORT_INTR_CPU_MASK_SET_MAC_REG_ERR_INTR_MASK_FIELD_WIDTH,
    XPORT_INTR_CPU_MASK_SET_MAC_REG_ERR_INTR_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_MASK_SET_MAB_STATUS_INTR_MASK
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_MASK_SET_MAB_STATUS_INTR_MASK_FIELD =
{
    "MAB_STATUS_INTR_MASK",
#if RU_INCLUDE_DESC
    "",
    "This bit corresponds to the mask for msbus adaptation block status interrupt. See register description above for details of how to use this bit.",
#endif
    XPORT_INTR_CPU_MASK_SET_MAB_STATUS_INTR_MASK_FIELD_MASK,
    0,
    XPORT_INTR_CPU_MASK_SET_MAB_STATUS_INTR_MASK_FIELD_WIDTH,
    XPORT_INTR_CPU_MASK_SET_MAB_STATUS_INTR_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_MASK_SET_MIB_REG_ERR_INTR_MASK
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_MASK_SET_MIB_REG_ERR_INTR_MASK_FIELD =
{
    "MIB_REG_ERR_INTR_MASK",
#if RU_INCLUDE_DESC
    "",
    "This bit corresponds to the mask for mib register error interrupt. See register description above for details of how to use this bit.",
#endif
    XPORT_INTR_CPU_MASK_SET_MIB_REG_ERR_INTR_MASK_FIELD_MASK,
    0,
    XPORT_INTR_CPU_MASK_SET_MIB_REG_ERR_INTR_MASK_FIELD_WIDTH,
    XPORT_INTR_CPU_MASK_SET_MIB_REG_ERR_INTR_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_MASK_SET_UBUS_ERR_INTR_MASK
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_MASK_SET_UBUS_ERR_INTR_MASK_FIELD =
{
    "UBUS_ERR_INTR_MASK",
#if RU_INCLUDE_DESC
    "",
    "This bit corresponds to the mask for ubus error interrupt. See register description above for details of how to use this bit.",
#endif
    XPORT_INTR_CPU_MASK_SET_UBUS_ERR_INTR_MASK_FIELD_MASK,
    0,
    XPORT_INTR_CPU_MASK_SET_UBUS_ERR_INTR_MASK_FIELD_WIDTH,
    XPORT_INTR_CPU_MASK_SET_UBUS_ERR_INTR_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_MASK_CLEAR_RESERVED0
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_MASK_CLEAR_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    XPORT_INTR_CPU_MASK_CLEAR_RESERVED0_FIELD_MASK,
    0,
    XPORT_INTR_CPU_MASK_CLEAR_RESERVED0_FIELD_WIDTH,
    XPORT_INTR_CPU_MASK_CLEAR_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_MASK_CLEAR_LINK_DOWN_INTR_MASK
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_MASK_CLEAR_LINK_DOWN_INTR_MASK_FIELD =
{
    "LINK_DOWN_INTR_MASK",
#if RU_INCLUDE_DESC
    "",
    "This bit corresponds to the mask for link down interrupt. See register description above for details of how to use this bit.",
#endif
    XPORT_INTR_CPU_MASK_CLEAR_LINK_DOWN_INTR_MASK_FIELD_MASK,
    0,
    XPORT_INTR_CPU_MASK_CLEAR_LINK_DOWN_INTR_MASK_FIELD_WIDTH,
    XPORT_INTR_CPU_MASK_CLEAR_LINK_DOWN_INTR_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_MASK_CLEAR_LINK_UP_INTR_MASK
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_MASK_CLEAR_LINK_UP_INTR_MASK_FIELD =
{
    "LINK_UP_INTR_MASK",
#if RU_INCLUDE_DESC
    "",
    "This bit corresponds to the mask for link up interrupt. See register description above for details of how to use this bit.",
#endif
    XPORT_INTR_CPU_MASK_CLEAR_LINK_UP_INTR_MASK_FIELD_MASK,
    0,
    XPORT_INTR_CPU_MASK_CLEAR_LINK_UP_INTR_MASK_FIELD_WIDTH,
    XPORT_INTR_CPU_MASK_CLEAR_LINK_UP_INTR_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_MASK_CLEAR_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_MASK
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_MASK_CLEAR_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_MASK_FIELD =
{
    "TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_MASK",
#if RU_INCLUDE_DESC
    "",
    "This bit corresponds to the mask for  tx timesync fifo entry valid interrupt. See register description above for details of how to use this bit.",
#endif
    XPORT_INTR_CPU_MASK_CLEAR_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_MASK_FIELD_MASK,
    0,
    XPORT_INTR_CPU_MASK_CLEAR_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_MASK_FIELD_WIDTH,
    XPORT_INTR_CPU_MASK_CLEAR_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_MASK_CLEAR_XLMAC_INTR_MASK
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_MASK_CLEAR_XLMAC_INTR_MASK_FIELD =
{
    "XLMAC_INTR_MASK",
#if RU_INCLUDE_DESC
    "",
    "This bit corresponds to the mask for xlmac interrupt. See register description above for details of how to use this bit.",
#endif
    XPORT_INTR_CPU_MASK_CLEAR_XLMAC_INTR_MASK_FIELD_MASK,
    0,
    XPORT_INTR_CPU_MASK_CLEAR_XLMAC_INTR_MASK_FIELD_WIDTH,
    XPORT_INTR_CPU_MASK_CLEAR_XLMAC_INTR_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_MASK_CLEAR_MAC_REG_ERR_INTR_MASK
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_MASK_CLEAR_MAC_REG_ERR_INTR_MASK_FIELD =
{
    "MAC_REG_ERR_INTR_MASK",
#if RU_INCLUDE_DESC
    "",
    "This bit corresponds to the mask for mac register error interrupt. See register description above for details of how to use this bit.",
#endif
    XPORT_INTR_CPU_MASK_CLEAR_MAC_REG_ERR_INTR_MASK_FIELD_MASK,
    0,
    XPORT_INTR_CPU_MASK_CLEAR_MAC_REG_ERR_INTR_MASK_FIELD_WIDTH,
    XPORT_INTR_CPU_MASK_CLEAR_MAC_REG_ERR_INTR_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_MASK_CLEAR_MAB_STATUS_INTR_MASK
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_MASK_CLEAR_MAB_STATUS_INTR_MASK_FIELD =
{
    "MAB_STATUS_INTR_MASK",
#if RU_INCLUDE_DESC
    "",
    "This bit corresponds to the mask for msbus adaptation block status interrupt. See register description above for details of how to use this bit.",
#endif
    XPORT_INTR_CPU_MASK_CLEAR_MAB_STATUS_INTR_MASK_FIELD_MASK,
    0,
    XPORT_INTR_CPU_MASK_CLEAR_MAB_STATUS_INTR_MASK_FIELD_WIDTH,
    XPORT_INTR_CPU_MASK_CLEAR_MAB_STATUS_INTR_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_MASK_CLEAR_MIB_REG_ERR_INTR_MASK
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_MASK_CLEAR_MIB_REG_ERR_INTR_MASK_FIELD =
{
    "MIB_REG_ERR_INTR_MASK",
#if RU_INCLUDE_DESC
    "",
    "This bit corresponds to the mask for mib register error interrupt. See register description above for details of how to use this bit.",
#endif
    XPORT_INTR_CPU_MASK_CLEAR_MIB_REG_ERR_INTR_MASK_FIELD_MASK,
    0,
    XPORT_INTR_CPU_MASK_CLEAR_MIB_REG_ERR_INTR_MASK_FIELD_WIDTH,
    XPORT_INTR_CPU_MASK_CLEAR_MIB_REG_ERR_INTR_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_CPU_MASK_CLEAR_UBUS_ERR_INTR_MASK
 ******************************************************************************/
const ru_field_rec XPORT_INTR_CPU_MASK_CLEAR_UBUS_ERR_INTR_MASK_FIELD =
{
    "UBUS_ERR_INTR_MASK",
#if RU_INCLUDE_DESC
    "",
    "This bit corresponds to the mask for ubus error interrupt. See register description above for details of how to use this bit.",
#endif
    XPORT_INTR_CPU_MASK_CLEAR_UBUS_ERR_INTR_MASK_FIELD_MASK,
    0,
    XPORT_INTR_CPU_MASK_CLEAR_UBUS_ERR_INTR_MASK_FIELD_WIDTH,
    XPORT_INTR_CPU_MASK_CLEAR_UBUS_ERR_INTR_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_STATUS_RESERVED0
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_STATUS_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    XPORT_INTR_PCI_STATUS_RESERVED0_FIELD_MASK,
    0,
    XPORT_INTR_PCI_STATUS_RESERVED0_FIELD_WIDTH,
    XPORT_INTR_PCI_STATUS_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_STATUS_LINK_DOWN_INTR
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_STATUS_LINK_DOWN_INTR_FIELD =
{
    "LINK_DOWN_INTR",
#if RU_INCLUDE_DESC
    "",
    "Link down interrupt for P3:P0. Interrupt corresponds to the attached PHY/interface link down event.",
#endif
    XPORT_INTR_PCI_STATUS_LINK_DOWN_INTR_FIELD_MASK,
    0,
    XPORT_INTR_PCI_STATUS_LINK_DOWN_INTR_FIELD_WIDTH,
    XPORT_INTR_PCI_STATUS_LINK_DOWN_INTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_STATUS_LINK_UP_INTR
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_STATUS_LINK_UP_INTR_FIELD =
{
    "LINK_UP_INTR",
#if RU_INCLUDE_DESC
    "",
    "Link up interrupt for P3:P0. Interrupt corresponds to the attached PHY/interface link up event.",
#endif
    XPORT_INTR_PCI_STATUS_LINK_UP_INTR_FIELD_MASK,
    0,
    XPORT_INTR_PCI_STATUS_LINK_UP_INTR_FIELD_WIDTH,
    XPORT_INTR_PCI_STATUS_LINK_UP_INTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_STATUS_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_STATUS_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_FIELD =
{
    "TX_TIMESYNC_FIFO_ENTRY_VALID_INTR",
#if RU_INCLUDE_DESC
    "",
    "PTP timestamp available for read. Bits [3:0] correspond to XLMAC ports 3 down to 0.",
#endif
    XPORT_INTR_PCI_STATUS_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_FIELD_MASK,
    0,
    XPORT_INTR_PCI_STATUS_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_FIELD_WIDTH,
    XPORT_INTR_PCI_STATUS_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_STATUS_XLMAC_INTR
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_STATUS_XLMAC_INTR_FIELD =
{
    "XLMAC_INTR",
#if RU_INCLUDE_DESC
    "",
    "Interrupt generated by XLMAC signaling various events as described in XLMAC_INTR_STATUS."
    "Bits [3:0] correspond to XLMAC ports 3 down to 0.",
#endif
    XPORT_INTR_PCI_STATUS_XLMAC_INTR_FIELD_MASK,
    0,
    XPORT_INTR_PCI_STATUS_XLMAC_INTR_FIELD_WIDTH,
    XPORT_INTR_PCI_STATUS_XLMAC_INTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_STATUS_MAC_REG_ERR_INTR
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_STATUS_MAC_REG_ERR_INTR_FIELD =
{
    "MAC_REG_ERR_INTR",
#if RU_INCLUDE_DESC
    "",
    "mac_reg_err_intr.\n"
    "XLMAC register transaction error",
#endif
    XPORT_INTR_PCI_STATUS_MAC_REG_ERR_INTR_FIELD_MASK,
    0,
    XPORT_INTR_PCI_STATUS_MAC_REG_ERR_INTR_FIELD_WIDTH,
    XPORT_INTR_PCI_STATUS_MAC_REG_ERR_INTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_STATUS_MAB_STATUS_INTR
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_STATUS_MAB_STATUS_INTR_FIELD =
{
    "MAB_STATUS_INTR",
#if RU_INCLUDE_DESC
    "",
    "Asserted when any of statuses get set in MSBUS Adaptation Block Status Register(s).",
#endif
    XPORT_INTR_PCI_STATUS_MAB_STATUS_INTR_FIELD_MASK,
    0,
    XPORT_INTR_PCI_STATUS_MAB_STATUS_INTR_FIELD_WIDTH,
    XPORT_INTR_PCI_STATUS_MAB_STATUS_INTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_STATUS_MIB_REG_ERR_INTR
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_STATUS_MIB_REG_ERR_INTR_FIELD =
{
    "MIB_REG_ERR_INTR",
#if RU_INCLUDE_DESC
    "",
    "mib_reg_err_intr.\n"
    "MIB register transaction error.",
#endif
    XPORT_INTR_PCI_STATUS_MIB_REG_ERR_INTR_FIELD_MASK,
    0,
    XPORT_INTR_PCI_STATUS_MIB_REG_ERR_INTR_FIELD_WIDTH,
    XPORT_INTR_PCI_STATUS_MIB_REG_ERR_INTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_STATUS_UBUS_ERR_INTR
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_STATUS_UBUS_ERR_INTR_FIELD =
{
    "UBUS_ERR_INTR",
#if RU_INCLUDE_DESC
    "",
    "UBUS transaction error.",
#endif
    XPORT_INTR_PCI_STATUS_UBUS_ERR_INTR_FIELD_MASK,
    0,
    XPORT_INTR_PCI_STATUS_UBUS_ERR_INTR_FIELD_WIDTH,
    XPORT_INTR_PCI_STATUS_UBUS_ERR_INTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_SET_RESERVED0
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_SET_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    XPORT_INTR_PCI_SET_RESERVED0_FIELD_MASK,
    0,
    XPORT_INTR_PCI_SET_RESERVED0_FIELD_WIDTH,
    XPORT_INTR_PCI_SET_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_SET_LINK_DOWN_INTR
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_SET_LINK_DOWN_INTR_FIELD =
{
    "LINK_DOWN_INTR",
#if RU_INCLUDE_DESC
    "",
    "Link down interrupt for P3:P0. Interrupt corresponds to the attached PHY/interface link down event.",
#endif
    XPORT_INTR_PCI_SET_LINK_DOWN_INTR_FIELD_MASK,
    0,
    XPORT_INTR_PCI_SET_LINK_DOWN_INTR_FIELD_WIDTH,
    XPORT_INTR_PCI_SET_LINK_DOWN_INTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_SET_LINK_UP_INTR
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_SET_LINK_UP_INTR_FIELD =
{
    "LINK_UP_INTR",
#if RU_INCLUDE_DESC
    "",
    "Link up interrupt for P3:P0. Interrupt corresponds to the attached PHY/interface link up event.",
#endif
    XPORT_INTR_PCI_SET_LINK_UP_INTR_FIELD_MASK,
    0,
    XPORT_INTR_PCI_SET_LINK_UP_INTR_FIELD_WIDTH,
    XPORT_INTR_PCI_SET_LINK_UP_INTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_SET_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_SET_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_FIELD =
{
    "TX_TIMESYNC_FIFO_ENTRY_VALID_INTR",
#if RU_INCLUDE_DESC
    "",
    "PTP timestamp available for read. Bits [3:0] correspond to XLMAC ports 3 down to 0.",
#endif
    XPORT_INTR_PCI_SET_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_FIELD_MASK,
    0,
    XPORT_INTR_PCI_SET_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_FIELD_WIDTH,
    XPORT_INTR_PCI_SET_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_SET_XLMAC_INTR
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_SET_XLMAC_INTR_FIELD =
{
    "XLMAC_INTR",
#if RU_INCLUDE_DESC
    "",
    "Interrupt generated by XLMAC signaling various events as described in XLMAC_INTR_STATUS."
    "Bits [3:0] correspond to XLMAC ports 3 down to 0.",
#endif
    XPORT_INTR_PCI_SET_XLMAC_INTR_FIELD_MASK,
    0,
    XPORT_INTR_PCI_SET_XLMAC_INTR_FIELD_WIDTH,
    XPORT_INTR_PCI_SET_XLMAC_INTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_SET_MAC_REG_ERR_INTR
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_SET_MAC_REG_ERR_INTR_FIELD =
{
    "MAC_REG_ERR_INTR",
#if RU_INCLUDE_DESC
    "",
    "mac_reg_err_intr.\n"
    "XLMAC register transaction error",
#endif
    XPORT_INTR_PCI_SET_MAC_REG_ERR_INTR_FIELD_MASK,
    0,
    XPORT_INTR_PCI_SET_MAC_REG_ERR_INTR_FIELD_WIDTH,
    XPORT_INTR_PCI_SET_MAC_REG_ERR_INTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_SET_MAB_STATUS_INTR
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_SET_MAB_STATUS_INTR_FIELD =
{
    "MAB_STATUS_INTR",
#if RU_INCLUDE_DESC
    "",
    "Asserted when any of statuses get set in MSBUS Adaptation Block Status Register(s).",
#endif
    XPORT_INTR_PCI_SET_MAB_STATUS_INTR_FIELD_MASK,
    0,
    XPORT_INTR_PCI_SET_MAB_STATUS_INTR_FIELD_WIDTH,
    XPORT_INTR_PCI_SET_MAB_STATUS_INTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_SET_MIB_REG_ERR_INTR
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_SET_MIB_REG_ERR_INTR_FIELD =
{
    "MIB_REG_ERR_INTR",
#if RU_INCLUDE_DESC
    "",
    "mib_reg_err_intr.\n"
    "MIB register transaction error.",
#endif
    XPORT_INTR_PCI_SET_MIB_REG_ERR_INTR_FIELD_MASK,
    0,
    XPORT_INTR_PCI_SET_MIB_REG_ERR_INTR_FIELD_WIDTH,
    XPORT_INTR_PCI_SET_MIB_REG_ERR_INTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_SET_UBUS_ERR_INTR
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_SET_UBUS_ERR_INTR_FIELD =
{
    "UBUS_ERR_INTR",
#if RU_INCLUDE_DESC
    "",
    "UBUS transaction error.",
#endif
    XPORT_INTR_PCI_SET_UBUS_ERR_INTR_FIELD_MASK,
    0,
    XPORT_INTR_PCI_SET_UBUS_ERR_INTR_FIELD_WIDTH,
    XPORT_INTR_PCI_SET_UBUS_ERR_INTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_CLEAR_RESERVED0
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_CLEAR_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    XPORT_INTR_PCI_CLEAR_RESERVED0_FIELD_MASK,
    0,
    XPORT_INTR_PCI_CLEAR_RESERVED0_FIELD_WIDTH,
    XPORT_INTR_PCI_CLEAR_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_CLEAR_LINK_DOWN_INTR
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_CLEAR_LINK_DOWN_INTR_FIELD =
{
    "LINK_DOWN_INTR",
#if RU_INCLUDE_DESC
    "",
    "Link down interrupt for P3:P0. Interrupt corresponds to the attached PHY/interface link down event.",
#endif
    XPORT_INTR_PCI_CLEAR_LINK_DOWN_INTR_FIELD_MASK,
    0,
    XPORT_INTR_PCI_CLEAR_LINK_DOWN_INTR_FIELD_WIDTH,
    XPORT_INTR_PCI_CLEAR_LINK_DOWN_INTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_CLEAR_LINK_UP_INTR
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_CLEAR_LINK_UP_INTR_FIELD =
{
    "LINK_UP_INTR",
#if RU_INCLUDE_DESC
    "",
    "Link up interrupt for P3:P0. Interrupt corresponds to the attached PHY/interface link up event.",
#endif
    XPORT_INTR_PCI_CLEAR_LINK_UP_INTR_FIELD_MASK,
    0,
    XPORT_INTR_PCI_CLEAR_LINK_UP_INTR_FIELD_WIDTH,
    XPORT_INTR_PCI_CLEAR_LINK_UP_INTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_CLEAR_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_CLEAR_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_FIELD =
{
    "TX_TIMESYNC_FIFO_ENTRY_VALID_INTR",
#if RU_INCLUDE_DESC
    "",
    "PTP timestamp available for read. Bits [3:0] correspond to XLMAC ports 3 down to 0.",
#endif
    XPORT_INTR_PCI_CLEAR_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_FIELD_MASK,
    0,
    XPORT_INTR_PCI_CLEAR_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_FIELD_WIDTH,
    XPORT_INTR_PCI_CLEAR_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_CLEAR_XLMAC_INTR
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_CLEAR_XLMAC_INTR_FIELD =
{
    "XLMAC_INTR",
#if RU_INCLUDE_DESC
    "",
    "Interrupt generated by XLMAC signaling various events as described in XLMAC_INTR_STATUS."
    "Bits [3:0] correspond to XLMAC ports 3 down to 0.",
#endif
    XPORT_INTR_PCI_CLEAR_XLMAC_INTR_FIELD_MASK,
    0,
    XPORT_INTR_PCI_CLEAR_XLMAC_INTR_FIELD_WIDTH,
    XPORT_INTR_PCI_CLEAR_XLMAC_INTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_CLEAR_MAC_REG_ERR_INTR
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_CLEAR_MAC_REG_ERR_INTR_FIELD =
{
    "MAC_REG_ERR_INTR",
#if RU_INCLUDE_DESC
    "",
    "mac_reg_err_intr.\n"
    "XLMAC register transaction error",
#endif
    XPORT_INTR_PCI_CLEAR_MAC_REG_ERR_INTR_FIELD_MASK,
    0,
    XPORT_INTR_PCI_CLEAR_MAC_REG_ERR_INTR_FIELD_WIDTH,
    XPORT_INTR_PCI_CLEAR_MAC_REG_ERR_INTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_CLEAR_MAB_STATUS_INTR
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_CLEAR_MAB_STATUS_INTR_FIELD =
{
    "MAB_STATUS_INTR",
#if RU_INCLUDE_DESC
    "",
    "Asserted when any of statuses get set in MSBUS Adaptation Block Status Register(s).",
#endif
    XPORT_INTR_PCI_CLEAR_MAB_STATUS_INTR_FIELD_MASK,
    0,
    XPORT_INTR_PCI_CLEAR_MAB_STATUS_INTR_FIELD_WIDTH,
    XPORT_INTR_PCI_CLEAR_MAB_STATUS_INTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_CLEAR_MIB_REG_ERR_INTR
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_CLEAR_MIB_REG_ERR_INTR_FIELD =
{
    "MIB_REG_ERR_INTR",
#if RU_INCLUDE_DESC
    "",
    "mib_reg_err_intr.\n"
    "MIB register transaction error.",
#endif
    XPORT_INTR_PCI_CLEAR_MIB_REG_ERR_INTR_FIELD_MASK,
    0,
    XPORT_INTR_PCI_CLEAR_MIB_REG_ERR_INTR_FIELD_WIDTH,
    XPORT_INTR_PCI_CLEAR_MIB_REG_ERR_INTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_CLEAR_UBUS_ERR_INTR
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_CLEAR_UBUS_ERR_INTR_FIELD =
{
    "UBUS_ERR_INTR",
#if RU_INCLUDE_DESC
    "",
    "UBUS transaction error.",
#endif
    XPORT_INTR_PCI_CLEAR_UBUS_ERR_INTR_FIELD_MASK,
    0,
    XPORT_INTR_PCI_CLEAR_UBUS_ERR_INTR_FIELD_WIDTH,
    XPORT_INTR_PCI_CLEAR_UBUS_ERR_INTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_MASK_STATUS_RESERVED0
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_MASK_STATUS_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    XPORT_INTR_PCI_MASK_STATUS_RESERVED0_FIELD_MASK,
    0,
    XPORT_INTR_PCI_MASK_STATUS_RESERVED0_FIELD_WIDTH,
    XPORT_INTR_PCI_MASK_STATUS_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_MASK_STATUS_LINK_DOWN_INTR_MASK
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_MASK_STATUS_LINK_DOWN_INTR_MASK_FIELD =
{
    "LINK_DOWN_INTR_MASK",
#if RU_INCLUDE_DESC
    "",
    "This bit corresponds to the mask for link down interrupt. See register description above for details of how to use this bit.",
#endif
    XPORT_INTR_PCI_MASK_STATUS_LINK_DOWN_INTR_MASK_FIELD_MASK,
    0,
    XPORT_INTR_PCI_MASK_STATUS_LINK_DOWN_INTR_MASK_FIELD_WIDTH,
    XPORT_INTR_PCI_MASK_STATUS_LINK_DOWN_INTR_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_MASK_STATUS_LINK_UP_INTR_MASK
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_MASK_STATUS_LINK_UP_INTR_MASK_FIELD =
{
    "LINK_UP_INTR_MASK",
#if RU_INCLUDE_DESC
    "",
    "This bit corresponds to the mask for link up interrupt. See register description above for details of how to use this bit.",
#endif
    XPORT_INTR_PCI_MASK_STATUS_LINK_UP_INTR_MASK_FIELD_MASK,
    0,
    XPORT_INTR_PCI_MASK_STATUS_LINK_UP_INTR_MASK_FIELD_WIDTH,
    XPORT_INTR_PCI_MASK_STATUS_LINK_UP_INTR_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_MASK_STATUS_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_MASK
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_MASK_STATUS_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_MASK_FIELD =
{
    "TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_MASK",
#if RU_INCLUDE_DESC
    "",
    "This bit corresponds to the mask for  tx timesync fifo entry valid interrupt. See register description above for details of how to use this bit.",
#endif
    XPORT_INTR_PCI_MASK_STATUS_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_MASK_FIELD_MASK,
    0,
    XPORT_INTR_PCI_MASK_STATUS_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_MASK_FIELD_WIDTH,
    XPORT_INTR_PCI_MASK_STATUS_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_MASK_STATUS_XLMAC_INTR_MASK
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_MASK_STATUS_XLMAC_INTR_MASK_FIELD =
{
    "XLMAC_INTR_MASK",
#if RU_INCLUDE_DESC
    "",
    "This bit corresponds to the mask for xlmac interrupt. See register description above for details of how to use this bit.",
#endif
    XPORT_INTR_PCI_MASK_STATUS_XLMAC_INTR_MASK_FIELD_MASK,
    0,
    XPORT_INTR_PCI_MASK_STATUS_XLMAC_INTR_MASK_FIELD_WIDTH,
    XPORT_INTR_PCI_MASK_STATUS_XLMAC_INTR_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_MASK_STATUS_MAC_REG_ERR_INTR_MASK
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_MASK_STATUS_MAC_REG_ERR_INTR_MASK_FIELD =
{
    "MAC_REG_ERR_INTR_MASK",
#if RU_INCLUDE_DESC
    "",
    "This bit corresponds to the mask for mac register error interrupt. See register description above for details of how to use this bit.",
#endif
    XPORT_INTR_PCI_MASK_STATUS_MAC_REG_ERR_INTR_MASK_FIELD_MASK,
    0,
    XPORT_INTR_PCI_MASK_STATUS_MAC_REG_ERR_INTR_MASK_FIELD_WIDTH,
    XPORT_INTR_PCI_MASK_STATUS_MAC_REG_ERR_INTR_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_MASK_STATUS_MAB_STATUS_INTR_MASK
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_MASK_STATUS_MAB_STATUS_INTR_MASK_FIELD =
{
    "MAB_STATUS_INTR_MASK",
#if RU_INCLUDE_DESC
    "",
    "This bit corresponds to the mask for msbus adaptation block status interrupt. See register description above for details of how to use this bit.",
#endif
    XPORT_INTR_PCI_MASK_STATUS_MAB_STATUS_INTR_MASK_FIELD_MASK,
    0,
    XPORT_INTR_PCI_MASK_STATUS_MAB_STATUS_INTR_MASK_FIELD_WIDTH,
    XPORT_INTR_PCI_MASK_STATUS_MAB_STATUS_INTR_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_MASK_STATUS_MIB_REG_ERR_INTR_MASK
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_MASK_STATUS_MIB_REG_ERR_INTR_MASK_FIELD =
{
    "MIB_REG_ERR_INTR_MASK",
#if RU_INCLUDE_DESC
    "",
    "This bit corresponds to the mask for mib register error interrupt. See register description above for details of how to use this bit.",
#endif
    XPORT_INTR_PCI_MASK_STATUS_MIB_REG_ERR_INTR_MASK_FIELD_MASK,
    0,
    XPORT_INTR_PCI_MASK_STATUS_MIB_REG_ERR_INTR_MASK_FIELD_WIDTH,
    XPORT_INTR_PCI_MASK_STATUS_MIB_REG_ERR_INTR_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_MASK_STATUS_UBUS_ERR_INTR_MASK
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_MASK_STATUS_UBUS_ERR_INTR_MASK_FIELD =
{
    "UBUS_ERR_INTR_MASK",
#if RU_INCLUDE_DESC
    "",
    "This bit corresponds to the mask for ubus error interrupt. See register description above for details of how to use this bit.",
#endif
    XPORT_INTR_PCI_MASK_STATUS_UBUS_ERR_INTR_MASK_FIELD_MASK,
    0,
    XPORT_INTR_PCI_MASK_STATUS_UBUS_ERR_INTR_MASK_FIELD_WIDTH,
    XPORT_INTR_PCI_MASK_STATUS_UBUS_ERR_INTR_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_MASK_SET_RESERVED0
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_MASK_SET_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    XPORT_INTR_PCI_MASK_SET_RESERVED0_FIELD_MASK,
    0,
    XPORT_INTR_PCI_MASK_SET_RESERVED0_FIELD_WIDTH,
    XPORT_INTR_PCI_MASK_SET_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_MASK_SET_LINK_DOWN_INTR_MASK
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_MASK_SET_LINK_DOWN_INTR_MASK_FIELD =
{
    "LINK_DOWN_INTR_MASK",
#if RU_INCLUDE_DESC
    "",
    "This bit corresponds to the mask for link down interrupt. See register description above for details of how to use this bit.",
#endif
    XPORT_INTR_PCI_MASK_SET_LINK_DOWN_INTR_MASK_FIELD_MASK,
    0,
    XPORT_INTR_PCI_MASK_SET_LINK_DOWN_INTR_MASK_FIELD_WIDTH,
    XPORT_INTR_PCI_MASK_SET_LINK_DOWN_INTR_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_MASK_SET_LINK_UP_INTR_MASK
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_MASK_SET_LINK_UP_INTR_MASK_FIELD =
{
    "LINK_UP_INTR_MASK",
#if RU_INCLUDE_DESC
    "",
    "This bit corresponds to the mask for link up interrupt. See register description above for details of how to use this bit.",
#endif
    XPORT_INTR_PCI_MASK_SET_LINK_UP_INTR_MASK_FIELD_MASK,
    0,
    XPORT_INTR_PCI_MASK_SET_LINK_UP_INTR_MASK_FIELD_WIDTH,
    XPORT_INTR_PCI_MASK_SET_LINK_UP_INTR_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_MASK_SET_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_MASK
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_MASK_SET_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_MASK_FIELD =
{
    "TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_MASK",
#if RU_INCLUDE_DESC
    "",
    "This bit corresponds to the mask for  tx timesync fifo entry valid interrupt. See register description above for details of how to use this bit.",
#endif
    XPORT_INTR_PCI_MASK_SET_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_MASK_FIELD_MASK,
    0,
    XPORT_INTR_PCI_MASK_SET_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_MASK_FIELD_WIDTH,
    XPORT_INTR_PCI_MASK_SET_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_MASK_SET_XLMAC_INTR_MASK
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_MASK_SET_XLMAC_INTR_MASK_FIELD =
{
    "XLMAC_INTR_MASK",
#if RU_INCLUDE_DESC
    "",
    "This bit corresponds to the mask for xlmac interrupt. See register description above for details of how to use this bit.",
#endif
    XPORT_INTR_PCI_MASK_SET_XLMAC_INTR_MASK_FIELD_MASK,
    0,
    XPORT_INTR_PCI_MASK_SET_XLMAC_INTR_MASK_FIELD_WIDTH,
    XPORT_INTR_PCI_MASK_SET_XLMAC_INTR_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_MASK_SET_MAC_REG_ERR_INTR_MASK
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_MASK_SET_MAC_REG_ERR_INTR_MASK_FIELD =
{
    "MAC_REG_ERR_INTR_MASK",
#if RU_INCLUDE_DESC
    "",
    "This bit corresponds to the mask for mac register error interrupt. See register description above for details of how to use this bit.",
#endif
    XPORT_INTR_PCI_MASK_SET_MAC_REG_ERR_INTR_MASK_FIELD_MASK,
    0,
    XPORT_INTR_PCI_MASK_SET_MAC_REG_ERR_INTR_MASK_FIELD_WIDTH,
    XPORT_INTR_PCI_MASK_SET_MAC_REG_ERR_INTR_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_MASK_SET_MAB_STATUS_INTR_MASK
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_MASK_SET_MAB_STATUS_INTR_MASK_FIELD =
{
    "MAB_STATUS_INTR_MASK",
#if RU_INCLUDE_DESC
    "",
    "This bit corresponds to the mask for msbus adaptation block status interrupt. See register description above for details of how to use this bit.",
#endif
    XPORT_INTR_PCI_MASK_SET_MAB_STATUS_INTR_MASK_FIELD_MASK,
    0,
    XPORT_INTR_PCI_MASK_SET_MAB_STATUS_INTR_MASK_FIELD_WIDTH,
    XPORT_INTR_PCI_MASK_SET_MAB_STATUS_INTR_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_MASK_SET_MIB_REG_ERR_INTR_MASK
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_MASK_SET_MIB_REG_ERR_INTR_MASK_FIELD =
{
    "MIB_REG_ERR_INTR_MASK",
#if RU_INCLUDE_DESC
    "",
    "This bit corresponds to the mask for mib register error interrupt. See register description above for details of how to use this bit.",
#endif
    XPORT_INTR_PCI_MASK_SET_MIB_REG_ERR_INTR_MASK_FIELD_MASK,
    0,
    XPORT_INTR_PCI_MASK_SET_MIB_REG_ERR_INTR_MASK_FIELD_WIDTH,
    XPORT_INTR_PCI_MASK_SET_MIB_REG_ERR_INTR_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_MASK_SET_UBUS_ERR_INTR_MASK
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_MASK_SET_UBUS_ERR_INTR_MASK_FIELD =
{
    "UBUS_ERR_INTR_MASK",
#if RU_INCLUDE_DESC
    "",
    "This bit corresponds to the mask for ubus error interrupt. See register description above for details of how to use this bit.",
#endif
    XPORT_INTR_PCI_MASK_SET_UBUS_ERR_INTR_MASK_FIELD_MASK,
    0,
    XPORT_INTR_PCI_MASK_SET_UBUS_ERR_INTR_MASK_FIELD_WIDTH,
    XPORT_INTR_PCI_MASK_SET_UBUS_ERR_INTR_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_MASK_CLEAR_RESERVED0
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_MASK_CLEAR_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    XPORT_INTR_PCI_MASK_CLEAR_RESERVED0_FIELD_MASK,
    0,
    XPORT_INTR_PCI_MASK_CLEAR_RESERVED0_FIELD_WIDTH,
    XPORT_INTR_PCI_MASK_CLEAR_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_MASK_CLEAR_LINK_DOWN_INTR_MASK
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_MASK_CLEAR_LINK_DOWN_INTR_MASK_FIELD =
{
    "LINK_DOWN_INTR_MASK",
#if RU_INCLUDE_DESC
    "",
    "This bit corresponds to the mask for link down interrupt. See register description above for details of how to use this bit.",
#endif
    XPORT_INTR_PCI_MASK_CLEAR_LINK_DOWN_INTR_MASK_FIELD_MASK,
    0,
    XPORT_INTR_PCI_MASK_CLEAR_LINK_DOWN_INTR_MASK_FIELD_WIDTH,
    XPORT_INTR_PCI_MASK_CLEAR_LINK_DOWN_INTR_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_MASK_CLEAR_LINK_UP_INTR_MASK
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_MASK_CLEAR_LINK_UP_INTR_MASK_FIELD =
{
    "LINK_UP_INTR_MASK",
#if RU_INCLUDE_DESC
    "",
    "This bit corresponds to the mask for link up interrupt. See register description above for details of how to use this bit.",
#endif
    XPORT_INTR_PCI_MASK_CLEAR_LINK_UP_INTR_MASK_FIELD_MASK,
    0,
    XPORT_INTR_PCI_MASK_CLEAR_LINK_UP_INTR_MASK_FIELD_WIDTH,
    XPORT_INTR_PCI_MASK_CLEAR_LINK_UP_INTR_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_MASK_CLEAR_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_MASK
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_MASK_CLEAR_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_MASK_FIELD =
{
    "TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_MASK",
#if RU_INCLUDE_DESC
    "",
    "This bit corresponds to the mask for  tx timesync fifo entry valid interrupt. See register description above for details of how to use this bit.",
#endif
    XPORT_INTR_PCI_MASK_CLEAR_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_MASK_FIELD_MASK,
    0,
    XPORT_INTR_PCI_MASK_CLEAR_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_MASK_FIELD_WIDTH,
    XPORT_INTR_PCI_MASK_CLEAR_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_MASK_CLEAR_XLMAC_INTR_MASK
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_MASK_CLEAR_XLMAC_INTR_MASK_FIELD =
{
    "XLMAC_INTR_MASK",
#if RU_INCLUDE_DESC
    "",
    "This bit corresponds to the mask for xlmac interrupt. See register description above for details of how to use this bit.",
#endif
    XPORT_INTR_PCI_MASK_CLEAR_XLMAC_INTR_MASK_FIELD_MASK,
    0,
    XPORT_INTR_PCI_MASK_CLEAR_XLMAC_INTR_MASK_FIELD_WIDTH,
    XPORT_INTR_PCI_MASK_CLEAR_XLMAC_INTR_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_MASK_CLEAR_MAC_REG_ERR_INTR_MASK
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_MASK_CLEAR_MAC_REG_ERR_INTR_MASK_FIELD =
{
    "MAC_REG_ERR_INTR_MASK",
#if RU_INCLUDE_DESC
    "",
    "This bit corresponds to the mask for mac register error interrupt. See register description above for details of how to use this bit.",
#endif
    XPORT_INTR_PCI_MASK_CLEAR_MAC_REG_ERR_INTR_MASK_FIELD_MASK,
    0,
    XPORT_INTR_PCI_MASK_CLEAR_MAC_REG_ERR_INTR_MASK_FIELD_WIDTH,
    XPORT_INTR_PCI_MASK_CLEAR_MAC_REG_ERR_INTR_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_MASK_CLEAR_MAB_STATUS_INTR_MASK
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_MASK_CLEAR_MAB_STATUS_INTR_MASK_FIELD =
{
    "MAB_STATUS_INTR_MASK",
#if RU_INCLUDE_DESC
    "",
    "This bit corresponds to the mask for msbus adaptation block status interrupt. See register description above for details of how to use this bit.",
#endif
    XPORT_INTR_PCI_MASK_CLEAR_MAB_STATUS_INTR_MASK_FIELD_MASK,
    0,
    XPORT_INTR_PCI_MASK_CLEAR_MAB_STATUS_INTR_MASK_FIELD_WIDTH,
    XPORT_INTR_PCI_MASK_CLEAR_MAB_STATUS_INTR_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_MASK_CLEAR_MIB_REG_ERR_INTR_MASK
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_MASK_CLEAR_MIB_REG_ERR_INTR_MASK_FIELD =
{
    "MIB_REG_ERR_INTR_MASK",
#if RU_INCLUDE_DESC
    "",
    "This bit corresponds to the mask for mib register error interrupt. See register description above for details of how to use this bit.",
#endif
    XPORT_INTR_PCI_MASK_CLEAR_MIB_REG_ERR_INTR_MASK_FIELD_MASK,
    0,
    XPORT_INTR_PCI_MASK_CLEAR_MIB_REG_ERR_INTR_MASK_FIELD_WIDTH,
    XPORT_INTR_PCI_MASK_CLEAR_MIB_REG_ERR_INTR_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: XPORT_INTR_PCI_MASK_CLEAR_UBUS_ERR_INTR_MASK
 ******************************************************************************/
const ru_field_rec XPORT_INTR_PCI_MASK_CLEAR_UBUS_ERR_INTR_MASK_FIELD =
{
    "UBUS_ERR_INTR_MASK",
#if RU_INCLUDE_DESC
    "",
    "This bit corresponds to the mask for ubus error interrupt. See register description above for details of how to use this bit.",
#endif
    XPORT_INTR_PCI_MASK_CLEAR_UBUS_ERR_INTR_MASK_FIELD_MASK,
    0,
    XPORT_INTR_PCI_MASK_CLEAR_UBUS_ERR_INTR_MASK_FIELD_WIDTH,
    XPORT_INTR_PCI_MASK_CLEAR_UBUS_ERR_INTR_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

#endif /* RU_INCLUDE_FIELD_DB */

/******************************************************************************
 * Register: XPORT_INTR_CPU_STATUS
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *XPORT_INTR_CPU_STATUS_FIELDS[] =
{
    &XPORT_INTR_CPU_STATUS_RESERVED0_FIELD,
    &XPORT_INTR_CPU_STATUS_LINK_DOWN_INTR_FIELD,
    &XPORT_INTR_CPU_STATUS_LINK_UP_INTR_FIELD,
    &XPORT_INTR_CPU_STATUS_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_FIELD,
    &XPORT_INTR_CPU_STATUS_XLMAC_INTR_FIELD,
    &XPORT_INTR_CPU_STATUS_MAC_REG_ERR_INTR_FIELD,
    &XPORT_INTR_CPU_STATUS_MAB_STATUS_INTR_FIELD,
    &XPORT_INTR_CPU_STATUS_MIB_REG_ERR_INTR_FIELD,
    &XPORT_INTR_CPU_STATUS_UBUS_ERR_INTR_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec XPORT_INTR_CPU_STATUS_REG = 
{
    "CPU_STATUS",
#if RU_INCLUDE_DESC
    "PCI interrupt Clear Register",
    "This read-only register shows the current status of the interrupts for the CPU processor.  There is one "
    "bit per interrupt source.  The assertion of any of these interrupts will cause an interrupt to the CPU "
    "processor if the interrupt's mask bit is zero."
    "\nFor each bit: 1 = asserted. 0 = not asserted."
    "This write-only register is used to set interrupts for the CPU processor.  There is one bit per interrupt "
    "source.  Writing a 1 to a bit in this register will set the interrupt corresponding to that bit.  Writing "
    "a 0 has no effect.  Note that it is not necessary to read-modify-write this register because bits that have "
    "zeros written to them are not affected."
    "\nFor each bit: 1 = set the corresponding interrupt bit. 0 = no change."
    "This write-only register is used to clear interrupts for the CPU processor.  There is one bit per interrupt "
    "source.  Writing a 1 to a bit in this register will clear the interrupt corresponding to that bit.  Writing "
    "a 0 has no effect.  Note that it is not necessary to read-modify-write this register because bits that have "
    "zeros written to them are not affected."
    "\nFor each bit: 1 = clear the corresponding interrupt bit. 0 = no change."
    "This read-only register shows the current status of the interrupts for the PCI bus.  There is one bit per "
    "interrupt source.  The assertion of any of these interrupts will cause an interrupt to the PCI bus if the"
    "interrupt's mask bit is zero."
    "\nFor each bit: 1 = asserted. 0 = not asserted."
    "This write-only register is used to set interrupts for the PCI bus.  There is one bit per interrupt source."
    "Writing a 1 to a bit in this register will set the interrupt corresponding to that bit.  Writing a 0 has "
    "no effect.  Note that it is not necessary to read-modify-write this register because bits that have zeros "
    "written to them are not affected."
    "\nFor each bit: 1 = set the corresponding interrupt bit. 0 = no change."
    "This write-only register is used to clear interrupts for the PCI bus.  There is one bit per interrupt "
    "source.  Writing a 1 to a bit in this register will clear the interrupt corresponding to that bit.  Writing "
    "a 0 has no effect.  Note that it is not necessary to read-modify-write this register because bits that have "
    "zeros written to them are not affected."
    "\nFor each bit: 1 = clear the corresponding interrupt bit. 0 = no change.",
#endif
    XPORT_INTR_CPU_STATUS_REG_OFFSET,
    0,
    0,
    214,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    9,
    XPORT_INTR_CPU_STATUS_FIELDS,
#endif /* RU_INCLUDE_FIELD_DB */
    ru_reg_size_32
};

/******************************************************************************
 * Register: XPORT_INTR_CPU_SET
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *XPORT_INTR_CPU_SET_FIELDS[] =
{
    &XPORT_INTR_CPU_SET_RESERVED0_FIELD,
    &XPORT_INTR_CPU_SET_LINK_DOWN_INTR_FIELD,
    &XPORT_INTR_CPU_SET_LINK_UP_INTR_FIELD,
    &XPORT_INTR_CPU_SET_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_FIELD,
    &XPORT_INTR_CPU_SET_XLMAC_INTR_FIELD,
    &XPORT_INTR_CPU_SET_MAC_REG_ERR_INTR_FIELD,
    &XPORT_INTR_CPU_SET_MAB_STATUS_INTR_FIELD,
    &XPORT_INTR_CPU_SET_MIB_REG_ERR_INTR_FIELD,
    &XPORT_INTR_CPU_SET_UBUS_ERR_INTR_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec XPORT_INTR_CPU_SET_REG = 
{
    "CPU_SET",
#if RU_INCLUDE_DESC
    "PCI interrupt Clear Register",
    "This read-only register shows the current status of the interrupts for the CPU processor.  There is one "
    "bit per interrupt source.  The assertion of any of these interrupts will cause an interrupt to the CPU "
    "processor if the interrupt's mask bit is zero."
    "\nFor each bit: 1 = asserted. 0 = not asserted."
    "This write-only register is used to set interrupts for the CPU processor.  There is one bit per interrupt "
    "source.  Writing a 1 to a bit in this register will set the interrupt corresponding to that bit.  Writing "
    "a 0 has no effect.  Note that it is not necessary to read-modify-write this register because bits that have "
    "zeros written to them are not affected."
    "\nFor each bit: 1 = set the corresponding interrupt bit. 0 = no change."
    "This write-only register is used to clear interrupts for the CPU processor.  There is one bit per interrupt "
    "source.  Writing a 1 to a bit in this register will clear the interrupt corresponding to that bit.  Writing "
    "a 0 has no effect.  Note that it is not necessary to read-modify-write this register because bits that have "
    "zeros written to them are not affected."
    "\nFor each bit: 1 = clear the corresponding interrupt bit. 0 = no change."
    "This read-only register shows the current status of the interrupts for the PCI bus.  There is one bit per "
    "interrupt source.  The assertion of any of these interrupts will cause an interrupt to the PCI bus if the"
    "interrupt's mask bit is zero."
    "\nFor each bit: 1 = asserted. 0 = not asserted."
    "This write-only register is used to set interrupts for the PCI bus.  There is one bit per interrupt source."
    "Writing a 1 to a bit in this register will set the interrupt corresponding to that bit.  Writing a 0 has "
    "no effect.  Note that it is not necessary to read-modify-write this register because bits that have zeros "
    "written to them are not affected."
    "\nFor each bit: 1 = set the corresponding interrupt bit. 0 = no change."
    "This write-only register is used to clear interrupts for the PCI bus.  There is one bit per interrupt "
    "source.  Writing a 1 to a bit in this register will clear the interrupt corresponding to that bit.  Writing "
    "a 0 has no effect.  Note that it is not necessary to read-modify-write this register because bits that have "
    "zeros written to them are not affected."
    "\nFor each bit: 1 = clear the corresponding interrupt bit. 0 = no change.",
#endif
    XPORT_INTR_CPU_SET_REG_OFFSET,
    0,
    0,
    215,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    9,
    XPORT_INTR_CPU_SET_FIELDS,
#endif /* RU_INCLUDE_FIELD_DB */
    ru_reg_size_32
};

/******************************************************************************
 * Register: XPORT_INTR_CPU_CLEAR
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *XPORT_INTR_CPU_CLEAR_FIELDS[] =
{
    &XPORT_INTR_CPU_CLEAR_RESERVED0_FIELD,
    &XPORT_INTR_CPU_CLEAR_LINK_DOWN_INTR_FIELD,
    &XPORT_INTR_CPU_CLEAR_LINK_UP_INTR_FIELD,
    &XPORT_INTR_CPU_CLEAR_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_FIELD,
    &XPORT_INTR_CPU_CLEAR_XLMAC_INTR_FIELD,
    &XPORT_INTR_CPU_CLEAR_MAC_REG_ERR_INTR_FIELD,
    &XPORT_INTR_CPU_CLEAR_MAB_STATUS_INTR_FIELD,
    &XPORT_INTR_CPU_CLEAR_MIB_REG_ERR_INTR_FIELD,
    &XPORT_INTR_CPU_CLEAR_UBUS_ERR_INTR_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec XPORT_INTR_CPU_CLEAR_REG = 
{
    "CPU_CLEAR",
#if RU_INCLUDE_DESC
    "PCI interrupt Clear Register",
    "This read-only register shows the current status of the interrupts for the CPU processor.  There is one "
    "bit per interrupt source.  The assertion of any of these interrupts will cause an interrupt to the CPU "
    "processor if the interrupt's mask bit is zero."
    "\nFor each bit: 1 = asserted. 0 = not asserted."
    "This write-only register is used to set interrupts for the CPU processor.  There is one bit per interrupt "
    "source.  Writing a 1 to a bit in this register will set the interrupt corresponding to that bit.  Writing "
    "a 0 has no effect.  Note that it is not necessary to read-modify-write this register because bits that have "
    "zeros written to them are not affected."
    "\nFor each bit: 1 = set the corresponding interrupt bit. 0 = no change."
    "This write-only register is used to clear interrupts for the CPU processor.  There is one bit per interrupt "
    "source.  Writing a 1 to a bit in this register will clear the interrupt corresponding to that bit.  Writing "
    "a 0 has no effect.  Note that it is not necessary to read-modify-write this register because bits that have "
    "zeros written to them are not affected."
    "\nFor each bit: 1 = clear the corresponding interrupt bit. 0 = no change."
    "This read-only register shows the current status of the interrupts for the PCI bus.  There is one bit per "
    "interrupt source.  The assertion of any of these interrupts will cause an interrupt to the PCI bus if the"
    "interrupt's mask bit is zero."
    "\nFor each bit: 1 = asserted. 0 = not asserted."
    "This write-only register is used to set interrupts for the PCI bus.  There is one bit per interrupt source."
    "Writing a 1 to a bit in this register will set the interrupt corresponding to that bit.  Writing a 0 has "
    "no effect.  Note that it is not necessary to read-modify-write this register because bits that have zeros "
    "written to them are not affected."
    "\nFor each bit: 1 = set the corresponding interrupt bit. 0 = no change."
    "This write-only register is used to clear interrupts for the PCI bus.  There is one bit per interrupt "
    "source.  Writing a 1 to a bit in this register will clear the interrupt corresponding to that bit.  Writing "
    "a 0 has no effect.  Note that it is not necessary to read-modify-write this register because bits that have "
    "zeros written to them are not affected."
    "\nFor each bit: 1 = clear the corresponding interrupt bit. 0 = no change.",
#endif
    XPORT_INTR_CPU_CLEAR_REG_OFFSET,
    0,
    0,
    216,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    9,
    XPORT_INTR_CPU_CLEAR_FIELDS,
#endif /* RU_INCLUDE_FIELD_DB */
    ru_reg_size_32
};

/******************************************************************************
 * Register: XPORT_INTR_CPU_MASK_STATUS
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *XPORT_INTR_CPU_MASK_STATUS_FIELDS[] =
{
    &XPORT_INTR_CPU_MASK_STATUS_RESERVED0_FIELD,
    &XPORT_INTR_CPU_MASK_STATUS_LINK_DOWN_INTR_MASK_FIELD,
    &XPORT_INTR_CPU_MASK_STATUS_LINK_UP_INTR_MASK_FIELD,
    &XPORT_INTR_CPU_MASK_STATUS_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_MASK_FIELD,
    &XPORT_INTR_CPU_MASK_STATUS_XLMAC_INTR_MASK_FIELD,
    &XPORT_INTR_CPU_MASK_STATUS_MAC_REG_ERR_INTR_MASK_FIELD,
    &XPORT_INTR_CPU_MASK_STATUS_MAB_STATUS_INTR_MASK_FIELD,
    &XPORT_INTR_CPU_MASK_STATUS_MIB_REG_ERR_INTR_MASK_FIELD,
    &XPORT_INTR_CPU_MASK_STATUS_UBUS_ERR_INTR_MASK_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec XPORT_INTR_CPU_MASK_STATUS_REG = 
{
    "CPU_MASK_STATUS",
#if RU_INCLUDE_DESC
    "PCI interrupt Mask Clear Register",
    "This read-only register shows the current masking of the interrupts for the CPU processor.  There is one "
    "bit per interrupt source.  A value of 1 in a bit position indicates that the interrupt corresponding to "
    "that bit is currently masked.  Masking does not prevent the interrupt from appearing in the status register."
    "\nFor each bit: 1 = masked. 0 = not masked."
    "This write-only register is used to disable interrupts for the CPU processor.  There is one bit per interrupt "
    "source.  Writing a 1 to a bit in this register will set the mask bit for the corresponding interrupt.  Writing "
    "a 0 has no effect.  Note that it is not necessary to read-modify-write this register because bits that have "
    "zeros written to them are not affected."
    "\nFor each bit: 1 = disable the corresponding interrupt. 0 = no change."
    "This write-only register is used to enable interrupts for the CPU processor.  There is one bit per interrupt "
    "source.  Writing a 1 to a bit in this register will clear the mask bit for the corresponding interrupt.  Writing "
    "a 0 has no effect.  Note that it is not necessary to read-modify-write this register because bits that have "
    "zeros written to them are not affected."
    "\nFor each bit: 1 = enable the corresponding interrupt. 0 = no change."
    "This read-only register shows the current masking of the interrupts for the PCI bus.  There is one bit per"
    "interrupt source.  A value of 1 in a bit position indicates that the interrupt corresponding to that bit is"
    "currently masked.  Masking does not prevent the interrupt from appearing in the status register."
    "\nFor each bit: 1 = masked. 0 = not masked."
    "This write-only register is used to disable interrupts for the PCI bus.  There is one bit per interrupt source."
    "Writing a 1 to a bit in this register will set the mask bit for the corresponding interrupt.  Writing a 0 has no"
    "effect.  Note that it is not necessary to read-modify-write this register because bits that have zeros written "
    "to them are not affected."
    "\nFor each bit: 1 = disable the corresponding interrupt. 0 = no change."
    "This write-only register is used to enable interrupts for the PCI bus.  There is one bit per interrupt "
    "source.  Writing a 1 to a bit in this register will clear the mask bit for the corresponding interrupt.  Writing "
    "a 0 has no effect.  Note that it is not necessary to read-modify-write this register because bits that have "
    "zeros written to them are not affected."
    "\nFor each bit: 1 = enable the corresponding interrupt. 0 = no change.",
#endif
    XPORT_INTR_CPU_MASK_STATUS_REG_OFFSET,
    0,
    0,
    217,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    9,
    XPORT_INTR_CPU_MASK_STATUS_FIELDS,
#endif /* RU_INCLUDE_FIELD_DB */
    ru_reg_size_32
};

/******************************************************************************
 * Register: XPORT_INTR_CPU_MASK_SET
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *XPORT_INTR_CPU_MASK_SET_FIELDS[] =
{
    &XPORT_INTR_CPU_MASK_SET_RESERVED0_FIELD,
    &XPORT_INTR_CPU_MASK_SET_LINK_DOWN_INTR_MASK_FIELD,
    &XPORT_INTR_CPU_MASK_SET_LINK_UP_INTR_MASK_FIELD,
    &XPORT_INTR_CPU_MASK_SET_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_MASK_FIELD,
    &XPORT_INTR_CPU_MASK_SET_XLMAC_INTR_MASK_FIELD,
    &XPORT_INTR_CPU_MASK_SET_MAC_REG_ERR_INTR_MASK_FIELD,
    &XPORT_INTR_CPU_MASK_SET_MAB_STATUS_INTR_MASK_FIELD,
    &XPORT_INTR_CPU_MASK_SET_MIB_REG_ERR_INTR_MASK_FIELD,
    &XPORT_INTR_CPU_MASK_SET_UBUS_ERR_INTR_MASK_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec XPORT_INTR_CPU_MASK_SET_REG = 
{
    "CPU_MASK_SET",
#if RU_INCLUDE_DESC
    "PCI interrupt Mask Clear Register",
    "This read-only register shows the current masking of the interrupts for the CPU processor.  There is one "
    "bit per interrupt source.  A value of 1 in a bit position indicates that the interrupt corresponding to "
    "that bit is currently masked.  Masking does not prevent the interrupt from appearing in the status register."
    "\nFor each bit: 1 = masked. 0 = not masked."
    "This write-only register is used to disable interrupts for the CPU processor.  There is one bit per interrupt "
    "source.  Writing a 1 to a bit in this register will set the mask bit for the corresponding interrupt.  Writing "
    "a 0 has no effect.  Note that it is not necessary to read-modify-write this register because bits that have "
    "zeros written to them are not affected."
    "\nFor each bit: 1 = disable the corresponding interrupt. 0 = no change."
    "This write-only register is used to enable interrupts for the CPU processor.  There is one bit per interrupt "
    "source.  Writing a 1 to a bit in this register will clear the mask bit for the corresponding interrupt.  Writing "
    "a 0 has no effect.  Note that it is not necessary to read-modify-write this register because bits that have "
    "zeros written to them are not affected."
    "\nFor each bit: 1 = enable the corresponding interrupt. 0 = no change."
    "This read-only register shows the current masking of the interrupts for the PCI bus.  There is one bit per"
    "interrupt source.  A value of 1 in a bit position indicates that the interrupt corresponding to that bit is"
    "currently masked.  Masking does not prevent the interrupt from appearing in the status register."
    "\nFor each bit: 1 = masked. 0 = not masked."
    "This write-only register is used to disable interrupts for the PCI bus.  There is one bit per interrupt source."
    "Writing a 1 to a bit in this register will set the mask bit for the corresponding interrupt.  Writing a 0 has no"
    "effect.  Note that it is not necessary to read-modify-write this register because bits that have zeros written "
    "to them are not affected."
    "\nFor each bit: 1 = disable the corresponding interrupt. 0 = no change."
    "This write-only register is used to enable interrupts for the PCI bus.  There is one bit per interrupt "
    "source.  Writing a 1 to a bit in this register will clear the mask bit for the corresponding interrupt.  Writing "
    "a 0 has no effect.  Note that it is not necessary to read-modify-write this register because bits that have "
    "zeros written to them are not affected."
    "\nFor each bit: 1 = enable the corresponding interrupt. 0 = no change.",
#endif
    XPORT_INTR_CPU_MASK_SET_REG_OFFSET,
    0,
    0,
    218,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    9,
    XPORT_INTR_CPU_MASK_SET_FIELDS,
#endif /* RU_INCLUDE_FIELD_DB */
    ru_reg_size_32
};

/******************************************************************************
 * Register: XPORT_INTR_CPU_MASK_CLEAR
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *XPORT_INTR_CPU_MASK_CLEAR_FIELDS[] =
{
    &XPORT_INTR_CPU_MASK_CLEAR_RESERVED0_FIELD,
    &XPORT_INTR_CPU_MASK_CLEAR_LINK_DOWN_INTR_MASK_FIELD,
    &XPORT_INTR_CPU_MASK_CLEAR_LINK_UP_INTR_MASK_FIELD,
    &XPORT_INTR_CPU_MASK_CLEAR_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_MASK_FIELD,
    &XPORT_INTR_CPU_MASK_CLEAR_XLMAC_INTR_MASK_FIELD,
    &XPORT_INTR_CPU_MASK_CLEAR_MAC_REG_ERR_INTR_MASK_FIELD,
    &XPORT_INTR_CPU_MASK_CLEAR_MAB_STATUS_INTR_MASK_FIELD,
    &XPORT_INTR_CPU_MASK_CLEAR_MIB_REG_ERR_INTR_MASK_FIELD,
    &XPORT_INTR_CPU_MASK_CLEAR_UBUS_ERR_INTR_MASK_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec XPORT_INTR_CPU_MASK_CLEAR_REG = 
{
    "CPU_MASK_CLEAR",
#if RU_INCLUDE_DESC
    "PCI interrupt Mask Clear Register",
    "This read-only register shows the current masking of the interrupts for the CPU processor.  There is one "
    "bit per interrupt source.  A value of 1 in a bit position indicates that the interrupt corresponding to "
    "that bit is currently masked.  Masking does not prevent the interrupt from appearing in the status register."
    "\nFor each bit: 1 = masked. 0 = not masked."
    "This write-only register is used to disable interrupts for the CPU processor.  There is one bit per interrupt "
    "source.  Writing a 1 to a bit in this register will set the mask bit for the corresponding interrupt.  Writing "
    "a 0 has no effect.  Note that it is not necessary to read-modify-write this register because bits that have "
    "zeros written to them are not affected."
    "\nFor each bit: 1 = disable the corresponding interrupt. 0 = no change."
    "This write-only register is used to enable interrupts for the CPU processor.  There is one bit per interrupt "
    "source.  Writing a 1 to a bit in this register will clear the mask bit for the corresponding interrupt.  Writing "
    "a 0 has no effect.  Note that it is not necessary to read-modify-write this register because bits that have "
    "zeros written to them are not affected."
    "\nFor each bit: 1 = enable the corresponding interrupt. 0 = no change."
    "This read-only register shows the current masking of the interrupts for the PCI bus.  There is one bit per"
    "interrupt source.  A value of 1 in a bit position indicates that the interrupt corresponding to that bit is"
    "currently masked.  Masking does not prevent the interrupt from appearing in the status register."
    "\nFor each bit: 1 = masked. 0 = not masked."
    "This write-only register is used to disable interrupts for the PCI bus.  There is one bit per interrupt source."
    "Writing a 1 to a bit in this register will set the mask bit for the corresponding interrupt.  Writing a 0 has no"
    "effect.  Note that it is not necessary to read-modify-write this register because bits that have zeros written "
    "to them are not affected."
    "\nFor each bit: 1 = disable the corresponding interrupt. 0 = no change."
    "This write-only register is used to enable interrupts for the PCI bus.  There is one bit per interrupt "
    "source.  Writing a 1 to a bit in this register will clear the mask bit for the corresponding interrupt.  Writing "
    "a 0 has no effect.  Note that it is not necessary to read-modify-write this register because bits that have "
    "zeros written to them are not affected."
    "\nFor each bit: 1 = enable the corresponding interrupt. 0 = no change.",
#endif
    XPORT_INTR_CPU_MASK_CLEAR_REG_OFFSET,
    0,
    0,
    219,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    9,
    XPORT_INTR_CPU_MASK_CLEAR_FIELDS,
#endif /* RU_INCLUDE_FIELD_DB */
    ru_reg_size_32
};

/******************************************************************************
 * Register: XPORT_INTR_PCI_STATUS
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *XPORT_INTR_PCI_STATUS_FIELDS[] =
{
    &XPORT_INTR_PCI_STATUS_RESERVED0_FIELD,
    &XPORT_INTR_PCI_STATUS_LINK_DOWN_INTR_FIELD,
    &XPORT_INTR_PCI_STATUS_LINK_UP_INTR_FIELD,
    &XPORT_INTR_PCI_STATUS_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_FIELD,
    &XPORT_INTR_PCI_STATUS_XLMAC_INTR_FIELD,
    &XPORT_INTR_PCI_STATUS_MAC_REG_ERR_INTR_FIELD,
    &XPORT_INTR_PCI_STATUS_MAB_STATUS_INTR_FIELD,
    &XPORT_INTR_PCI_STATUS_MIB_REG_ERR_INTR_FIELD,
    &XPORT_INTR_PCI_STATUS_UBUS_ERR_INTR_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec XPORT_INTR_PCI_STATUS_REG = 
{
    "PCI_STATUS",
#if RU_INCLUDE_DESC
    "PCI interrupt Clear Register",
    "This read-only register shows the current status of the interrupts for the CPU processor.  There is one "
    "bit per interrupt source.  The assertion of any of these interrupts will cause an interrupt to the CPU "
    "processor if the interrupt's mask bit is zero."
    "\nFor each bit: 1 = asserted. 0 = not asserted."
    "This write-only register is used to set interrupts for the CPU processor.  There is one bit per interrupt "
    "source.  Writing a 1 to a bit in this register will set the interrupt corresponding to that bit.  Writing "
    "a 0 has no effect.  Note that it is not necessary to read-modify-write this register because bits that have "
    "zeros written to them are not affected."
    "\nFor each bit: 1 = set the corresponding interrupt bit. 0 = no change."
    "This write-only register is used to clear interrupts for the CPU processor.  There is one bit per interrupt "
    "source.  Writing a 1 to a bit in this register will clear the interrupt corresponding to that bit.  Writing "
    "a 0 has no effect.  Note that it is not necessary to read-modify-write this register because bits that have "
    "zeros written to them are not affected."
    "\nFor each bit: 1 = clear the corresponding interrupt bit. 0 = no change."
    "This read-only register shows the current status of the interrupts for the PCI bus.  There is one bit per "
    "interrupt source.  The assertion of any of these interrupts will cause an interrupt to the PCI bus if the"
    "interrupt's mask bit is zero."
    "\nFor each bit: 1 = asserted. 0 = not asserted."
    "This write-only register is used to set interrupts for the PCI bus.  There is one bit per interrupt source."
    "Writing a 1 to a bit in this register will set the interrupt corresponding to that bit.  Writing a 0 has "
    "no effect.  Note that it is not necessary to read-modify-write this register because bits that have zeros "
    "written to them are not affected."
    "\nFor each bit: 1 = set the corresponding interrupt bit. 0 = no change."
    "This write-only register is used to clear interrupts for the PCI bus.  There is one bit per interrupt "
    "source.  Writing a 1 to a bit in this register will clear the interrupt corresponding to that bit.  Writing "
    "a 0 has no effect.  Note that it is not necessary to read-modify-write this register because bits that have "
    "zeros written to them are not affected."
    "\nFor each bit: 1 = clear the corresponding interrupt bit. 0 = no change.",
#endif
    XPORT_INTR_PCI_STATUS_REG_OFFSET,
    0,
    0,
    220,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    9,
    XPORT_INTR_PCI_STATUS_FIELDS,
#endif /* RU_INCLUDE_FIELD_DB */
    ru_reg_size_32
};

/******************************************************************************
 * Register: XPORT_INTR_PCI_SET
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *XPORT_INTR_PCI_SET_FIELDS[] =
{
    &XPORT_INTR_PCI_SET_RESERVED0_FIELD,
    &XPORT_INTR_PCI_SET_LINK_DOWN_INTR_FIELD,
    &XPORT_INTR_PCI_SET_LINK_UP_INTR_FIELD,
    &XPORT_INTR_PCI_SET_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_FIELD,
    &XPORT_INTR_PCI_SET_XLMAC_INTR_FIELD,
    &XPORT_INTR_PCI_SET_MAC_REG_ERR_INTR_FIELD,
    &XPORT_INTR_PCI_SET_MAB_STATUS_INTR_FIELD,
    &XPORT_INTR_PCI_SET_MIB_REG_ERR_INTR_FIELD,
    &XPORT_INTR_PCI_SET_UBUS_ERR_INTR_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec XPORT_INTR_PCI_SET_REG = 
{
    "PCI_SET",
#if RU_INCLUDE_DESC
    "PCI interrupt Clear Register",
    "This read-only register shows the current status of the interrupts for the CPU processor.  There is one "
    "bit per interrupt source.  The assertion of any of these interrupts will cause an interrupt to the CPU "
    "processor if the interrupt's mask bit is zero."
    "\nFor each bit: 1 = asserted. 0 = not asserted."
    "This write-only register is used to set interrupts for the CPU processor.  There is one bit per interrupt "
    "source.  Writing a 1 to a bit in this register will set the interrupt corresponding to that bit.  Writing "
    "a 0 has no effect.  Note that it is not necessary to read-modify-write this register because bits that have "
    "zeros written to them are not affected."
    "\nFor each bit: 1 = set the corresponding interrupt bit. 0 = no change."
    "This write-only register is used to clear interrupts for the CPU processor.  There is one bit per interrupt "
    "source.  Writing a 1 to a bit in this register will clear the interrupt corresponding to that bit.  Writing "
    "a 0 has no effect.  Note that it is not necessary to read-modify-write this register because bits that have "
    "zeros written to them are not affected."
    "\nFor each bit: 1 = clear the corresponding interrupt bit. 0 = no change."
    "This read-only register shows the current status of the interrupts for the PCI bus.  There is one bit per "
    "interrupt source.  The assertion of any of these interrupts will cause an interrupt to the PCI bus if the"
    "interrupt's mask bit is zero."
    "\nFor each bit: 1 = asserted. 0 = not asserted."
    "This write-only register is used to set interrupts for the PCI bus.  There is one bit per interrupt source."
    "Writing a 1 to a bit in this register will set the interrupt corresponding to that bit.  Writing a 0 has "
    "no effect.  Note that it is not necessary to read-modify-write this register because bits that have zeros "
    "written to them are not affected."
    "\nFor each bit: 1 = set the corresponding interrupt bit. 0 = no change."
    "This write-only register is used to clear interrupts for the PCI bus.  There is one bit per interrupt "
    "source.  Writing a 1 to a bit in this register will clear the interrupt corresponding to that bit.  Writing "
    "a 0 has no effect.  Note that it is not necessary to read-modify-write this register because bits that have "
    "zeros written to them are not affected."
    "\nFor each bit: 1 = clear the corresponding interrupt bit. 0 = no change.",
#endif
    XPORT_INTR_PCI_SET_REG_OFFSET,
    0,
    0,
    221,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    9,
    XPORT_INTR_PCI_SET_FIELDS,
#endif /* RU_INCLUDE_FIELD_DB */
    ru_reg_size_32
};

/******************************************************************************
 * Register: XPORT_INTR_PCI_CLEAR
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *XPORT_INTR_PCI_CLEAR_FIELDS[] =
{
    &XPORT_INTR_PCI_CLEAR_RESERVED0_FIELD,
    &XPORT_INTR_PCI_CLEAR_LINK_DOWN_INTR_FIELD,
    &XPORT_INTR_PCI_CLEAR_LINK_UP_INTR_FIELD,
    &XPORT_INTR_PCI_CLEAR_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_FIELD,
    &XPORT_INTR_PCI_CLEAR_XLMAC_INTR_FIELD,
    &XPORT_INTR_PCI_CLEAR_MAC_REG_ERR_INTR_FIELD,
    &XPORT_INTR_PCI_CLEAR_MAB_STATUS_INTR_FIELD,
    &XPORT_INTR_PCI_CLEAR_MIB_REG_ERR_INTR_FIELD,
    &XPORT_INTR_PCI_CLEAR_UBUS_ERR_INTR_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec XPORT_INTR_PCI_CLEAR_REG = 
{
    "PCI_CLEAR",
#if RU_INCLUDE_DESC
    "PCI interrupt Clear Register",
    "This read-only register shows the current status of the interrupts for the CPU processor.  There is one "
    "bit per interrupt source.  The assertion of any of these interrupts will cause an interrupt to the CPU "
    "processor if the interrupt's mask bit is zero."
    "\nFor each bit: 1 = asserted. 0 = not asserted."
    "This write-only register is used to set interrupts for the CPU processor.  There is one bit per interrupt "
    "source.  Writing a 1 to a bit in this register will set the interrupt corresponding to that bit.  Writing "
    "a 0 has no effect.  Note that it is not necessary to read-modify-write this register because bits that have "
    "zeros written to them are not affected."
    "\nFor each bit: 1 = set the corresponding interrupt bit. 0 = no change."
    "This write-only register is used to clear interrupts for the CPU processor.  There is one bit per interrupt "
    "source.  Writing a 1 to a bit in this register will clear the interrupt corresponding to that bit.  Writing "
    "a 0 has no effect.  Note that it is not necessary to read-modify-write this register because bits that have "
    "zeros written to them are not affected."
    "\nFor each bit: 1 = clear the corresponding interrupt bit. 0 = no change."
    "This read-only register shows the current status of the interrupts for the PCI bus.  There is one bit per "
    "interrupt source.  The assertion of any of these interrupts will cause an interrupt to the PCI bus if the"
    "interrupt's mask bit is zero."
    "\nFor each bit: 1 = asserted. 0 = not asserted."
    "This write-only register is used to set interrupts for the PCI bus.  There is one bit per interrupt source."
    "Writing a 1 to a bit in this register will set the interrupt corresponding to that bit.  Writing a 0 has "
    "no effect.  Note that it is not necessary to read-modify-write this register because bits that have zeros "
    "written to them are not affected."
    "\nFor each bit: 1 = set the corresponding interrupt bit. 0 = no change."
    "This write-only register is used to clear interrupts for the PCI bus.  There is one bit per interrupt "
    "source.  Writing a 1 to a bit in this register will clear the interrupt corresponding to that bit.  Writing "
    "a 0 has no effect.  Note that it is not necessary to read-modify-write this register because bits that have "
    "zeros written to them are not affected."
    "\nFor each bit: 1 = clear the corresponding interrupt bit. 0 = no change.",
#endif
    XPORT_INTR_PCI_CLEAR_REG_OFFSET,
    0,
    0,
    222,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    9,
    XPORT_INTR_PCI_CLEAR_FIELDS,
#endif /* RU_INCLUDE_FIELD_DB */
    ru_reg_size_32
};

/******************************************************************************
 * Register: XPORT_INTR_PCI_MASK_STATUS
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *XPORT_INTR_PCI_MASK_STATUS_FIELDS[] =
{
    &XPORT_INTR_PCI_MASK_STATUS_RESERVED0_FIELD,
    &XPORT_INTR_PCI_MASK_STATUS_LINK_DOWN_INTR_MASK_FIELD,
    &XPORT_INTR_PCI_MASK_STATUS_LINK_UP_INTR_MASK_FIELD,
    &XPORT_INTR_PCI_MASK_STATUS_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_MASK_FIELD,
    &XPORT_INTR_PCI_MASK_STATUS_XLMAC_INTR_MASK_FIELD,
    &XPORT_INTR_PCI_MASK_STATUS_MAC_REG_ERR_INTR_MASK_FIELD,
    &XPORT_INTR_PCI_MASK_STATUS_MAB_STATUS_INTR_MASK_FIELD,
    &XPORT_INTR_PCI_MASK_STATUS_MIB_REG_ERR_INTR_MASK_FIELD,
    &XPORT_INTR_PCI_MASK_STATUS_UBUS_ERR_INTR_MASK_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec XPORT_INTR_PCI_MASK_STATUS_REG = 
{
    "PCI_MASK_STATUS",
#if RU_INCLUDE_DESC
    "PCI interrupt Mask Clear Register",
    "This read-only register shows the current masking of the interrupts for the CPU processor.  There is one "
    "bit per interrupt source.  A value of 1 in a bit position indicates that the interrupt corresponding to "
    "that bit is currently masked.  Masking does not prevent the interrupt from appearing in the status register."
    "\nFor each bit: 1 = masked. 0 = not masked."
    "This write-only register is used to disable interrupts for the CPU processor.  There is one bit per interrupt "
    "source.  Writing a 1 to a bit in this register will set the mask bit for the corresponding interrupt.  Writing "
    "a 0 has no effect.  Note that it is not necessary to read-modify-write this register because bits that have "
    "zeros written to them are not affected."
    "\nFor each bit: 1 = disable the corresponding interrupt. 0 = no change."
    "This write-only register is used to enable interrupts for the CPU processor.  There is one bit per interrupt "
    "source.  Writing a 1 to a bit in this register will clear the mask bit for the corresponding interrupt.  Writing "
    "a 0 has no effect.  Note that it is not necessary to read-modify-write this register because bits that have "
    "zeros written to them are not affected."
    "\nFor each bit: 1 = enable the corresponding interrupt. 0 = no change."
    "This read-only register shows the current masking of the interrupts for the PCI bus.  There is one bit per"
    "interrupt source.  A value of 1 in a bit position indicates that the interrupt corresponding to that bit is"
    "currently masked.  Masking does not prevent the interrupt from appearing in the status register."
    "\nFor each bit: 1 = masked. 0 = not masked."
    "This write-only register is used to disable interrupts for the PCI bus.  There is one bit per interrupt source."
    "Writing a 1 to a bit in this register will set the mask bit for the corresponding interrupt.  Writing a 0 has no"
    "effect.  Note that it is not necessary to read-modify-write this register because bits that have zeros written "
    "to them are not affected."
    "\nFor each bit: 1 = disable the corresponding interrupt. 0 = no change."
    "This write-only register is used to enable interrupts for the PCI bus.  There is one bit per interrupt "
    "source.  Writing a 1 to a bit in this register will clear the mask bit for the corresponding interrupt.  Writing "
    "a 0 has no effect.  Note that it is not necessary to read-modify-write this register because bits that have "
    "zeros written to them are not affected."
    "\nFor each bit: 1 = enable the corresponding interrupt. 0 = no change.",
#endif
    XPORT_INTR_PCI_MASK_STATUS_REG_OFFSET,
    0,
    0,
    223,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    9,
    XPORT_INTR_PCI_MASK_STATUS_FIELDS,
#endif /* RU_INCLUDE_FIELD_DB */
    ru_reg_size_32
};

/******************************************************************************
 * Register: XPORT_INTR_PCI_MASK_SET
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *XPORT_INTR_PCI_MASK_SET_FIELDS[] =
{
    &XPORT_INTR_PCI_MASK_SET_RESERVED0_FIELD,
    &XPORT_INTR_PCI_MASK_SET_LINK_DOWN_INTR_MASK_FIELD,
    &XPORT_INTR_PCI_MASK_SET_LINK_UP_INTR_MASK_FIELD,
    &XPORT_INTR_PCI_MASK_SET_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_MASK_FIELD,
    &XPORT_INTR_PCI_MASK_SET_XLMAC_INTR_MASK_FIELD,
    &XPORT_INTR_PCI_MASK_SET_MAC_REG_ERR_INTR_MASK_FIELD,
    &XPORT_INTR_PCI_MASK_SET_MAB_STATUS_INTR_MASK_FIELD,
    &XPORT_INTR_PCI_MASK_SET_MIB_REG_ERR_INTR_MASK_FIELD,
    &XPORT_INTR_PCI_MASK_SET_UBUS_ERR_INTR_MASK_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec XPORT_INTR_PCI_MASK_SET_REG = 
{
    "PCI_MASK_SET",
#if RU_INCLUDE_DESC
    "PCI interrupt Mask Clear Register",
    "This read-only register shows the current masking of the interrupts for the CPU processor.  There is one "
    "bit per interrupt source.  A value of 1 in a bit position indicates that the interrupt corresponding to "
    "that bit is currently masked.  Masking does not prevent the interrupt from appearing in the status register."
    "\nFor each bit: 1 = masked. 0 = not masked."
    "This write-only register is used to disable interrupts for the CPU processor.  There is one bit per interrupt "
    "source.  Writing a 1 to a bit in this register will set the mask bit for the corresponding interrupt.  Writing "
    "a 0 has no effect.  Note that it is not necessary to read-modify-write this register because bits that have "
    "zeros written to them are not affected."
    "\nFor each bit: 1 = disable the corresponding interrupt. 0 = no change."
    "This write-only register is used to enable interrupts for the CPU processor.  There is one bit per interrupt "
    "source.  Writing a 1 to a bit in this register will clear the mask bit for the corresponding interrupt.  Writing "
    "a 0 has no effect.  Note that it is not necessary to read-modify-write this register because bits that have "
    "zeros written to them are not affected."
    "\nFor each bit: 1 = enable the corresponding interrupt. 0 = no change."
    "This read-only register shows the current masking of the interrupts for the PCI bus.  There is one bit per"
    "interrupt source.  A value of 1 in a bit position indicates that the interrupt corresponding to that bit is"
    "currently masked.  Masking does not prevent the interrupt from appearing in the status register."
    "\nFor each bit: 1 = masked. 0 = not masked."
    "This write-only register is used to disable interrupts for the PCI bus.  There is one bit per interrupt source."
    "Writing a 1 to a bit in this register will set the mask bit for the corresponding interrupt.  Writing a 0 has no"
    "effect.  Note that it is not necessary to read-modify-write this register because bits that have zeros written "
    "to them are not affected."
    "\nFor each bit: 1 = disable the corresponding interrupt. 0 = no change."
    "This write-only register is used to enable interrupts for the PCI bus.  There is one bit per interrupt "
    "source.  Writing a 1 to a bit in this register will clear the mask bit for the corresponding interrupt.  Writing "
    "a 0 has no effect.  Note that it is not necessary to read-modify-write this register because bits that have "
    "zeros written to them are not affected."
    "\nFor each bit: 1 = enable the corresponding interrupt. 0 = no change.",
#endif
    XPORT_INTR_PCI_MASK_SET_REG_OFFSET,
    0,
    0,
    224,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    9,
    XPORT_INTR_PCI_MASK_SET_FIELDS,
#endif /* RU_INCLUDE_FIELD_DB */
    ru_reg_size_32
};

/******************************************************************************
 * Register: XPORT_INTR_PCI_MASK_CLEAR
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *XPORT_INTR_PCI_MASK_CLEAR_FIELDS[] =
{
    &XPORT_INTR_PCI_MASK_CLEAR_RESERVED0_FIELD,
    &XPORT_INTR_PCI_MASK_CLEAR_LINK_DOWN_INTR_MASK_FIELD,
    &XPORT_INTR_PCI_MASK_CLEAR_LINK_UP_INTR_MASK_FIELD,
    &XPORT_INTR_PCI_MASK_CLEAR_TX_TIMESYNC_FIFO_ENTRY_VALID_INTR_MASK_FIELD,
    &XPORT_INTR_PCI_MASK_CLEAR_XLMAC_INTR_MASK_FIELD,
    &XPORT_INTR_PCI_MASK_CLEAR_MAC_REG_ERR_INTR_MASK_FIELD,
    &XPORT_INTR_PCI_MASK_CLEAR_MAB_STATUS_INTR_MASK_FIELD,
    &XPORT_INTR_PCI_MASK_CLEAR_MIB_REG_ERR_INTR_MASK_FIELD,
    &XPORT_INTR_PCI_MASK_CLEAR_UBUS_ERR_INTR_MASK_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec XPORT_INTR_PCI_MASK_CLEAR_REG = 
{
    "PCI_MASK_CLEAR",
#if RU_INCLUDE_DESC
    "PCI interrupt Mask Clear Register",
    "This read-only register shows the current masking of the interrupts for the CPU processor.  There is one "
    "bit per interrupt source.  A value of 1 in a bit position indicates that the interrupt corresponding to "
    "that bit is currently masked.  Masking does not prevent the interrupt from appearing in the status register."
    "\nFor each bit: 1 = masked. 0 = not masked."
    "This write-only register is used to disable interrupts for the CPU processor.  There is one bit per interrupt "
    "source.  Writing a 1 to a bit in this register will set the mask bit for the corresponding interrupt.  Writing "
    "a 0 has no effect.  Note that it is not necessary to read-modify-write this register because bits that have "
    "zeros written to them are not affected."
    "\nFor each bit: 1 = disable the corresponding interrupt. 0 = no change."
    "This write-only register is used to enable interrupts for the CPU processor.  There is one bit per interrupt "
    "source.  Writing a 1 to a bit in this register will clear the mask bit for the corresponding interrupt.  Writing "
    "a 0 has no effect.  Note that it is not necessary to read-modify-write this register because bits that have "
    "zeros written to them are not affected."
    "\nFor each bit: 1 = enable the corresponding interrupt. 0 = no change."
    "This read-only register shows the current masking of the interrupts for the PCI bus.  There is one bit per"
    "interrupt source.  A value of 1 in a bit position indicates that the interrupt corresponding to that bit is"
    "currently masked.  Masking does not prevent the interrupt from appearing in the status register."
    "\nFor each bit: 1 = masked. 0 = not masked."
    "This write-only register is used to disable interrupts for the PCI bus.  There is one bit per interrupt source."
    "Writing a 1 to a bit in this register will set the mask bit for the corresponding interrupt.  Writing a 0 has no"
    "effect.  Note that it is not necessary to read-modify-write this register because bits that have zeros written "
    "to them are not affected."
    "\nFor each bit: 1 = disable the corresponding interrupt. 0 = no change."
    "This write-only register is used to enable interrupts for the PCI bus.  There is one bit per interrupt "
    "source.  Writing a 1 to a bit in this register will clear the mask bit for the corresponding interrupt.  Writing "
    "a 0 has no effect.  Note that it is not necessary to read-modify-write this register because bits that have "
    "zeros written to them are not affected."
    "\nFor each bit: 1 = enable the corresponding interrupt. 0 = no change.",
#endif
    XPORT_INTR_PCI_MASK_CLEAR_REG_OFFSET,
    0,
    0,
    225,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    9,
    XPORT_INTR_PCI_MASK_CLEAR_FIELDS,
#endif /* RU_INCLUDE_FIELD_DB */
    ru_reg_size_32
};

/******************************************************************************
 * Block: XPORT_INTR
 ******************************************************************************/
static const ru_reg_rec *XPORT_INTR_REGS[] =
{
    &XPORT_INTR_CPU_STATUS_REG,
    &XPORT_INTR_CPU_SET_REG,
    &XPORT_INTR_CPU_CLEAR_REG,
    &XPORT_INTR_CPU_MASK_STATUS_REG,
    &XPORT_INTR_CPU_MASK_SET_REG,
    &XPORT_INTR_CPU_MASK_CLEAR_REG,
    &XPORT_INTR_PCI_STATUS_REG,
    &XPORT_INTR_PCI_SET_REG,
    &XPORT_INTR_PCI_CLEAR_REG,
    &XPORT_INTR_PCI_MASK_STATUS_REG,
    &XPORT_INTR_PCI_MASK_SET_REG,
    &XPORT_INTR_PCI_MASK_CLEAR_REG,
};

unsigned long XPORT_INTR_ADDRS[] =
{
    0x837f3200,
    0x837f7200,
};

const ru_block_rec XPORT_INTR_BLOCK = 
{
    "XPORT_INTR",
    XPORT_INTR_ADDRS,
    2,
    12,
    XPORT_INTR_REGS
};

/* End of file XPORT_INTR.c */
