/*
   Copyright (c) 2015 Broadcom Corporation
   All Rights Reserved

    <:label-BRCM:2015:DUAL/GPL:standard
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 2, as published by
    the Free Software Foundation (the "GPL").
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    
    A copy of the GPL is available at http://www.broadcom.com/licenses/GPLv2.php, or by
    writing to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
    
:>
*/

#ifndef _BCM63158_XPORT_XLMAC_CORE_AG_H_
#define _BCM63158_XPORT_XLMAC_CORE_AG_H_

//#include "access_macros.h"
#include "bcmtypes.h"
typedef struct
{
    uint8_t extended_hig2_en;
    uint8_t link_status_select;
    uint8_t sw_link_status;
    uint8_t xgmii_ipg_check_disable;
    uint8_t rs_soft_reset;
    uint8_t rsvd_5;
    uint8_t local_lpbk_leak_enb;
    uint8_t rsvd_4;
    uint8_t soft_reset;
    uint8_t lag_failover_en;
    uint8_t remove_failover_lpbk;
    uint8_t rsvd_1;
    uint8_t local_lpbk;
    uint8_t rx_en;
    uint8_t tx_en;
} xport_xlmac_core_ctrl;

typedef struct
{
    uint8_t tx_threshold;
    uint8_t ep_discard;
    uint8_t tx_preamble_length;
    uint8_t throt_denom;
    uint8_t throt_num;
    uint8_t average_ipg;
    uint8_t pad_threshold;
    uint8_t pad_en;
    uint8_t tx_any_start;
    uint8_t discard;
    uint8_t crc_mode;
} xport_xlmac_core_tx_ctrl;

typedef struct
{
    uint8_t rx_pass_pfc;
    uint8_t rx_pass_pause;
    uint8_t rx_pass_ctrl;
    uint8_t rsvd_3;
    uint8_t rsvd_2;
    uint8_t runt_threshold;
    uint8_t strict_preamble;
    uint8_t strip_crc;
    uint8_t rx_any_start;
    uint8_t rsvd_1;
} xport_xlmac_core_rx_ctrl;

typedef struct
{
    uint8_t reset_flow_control_timers_on_link_down;
    uint8_t drop_tx_data_on_link_interrupt;
    uint8_t drop_tx_data_on_remote_fault;
    uint8_t drop_tx_data_on_local_fault;
    uint8_t link_interruption_disable;
    uint8_t use_external_faults_for_tx;
    uint8_t remote_fault_disable;
    uint8_t local_fault_disable;
} xport_xlmac_core_rx_lss_ctrl;

typedef struct
{
    uint16_t pause_xoff_timer;
    uint8_t rsvd_2;
    uint8_t rsvd_1;
    uint8_t rx_pause_en;
    uint8_t tx_pause_en;
    uint8_t pause_refresh_en;
    uint16_t pause_refresh_timer;
} xport_xlmac_core_pause_ctrl;

typedef struct
{
    uint8_t tx_pfc_en;
    uint8_t rx_pfc_en;
    uint8_t pfc_stats_en;
    uint8_t rsvd;
    uint8_t force_pfc_xon;
    uint8_t pfc_refresh_en;
    uint16_t pfc_xoff_timer;
    uint16_t pfc_refresh_timer;
} xport_xlmac_core_pfc_ctrl;

typedef struct
{
    uint8_t llfc_img;
    uint8_t no_som_for_crc_llfc;
    uint8_t llfc_crc_ignore;
    uint8_t llfc_cut_through_mode;
    uint8_t llfc_in_ipg_only;
    uint8_t rx_llfc_en;
    uint8_t tx_llfc_en;
} xport_xlmac_core_llfc_ctrl;

typedef struct
{
    uint8_t link_status;
    uint8_t rx_pkt_overflow;
    uint8_t tx_ts_fifo_overflow;
    uint8_t tx_llfc_msg_overflow;
    uint8_t rsvd_2;
    uint8_t tx_pkt_overflow;
    uint8_t tx_pkt_underflow;
    uint8_t rx_msg_overflow;
    uint8_t rsvd_1;
} xport_xlmac_core_fifo_status;

typedef struct
{
    uint8_t clear_rx_pkt_overflow;
    uint8_t clear_tx_ts_fifo_overflow;
    uint8_t clear_tx_llfc_msg_overflow;
    uint8_t rsvd_2;
    uint8_t clear_tx_pkt_overflow;
    uint8_t clear_tx_pkt_underflow;
    uint8_t clear_rx_msg_overflow;
    uint8_t rsvd_1;
} xport_xlmac_core_clear_fifo_status;

typedef struct
{
    uint8_t e2efc_dual_modid_en;
    uint8_t e2ecc_legacy_imp_en;
    uint8_t e2ecc_dual_modid_en;
    uint8_t honor_pause_for_e2e;
    uint8_t e2e_enable;
} xport_xlmac_core_e2e_ctrl;

typedef struct
{
    uint8_t sum_ts_entry_valid;
    uint8_t sum_link_interruption_status;
    uint8_t sum_remote_fault_status;
    uint8_t sum_local_fault_status;
    uint8_t sum_rx_cdc_double_bit_err;
    uint8_t sum_rx_cdc_single_bit_err;
    uint8_t sum_tx_cdc_double_bit_err;
    uint8_t sum_tx_cdc_single_bit_err;
    uint8_t sum_rx_msg_overflow;
    uint8_t sum_rx_pkt_overflow;
    uint8_t sum_tx_ts_fifo_overflow;
    uint8_t sum_tx_llfc_msg_overflow;
    uint8_t sum_tx_pkt_overflow;
    uint8_t sum_tx_pkt_underflow;
} xport_xlmac_core_intr_status;

typedef struct
{
    uint8_t en_ts_entry_valid;
    uint8_t en_link_interruption_status;
    uint8_t en_remote_fault_status;
    uint8_t en_local_fault_status;
    uint8_t en_rx_cdc_double_bit_err;
    uint8_t en_rx_cdc_single_bit_err;
    uint8_t en_tx_cdc_double_bit_err;
    uint8_t en_tx_cdc_single_bit_err;
    uint8_t en_rx_msg_overflow;
    uint8_t en_rx_pkt_overflow;
    uint8_t en_tx_ts_fifo_overflow;
    uint8_t en_tx_llfc_msg_overflow;
    uint8_t en_tx_pkt_overflow;
    uint8_t en_tx_pkt_underflow;
} xport_xlmac_core_intr_enable;

int ag_drv_xport_xlmac_core_ctrl_set(uint8_t port_id, const xport_xlmac_core_ctrl *ctrl);
int ag_drv_xport_xlmac_core_ctrl_get(uint8_t port_id, xport_xlmac_core_ctrl *ctrl);
int ag_drv_xport_xlmac_core_mode_set(uint8_t port_id, uint8_t speed_mode, uint8_t no_sop_for_crc_hg, uint8_t hdr_mode);
int ag_drv_xport_xlmac_core_mode_get(uint8_t port_id, uint8_t *speed_mode, uint8_t *no_sop_for_crc_hg, uint8_t *hdr_mode);
int ag_drv_xport_xlmac_core_spare0_set(uint8_t port_id, uint32_t rsvd);
int ag_drv_xport_xlmac_core_spare0_get(uint8_t port_id, uint32_t *rsvd);
int ag_drv_xport_xlmac_core_spare1_set(uint8_t port_id, uint8_t rsvd);
int ag_drv_xport_xlmac_core_spare1_get(uint8_t port_id, uint8_t *rsvd);
int ag_drv_xport_xlmac_core_tx_ctrl_set(uint8_t port_id, const xport_xlmac_core_tx_ctrl *tx_ctrl);
int ag_drv_xport_xlmac_core_tx_ctrl_get(uint8_t port_id, xport_xlmac_core_tx_ctrl *tx_ctrl);
int ag_drv_xport_xlmac_core_tx_mac_sa_set(uint8_t port_id, uint64_t ctrl_sa);
int ag_drv_xport_xlmac_core_tx_mac_sa_get(uint8_t port_id, uint64_t *ctrl_sa);
int ag_drv_xport_xlmac_core_rx_ctrl_set(uint8_t port_id, const xport_xlmac_core_rx_ctrl *rx_ctrl);
int ag_drv_xport_xlmac_core_rx_ctrl_get(uint8_t port_id, xport_xlmac_core_rx_ctrl *rx_ctrl);
int ag_drv_xport_xlmac_core_rx_mac_sa_set(uint8_t port_id, uint64_t rx_sa);
int ag_drv_xport_xlmac_core_rx_mac_sa_get(uint8_t port_id, uint64_t *rx_sa);
int ag_drv_xport_xlmac_core_rx_max_size_set(uint8_t port_id, uint16_t rx_max_size);
int ag_drv_xport_xlmac_core_rx_max_size_get(uint8_t port_id, uint16_t *rx_max_size);
int ag_drv_xport_xlmac_core_rx_vlan_tag_set(uint8_t port_id, uint8_t outer_vlan_tag_enable, uint8_t inner_vlan_tag_enable, uint16_t outer_vlan_tag, uint16_t inner_vlan_tag);
int ag_drv_xport_xlmac_core_rx_vlan_tag_get(uint8_t port_id, uint8_t *outer_vlan_tag_enable, uint8_t *inner_vlan_tag_enable, uint16_t *outer_vlan_tag, uint16_t *inner_vlan_tag);
int ag_drv_xport_xlmac_core_rx_lss_ctrl_set(uint8_t port_id, const xport_xlmac_core_rx_lss_ctrl *rx_lss_ctrl);
int ag_drv_xport_xlmac_core_rx_lss_ctrl_get(uint8_t port_id, xport_xlmac_core_rx_lss_ctrl *rx_lss_ctrl);
int ag_drv_xport_xlmac_core_rx_lss_status_get(uint8_t port_id, uint8_t *link_interruption_status, uint8_t *remote_fault_status, uint8_t *local_fault_status);
int ag_drv_xport_xlmac_core_clear_rx_lss_status_set(uint8_t port_id, uint8_t clear_link_interruption_status, uint8_t clear_remote_fault_status, uint8_t clear_local_fault_status);
int ag_drv_xport_xlmac_core_clear_rx_lss_status_get(uint8_t port_id, uint8_t *clear_link_interruption_status, uint8_t *clear_remote_fault_status, uint8_t *clear_local_fault_status);
int ag_drv_xport_xlmac_core_pause_ctrl_set(uint8_t port_id, const xport_xlmac_core_pause_ctrl *pause_ctrl);
int ag_drv_xport_xlmac_core_pause_ctrl_get(uint8_t port_id, xport_xlmac_core_pause_ctrl *pause_ctrl);
int ag_drv_xport_xlmac_core_pfc_ctrl_set(uint8_t port_id, const xport_xlmac_core_pfc_ctrl *pfc_ctrl);
int ag_drv_xport_xlmac_core_pfc_ctrl_get(uint8_t port_id, xport_xlmac_core_pfc_ctrl *pfc_ctrl);
int ag_drv_xport_xlmac_core_pfc_type_set(uint8_t port_id, uint16_t pfc_eth_type);
int ag_drv_xport_xlmac_core_pfc_type_get(uint8_t port_id, uint16_t *pfc_eth_type);
int ag_drv_xport_xlmac_core_pfc_opcode_set(uint8_t port_id, uint16_t pfc_opcode);
int ag_drv_xport_xlmac_core_pfc_opcode_get(uint8_t port_id, uint16_t *pfc_opcode);
int ag_drv_xport_xlmac_core_pfc_da_set(uint8_t port_id, uint64_t pfc_macda);
int ag_drv_xport_xlmac_core_pfc_da_get(uint8_t port_id, uint64_t *pfc_macda);
int ag_drv_xport_xlmac_core_llfc_ctrl_set(uint8_t port_id, const xport_xlmac_core_llfc_ctrl *llfc_ctrl);
int ag_drv_xport_xlmac_core_llfc_ctrl_get(uint8_t port_id, xport_xlmac_core_llfc_ctrl *llfc_ctrl);
int ag_drv_xport_xlmac_core_tx_llfc_msg_fields_set(uint8_t port_id, uint16_t llfc_xoff_time, uint8_t tx_llfc_fc_obj_logical, uint8_t tx_llfc_msg_type_logical);
int ag_drv_xport_xlmac_core_tx_llfc_msg_fields_get(uint8_t port_id, uint16_t *llfc_xoff_time, uint8_t *tx_llfc_fc_obj_logical, uint8_t *tx_llfc_msg_type_logical);
int ag_drv_xport_xlmac_core_rx_llfc_msg_fields_set(uint8_t port_id, uint8_t rx_llfc_fc_obj_physical, uint8_t rx_llfc_msg_type_physical, uint8_t rx_llfc_fc_obj_logical, uint8_t rx_llfc_msg_type_logical);
int ag_drv_xport_xlmac_core_rx_llfc_msg_fields_get(uint8_t port_id, uint8_t *rx_llfc_fc_obj_physical, uint8_t *rx_llfc_msg_type_physical, uint8_t *rx_llfc_fc_obj_logical, uint8_t *rx_llfc_msg_type_logical);
int ag_drv_xport_xlmac_core_tx_timestamp_fifo_data_get(uint8_t port_id, uint8_t *ts_entry_valid, uint16_t *sequence_id, uint32_t *time_stamp);
int ag_drv_xport_xlmac_core_tx_timestamp_fifo_status_get(uint8_t port_id, uint8_t *entry_count);
int ag_drv_xport_xlmac_core_fifo_status_get(uint8_t port_id, xport_xlmac_core_fifo_status *fifo_status);
int ag_drv_xport_xlmac_core_clear_fifo_status_set(uint8_t port_id, const xport_xlmac_core_clear_fifo_status *clear_fifo_status);
int ag_drv_xport_xlmac_core_clear_fifo_status_get(uint8_t port_id, xport_xlmac_core_clear_fifo_status *clear_fifo_status);
int ag_drv_xport_xlmac_core_lag_failover_status_get(uint8_t port_id, uint8_t *rsvd, uint8_t *lag_failover_loopback);
int ag_drv_xport_xlmac_core_eee_ctrl_set(uint8_t port_id, uint8_t rsvd, uint8_t eee_en);
int ag_drv_xport_xlmac_core_eee_ctrl_get(uint8_t port_id, uint8_t *rsvd, uint8_t *eee_en);
int ag_drv_xport_xlmac_core_eee_timers_set(uint8_t port_id, uint16_t eee_ref_count, uint16_t eee_wake_timer, uint32_t eee_delay_entry_timer);
int ag_drv_xport_xlmac_core_eee_timers_get(uint8_t port_id, uint16_t *eee_ref_count, uint16_t *eee_wake_timer, uint32_t *eee_delay_entry_timer);
int ag_drv_xport_xlmac_core_eee_1_sec_link_status_timer_set(uint8_t port_id, uint32_t one_second_timer);
int ag_drv_xport_xlmac_core_eee_1_sec_link_status_timer_get(uint8_t port_id, uint32_t *one_second_timer);
int ag_drv_xport_xlmac_core_higig_hdr_0_set(uint8_t port_id, uint64_t higig_hdr_0);
int ag_drv_xport_xlmac_core_higig_hdr_0_get(uint8_t port_id, uint64_t *higig_hdr_0);
int ag_drv_xport_xlmac_core_higig_hdr_1_set(uint8_t port_id, uint64_t higig_hdr_1);
int ag_drv_xport_xlmac_core_higig_hdr_1_get(uint8_t port_id, uint64_t *higig_hdr_1);
int ag_drv_xport_xlmac_core_gmii_eee_ctrl_set(uint8_t port_id, uint8_t gmii_lpi_predict_mode_en, uint16_t gmii_lpi_predict_threshold);
int ag_drv_xport_xlmac_core_gmii_eee_ctrl_get(uint8_t port_id, uint8_t *gmii_lpi_predict_mode_en, uint16_t *gmii_lpi_predict_threshold);
int ag_drv_xport_xlmac_core_timestamp_adjust_set(uint8_t port_id, uint8_t ts_use_cs_offset, uint8_t ts_tsts_adjust, uint16_t ts_osts_adjust);
int ag_drv_xport_xlmac_core_timestamp_adjust_get(uint8_t port_id, uint8_t *ts_use_cs_offset, uint8_t *ts_tsts_adjust, uint16_t *ts_osts_adjust);
int ag_drv_xport_xlmac_core_timestamp_byte_adjust_set(uint8_t port_id, uint8_t rx_timer_byte_adjust_en, uint16_t rx_timer_byte_adjust, uint8_t tx_timer_byte_adjust_en, uint16_t tx_timer_byte_adjust);
int ag_drv_xport_xlmac_core_timestamp_byte_adjust_get(uint8_t port_id, uint8_t *rx_timer_byte_adjust_en, uint16_t *rx_timer_byte_adjust, uint8_t *tx_timer_byte_adjust_en, uint16_t *tx_timer_byte_adjust);
int ag_drv_xport_xlmac_core_tx_crc_corrupt_ctrl_set(uint8_t port_id, uint32_t prog_tx_crc, uint8_t tx_crc_corruption_mode, uint8_t tx_crc_corrupt_en, uint8_t tx_err_corrupts_crc);
int ag_drv_xport_xlmac_core_tx_crc_corrupt_ctrl_get(uint8_t port_id, uint32_t *prog_tx_crc, uint8_t *tx_crc_corruption_mode, uint8_t *tx_crc_corrupt_en, uint8_t *tx_err_corrupts_crc);
int ag_drv_xport_xlmac_core_e2e_ctrl_set(uint8_t port_id, const xport_xlmac_core_e2e_ctrl *e2e_ctrl);
int ag_drv_xport_xlmac_core_e2e_ctrl_get(uint8_t port_id, xport_xlmac_core_e2e_ctrl *e2e_ctrl);
int ag_drv_xport_xlmac_core_e2ecc_module_hdr_0_set(uint8_t port_id, uint64_t e2ecc_module_hdr_0);
int ag_drv_xport_xlmac_core_e2ecc_module_hdr_0_get(uint8_t port_id, uint64_t *e2ecc_module_hdr_0);
int ag_drv_xport_xlmac_core_e2ecc_module_hdr_1_set(uint8_t port_id, uint64_t e2ecc_module_hdr_1);
int ag_drv_xport_xlmac_core_e2ecc_module_hdr_1_get(uint8_t port_id, uint64_t *e2ecc_module_hdr_1);
int ag_drv_xport_xlmac_core_e2ecc_data_hdr_0_set(uint8_t port_id, uint64_t e2ecc_data_hdr_0);
int ag_drv_xport_xlmac_core_e2ecc_data_hdr_0_get(uint8_t port_id, uint64_t *e2ecc_data_hdr_0);
int ag_drv_xport_xlmac_core_e2ecc_data_hdr_1_set(uint8_t port_id, uint64_t e2ecc_data_hdr_1);
int ag_drv_xport_xlmac_core_e2ecc_data_hdr_1_get(uint8_t port_id, uint64_t *e2ecc_data_hdr_1);
int ag_drv_xport_xlmac_core_e2efc_module_hdr_0_set(uint8_t port_id, uint64_t e2efc_module_hdr_0);
int ag_drv_xport_xlmac_core_e2efc_module_hdr_0_get(uint8_t port_id, uint64_t *e2efc_module_hdr_0);
int ag_drv_xport_xlmac_core_e2efc_module_hdr_1_set(uint8_t port_id, uint64_t e2efc_module_hdr_1);
int ag_drv_xport_xlmac_core_e2efc_module_hdr_1_get(uint8_t port_id, uint64_t *e2efc_module_hdr_1);
int ag_drv_xport_xlmac_core_e2efc_data_hdr_0_set(uint8_t port_id, uint64_t e2efc_data_hdr_0);
int ag_drv_xport_xlmac_core_e2efc_data_hdr_0_get(uint8_t port_id, uint64_t *e2efc_data_hdr_0);
int ag_drv_xport_xlmac_core_e2efc_data_hdr_1_set(uint8_t port_id, uint64_t e2efc_data_hdr_1);
int ag_drv_xport_xlmac_core_e2efc_data_hdr_1_get(uint8_t port_id, uint64_t *e2efc_data_hdr_1);
int ag_drv_xport_xlmac_core_txfifo_cell_cnt_get(uint8_t port_id, uint8_t *cell_cnt);
int ag_drv_xport_xlmac_core_txfifo_cell_req_cnt_get(uint8_t port_id, uint8_t *req_cnt);
int ag_drv_xport_xlmac_core_mem_ctrl_set(uint8_t port_id, uint16_t tx_cdc_mem_ctrl_tm, uint16_t rx_cdc_mem_ctrl_tm);
int ag_drv_xport_xlmac_core_mem_ctrl_get(uint8_t port_id, uint16_t *tx_cdc_mem_ctrl_tm, uint16_t *rx_cdc_mem_ctrl_tm);
int ag_drv_xport_xlmac_core_ecc_ctrl_set(uint8_t port_id, uint8_t tx_cdc_ecc_ctrl_en, uint8_t rx_cdc_ecc_ctrl_en);
int ag_drv_xport_xlmac_core_ecc_ctrl_get(uint8_t port_id, uint8_t *tx_cdc_ecc_ctrl_en, uint8_t *rx_cdc_ecc_ctrl_en);
int ag_drv_xport_xlmac_core_ecc_force_double_bit_err_set(uint8_t port_id, uint8_t tx_cdc_force_double_bit_err, uint8_t rx_cdc_force_double_bit_err);
int ag_drv_xport_xlmac_core_ecc_force_double_bit_err_get(uint8_t port_id, uint8_t *tx_cdc_force_double_bit_err, uint8_t *rx_cdc_force_double_bit_err);
int ag_drv_xport_xlmac_core_ecc_force_single_bit_err_set(uint8_t port_id, uint8_t tx_cdc_force_single_bit_err, uint8_t rx_cdc_force_single_bit_err);
int ag_drv_xport_xlmac_core_ecc_force_single_bit_err_get(uint8_t port_id, uint8_t *tx_cdc_force_single_bit_err, uint8_t *rx_cdc_force_single_bit_err);
int ag_drv_xport_xlmac_core_rx_cdc_ecc_status_get(uint8_t port_id, uint8_t *rx_cdc_double_bit_err, uint8_t *rx_cdc_single_bit_err);
int ag_drv_xport_xlmac_core_tx_cdc_ecc_status_get(uint8_t port_id, uint8_t *tx_cdc_double_bit_err, uint8_t *tx_cdc_single_bit_err);
int ag_drv_xport_xlmac_core_clear_ecc_status_set(uint8_t port_id, uint8_t clear_tx_cdc_double_bit_err, uint8_t clear_tx_cdc_single_bit_err, uint8_t clear_rx_cdc_double_bit_err, uint8_t clear_rx_cdc_single_bit_err);
int ag_drv_xport_xlmac_core_clear_ecc_status_get(uint8_t port_id, uint8_t *clear_tx_cdc_double_bit_err, uint8_t *clear_tx_cdc_single_bit_err, uint8_t *clear_rx_cdc_double_bit_err, uint8_t *clear_rx_cdc_single_bit_err);
int ag_drv_xport_xlmac_core_intr_status_get(uint8_t port_id, xport_xlmac_core_intr_status *intr_status);
int ag_drv_xport_xlmac_core_intr_enable_set(uint8_t port_id, const xport_xlmac_core_intr_enable *intr_enable);
int ag_drv_xport_xlmac_core_intr_enable_get(uint8_t port_id, xport_xlmac_core_intr_enable *intr_enable);
int ag_drv_xport_xlmac_core_version_id_get(uint8_t port_id, uint16_t *xlmac_version);

#ifdef USE_BDMF_SHELL
bdmfmon_handle_t ag_drv_xport_xlmac_core_cli_init(bdmfmon_handle_t driver_dir);
#endif


#endif

