/*
<:copyright-BRCM:2012:DUAL/GPL:standard 

   Copyright (c) 2012 Broadcom 
   All Rights Reserved

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License, version 2, as published by
the Free Software Foundation (the "GPL").

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.


A copy of the GPL is available at http://www.broadcom.com/licenses/GPLv2.php, or by
writing to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.

:>

*/                       

#ifndef __6855_INTR_H
#define __6855_INTR_H

#ifdef __cplusplus
    extern "C" {
#endif

/*=====================================================================*/
/* SPI Table Offset                                                    */
/*=====================================================================*/
#define SPI_TABLE_OFFSET               32
#define SPI_TABLE_OFFSET1              (SPI_TABLE_OFFSET + 32)
#define SPI_TABLE_OFFSET2              (SPI_TABLE_OFFSET1 + 32)
#define SPI_TABLE_OFFSET3              (SPI_TABLE_OFFSET2 + 32)
#define SPI_TABLE_OFFSET4              (SPI_TABLE_OFFSET3 + 32)
#define SPI_TABLE_OFFSET5              (SPI_TABLE_OFFSET4 + 32)

/*=====================================================================*/
/* Physical Interrupt IDs                                              */
/*=====================================================================*/
    /*  ------------- CHIP_IRQS[31-0] ----------------------------*/
#define INTERRUPT_A7_AXIERR         (SPI_TABLE_OFFSET + 0)
#define INTERRUPT_A7_INTERR         (SPI_TABLE_OFFSET + 1)
#define INTERRUPT_A7_CCIERR         (SPI_TABLE_OFFSET + 2)
#define INTERRUPT_A7_CCIOVFLOW      (SPI_TABLE_OFFSET + 3)
#define INTERRUPT_THERM_HIGH        (SPI_TABLE_OFFSET + 4)
#define INTERRUPT_THERM_LOW         (SPI_TABLE_OFFSET + 5)
#define INTERRUPT_THERM_SHUTDOWN    (SPI_TABLE_OFFSET + 6)
#define INTERRUPT_PMU               (SPI_TABLE_OFFSET + 7)  /* 3 interrupts */
#define INTERRUPT_A7_COMMON         (SPI_TABLE_OFFSET + 17)
#define INTERRUPT_MEMC_SEC          (SPI_TABLE_OFFSET + 19)
#define INTERRUPT_PER_SEC_ACC_VIOL  (SPI_TABLE_OFFSET + 20)
#define INTERRUPT_A7_UBUS_RC        (SPI_TABLE_OFFSET + 21)
#define INTERRUPT_A7_UBUS_STAT_REG  (SPI_TABLE_OFFSET + 22)
#define INTERRUPT_DG                (SPI_TABLE_OFFSET + 28)
#define INTERRUPT_PMC_TEMP_WARN     (SPI_TABLE_OFFSET + 29)

#define INTERRUPT_ARM_UART0         (SPI_TABLE_OFFSET + 32)
#define INTERRUPT_ARM_UART1         (SPI_TABLE_OFFSET + 33)
#define INTERRUPT_HS_UART           (SPI_TABLE_OFFSET + 34)
#define INTERRUPT_HS_SPIM           (SPI_TABLE_OFFSET + 36)
#define INTERRUPT_NAND_FLASH        (SPI_TABLE_OFFSET + 37)
#define INTERRUPT_MEMC              (SPI_TABLE_OFFSET + 38)
#define INTERRUPT_USBD              (SPI_TABLE_OFFSET + 41)
#define INTERRUPT_PCM               (SPI_TABLE_OFFSET + 42)
#define INTERRUPT_PCIE_0_CPU_INTR   (SPI_TABLE_OFFSET + 43)
#define INTERRUPT_PCIE_1_CPU_INTR   (SPI_TABLE_OFFSET + 44)
#define INTERRUPT_UBUS2AXI_WLAN_CCM (SPI_TABLE_OFFSET + 46)
#define INTERRUPT_UBUS2AXI_WLAN0_D11MAC (SPI_TABLE_OFFSET + 47)
#define INTERRUPT_UBUS2AXI_WLAN0_M2MDMA (SPI_TABLE_OFFSET + 48)
#define INTERRUPT_UBUS4_SYS         (SPI_TABLE_OFFSET + 63)

#define INTERRUPT_USB_OHCI          (SPI_TABLE_OFFSET + 72)
#define INTERRUPT_USB_EHCI          (SPI_TABLE_OFFSET + 73)
#define INTERRUPT_USB_XHCI          (SPI_TABLE_OFFSET + 74)
#define INTERRUPT_USB_BRIDGE        (SPI_TABLE_OFFSET + 75)
#define INTERRUPT_USB_EVENTS        (SPI_TABLE_OFFSET + 76)
#define INTERRUPT_I2C               (SPI_TABLE_OFFSET + 77)
#define INTERRUPT_I2S               (SPI_TABLE_OFFSET + 78)
#define INTERRUPT_O_RNG             (SPI_TABLE_OFFSET + 81)
#define INTERRUPT_PL081_DMA         (SPI_TABLE_OFFSET + 85)
#define INTERRUPT_SDIO_EMMC_L1      (SPI_TABLE_OFFSET + 86)
#define INTERRUPT_I2C1              (SPI_TABLE_OFFSET + 87)
#define INTERRUPT_SGMII_SIGDET_INV  (SPI_TABLE_OFFSET + 88)
#define INTERRUPT_SGMII_SIGDET      (SPI_TABLE_OFFSET + 89)
#define INTERRUPT_SIM_PRESENCE      (SPI_TABLE_OFFSET + 93)
#define INTERRUPT_SIM               (SPI_TABLE_OFFSET + 94)
#define INTERRUPT_SIM_SHURDOWN      (SPI_TABLE_OFFSET + 95)

#define INTERRUPT_WAN_EPON_TOP      (SPI_TABLE_OFFSET + 96)
#define INTERRUPT_WAN_NCO_GPON      (SPI_TABLE_OFFSET + 97)
#define INTERRUPT_WAN_GPON_TX       (SPI_TABLE_OFFSET + 98)
#define INTERRUPT_WAN_GPON_RX       (SPI_TABLE_OFFSET + 99)
#define INTERRUPT_WAN_PMD_PLL1_LOCK (SPI_TABLE_OFFSET + 100)
#define INTERRUPT_WAN_PMD_PLL0_LOCK (SPI_TABLE_OFFSET + 101)
#define INTERRUPT_WAN_PMD_SIGNAL_DETECT_0 (SPI_TABLE_OFFSET + 102)
#define INTERRUPT_WAN_PMD_ENERGY_DETECT_0 (SPI_TABLE_OFFSET + 103)
#define INTERRUPT_WAN_PMD_RX_LOCK_0 (SPI_TABLE_OFFSET + 104)
#define INTERRUPT_WAN_XGTX_OUT0     (SPI_TABLE_OFFSET + 105)
#define INTERRUPT_WAN_XGTX_OUT1     (SPI_TABLE_OFFSET + 106)
#define INTERRUPT_WAN_XGRX          (SPI_TABLE_OFFSET + 107)
#define INTERRUPT_WAN_XGTX_OUT2     (SPI_TABLE_OFFSET + 108)
#define INTERRUPT_WAN_XGTX_OUT3     (SPI_TABLE_OFFSET + 109)
#define INTERRUPT_PCM_DMA0          (SPI_TABLE_OFFSET + 116) 
#define INTERRUPT_PCM_DMA1          (SPI_TABLE_OFFSET + 117) 
#define INTERRUPT_MDIO_ERR          (SPI_TABLE_OFFSET + 118)
#define INTERRUPT_MDIO_DONE         (SPI_TABLE_OFFSET + 119)
#define INTERRUPT_PER_EXT_0         (SPI_TABLE_OFFSET + 120)
#define INTERRUPT_PER_EXT_1         (SPI_TABLE_OFFSET + 121)
#define INTERRUPT_PER_EXT_2         (SPI_TABLE_OFFSET + 122)
#define INTERRUPT_PER_EXT_3         (SPI_TABLE_OFFSET + 123)
#define INTERRUPT_PER_EXT_4         (SPI_TABLE_OFFSET + 124)
#define INTERRUPT_PER_EXT_5         (SPI_TABLE_OFFSET + 125)
#define INTERRUPT_PER_EXT_6         (SPI_TABLE_OFFSET + 126)
#define INTERRUPT_PER_EXT_7         (SPI_TABLE_OFFSET + 127)

#define INTERRUPT_XRDP_QUEUE_0      (SPI_TABLE_OFFSET + 128)
#define INTERRUPT_XRDP_QUEUE_1      (SPI_TABLE_OFFSET + 129)
#define INTERRUPT_XRDP_QUEUE_2      (SPI_TABLE_OFFSET + 130)
#define INTERRUPT_XRDP_QUEUE_3      (SPI_TABLE_OFFSET + 131)
#define INTERRUPT_XRDP_QUEUE_4      (SPI_TABLE_OFFSET + 132)
#define INTERRUPT_XRDP_QUEUE_5      (SPI_TABLE_OFFSET + 133)
#define INTERRUPT_XRDP_QUEUE_6      (SPI_TABLE_OFFSET + 134)
#define INTERRUPT_XRDP_QUEUE_7      (SPI_TABLE_OFFSET + 135)
#define INTERRUPT_XRDP_QUEUE_8      (SPI_TABLE_OFFSET + 136)
#define INTERRUPT_XRDP_QUEUE_9      (SPI_TABLE_OFFSET + 137)
#define INTERRUPT_XRDP_QUEUE_10     (SPI_TABLE_OFFSET + 138)
#define INTERRUPT_XRDP_QUEUE_11     (SPI_TABLE_OFFSET + 139)
#define INTERRUPT_XRDP_QUEUE_12     (SPI_TABLE_OFFSET + 140)
#define INTERRUPT_XRDP_QUEUE_13     (SPI_TABLE_OFFSET + 141)
#define INTERRUPT_XRDP_QUEUE_14     (SPI_TABLE_OFFSET + 142)
#define INTERRUPT_XRDP_QUEUE_15     (SPI_TABLE_OFFSET + 143)
#define INTERRUPT_XRDP_QUEUE_16     (SPI_TABLE_OFFSET + 144)
#define INTERRUPT_XRDP_QUEUE_17     (SPI_TABLE_OFFSET + 145)
#define INTERRUPT_XRDP_QUEUE_18     (SPI_TABLE_OFFSET + 146)
#define INTERRUPT_XRDP_QUEUE_19     (SPI_TABLE_OFFSET + 147)
#define INTERRUPT_XRDP_QUEUE_20     (SPI_TABLE_OFFSET + 148)
#define INTERRUPT_XRDP_QUEUE_21     (SPI_TABLE_OFFSET + 149)
#define INTERRUPT_XRDP_QUEUE_22     (SPI_TABLE_OFFSET + 150)
#define INTERRUPT_XRDP_QUEUE_23     (SPI_TABLE_OFFSET + 151)
#define INTERRUPT_XRDP_QUEUE_24     (SPI_TABLE_OFFSET + 152)
#define INTERRUPT_XRDP_QUEUE_25     (SPI_TABLE_OFFSET + 153)
#define INTERRUPT_XRDP_QUEUE_26     (SPI_TABLE_OFFSET + 154)
#define INTERRUPT_XRDP_QUEUE_27     (SPI_TABLE_OFFSET + 155)
#define INTERRUPT_XRDP_QUEUE_28     (SPI_TABLE_OFFSET + 156)
#define INTERRUPT_XRDP_QUEUE_29     (SPI_TABLE_OFFSET + 157)
#define INTERRUPT_XRDP_QUEUE_30     (SPI_TABLE_OFFSET + 158)
#define INTERRUPT_XRDP_QUEUE_31     (SPI_TABLE_OFFSET + 159)

#define INTERRUPT_XRDP_QUEUE_32     (SPI_TABLE_OFFSET + 160)
#define INTERRUPT_XRDP_QUEUE_33     (SPI_TABLE_OFFSET + 161)
#define INTERRUPT_XRDP_QUEUE_34     (SPI_TABLE_OFFSET + 162)
#define INTERRUPT_XRDP_QUEUE_35     (SPI_TABLE_OFFSET + 163)
#define INTERRUPT_XRDP_QUEUE_36     (SPI_TABLE_OFFSET + 164)
#define INTERRUPT_XRDP_QUEUE_37     (SPI_TABLE_OFFSET + 165)
#define INTERRUPT_XRDP_QUEUE_38     (SPI_TABLE_OFFSET + 166)
#define INTERRUPT_XRDP_QUEUE_39     (SPI_TABLE_OFFSET + 167)
#define INTERRUPT_XRDP_QUEUE_40     (SPI_TABLE_OFFSET + 168)
#define INTERRUPT_XRDP_QUEUE_41     (SPI_TABLE_OFFSET + 169)
#define INTERRUPT_XRDP_QUEUE_42     (SPI_TABLE_OFFSET + 170)
#define INTERRUPT_XRDP_QUEUE_43     (SPI_TABLE_OFFSET + 171)
#define INTERRUPT_XRDP_QUEUE_44     (SPI_TABLE_OFFSET + 172)
#define INTERRUPT_XRDP_QUEUE_45     (SPI_TABLE_OFFSET + 173)
#define INTERRUPT_XRDP_QUEUE_46     (SPI_TABLE_OFFSET + 174)
#define INTERRUPT_XRDP_QUEUE_47     (SPI_TABLE_OFFSET + 175)
#define INTERRUPT_XRDP_QUEUE_48     (SPI_TABLE_OFFSET + 176)
#define INTERRUPT_XRDP_QUEUE_49     (SPI_TABLE_OFFSET + 177)
#define INTERRUPT_XRDP_QUEUE_50     (SPI_TABLE_OFFSET + 178)
#define INTERRUPT_XRDP_QUEUE_51     (SPI_TABLE_OFFSET + 179)
#define INTERRUPT_XRDP_QUEUE_52     (SPI_TABLE_OFFSET + 180)

#define INTERRUPT_XRDP_FPM          (INTERRUPT_XRDP_QUEUE_32)


#ifndef __ASSEMBLER__
#define _2MAP(V) (bcm_legacy_irq_map[(V - SPI_TABLE_OFFSET)])
#define INTERRUPT_ID_DG                   _2MAP(INTERRUPT_DG)
#define INTERRUPT_ID_HS_UART              _2MAP(INTERRUPT_HS_UART)
#define INTERRUPT_ID_NAND_FLASH           _2MAP(INTERRUPT_NAND_FLASH)
#define INTERRUPT_ID_EXTERNAL_0           _2MAP(INTERRUPT_PER_EXT_0)
#define INTERRUPT_ID_EXTERNAL_1           _2MAP(INTERRUPT_PER_EXT_1)
#define INTERRUPT_ID_EXTERNAL_2           _2MAP(INTERRUPT_PER_EXT_2)
#define INTERRUPT_ID_EXTERNAL_3           _2MAP(INTERRUPT_PER_EXT_3)
#define INTERRUPT_ID_EXTERNAL_4           _2MAP(INTERRUPT_PER_EXT_4)
#define INTERRUPT_ID_EXTERNAL_5           _2MAP(INTERRUPT_PER_EXT_5)
#define INTERRUPT_ID_EXTERNAL_6           _2MAP(INTERRUPT_PER_EXT_6)
#define INTERRUPT_ID_EXTERNAL_7           _2MAP(INTERRUPT_PER_EXT_7)
#define INTERRUPT_ID_EXTERNAL_MAX         INTERRUPT_ID_EXTERNAL_7
#define INTERRUPT_ID_WLAN_CCM             _2MAP(INTERRUPT_UBUS2AXI_WLAN_CCM)
#define INTERRUPT_ID_WLAN0_D11MAC         _2MAP(INTERRUPT_UBUS2AXI_WLAN0_D11MAC)
#define INTERRUPT_ID_USB_XHCI             _2MAP(INTERRUPT_USB_XHCI)
#define INTERRUPT_ID_USB_OHCI             _2MAP(INTERRUPT_USB_OHCI)
#define INTERRUPT_ID_USB_EHCI             _2MAP(INTERRUPT_USB_EHCI)
#define INTERRUPT_ID_WAN_GPON_RX          _2MAP(INTERRUPT_WAN_GPON_RX)
#define INTERRUPT_ID_WAN_GPON_TX          _2MAP(INTERRUPT_WAN_GPON_TX)
#define INTERRUPT_ID_XRDP_QUEUE_0          _2MAP(INTERRUPT_XRDP_QUEUE_0)
#define INTERRUPT_ID_XRDP_QUEUE_1            _2MAP(INTERRUPT_XRDP_QUEUE_1)
#define INTERRUPT_ID_XRDP_QUEUE_2            _2MAP(INTERRUPT_XRDP_QUEUE_2)
#define INTERRUPT_ID_XRDP_QUEUE_3            _2MAP(INTERRUPT_XRDP_QUEUE_3)
#define INTERRUPT_ID_XRDP_QUEUE_4            _2MAP(INTERRUPT_XRDP_QUEUE_4)
#define INTERRUPT_ID_XRDP_QUEUE_5            _2MAP(INTERRUPT_XRDP_QUEUE_5)
#define INTERRUPT_ID_XRDP_QUEUE_6            _2MAP(INTERRUPT_XRDP_QUEUE_6)
#define INTERRUPT_ID_XRDP_QUEUE_7            _2MAP(INTERRUPT_XRDP_QUEUE_7)
#define INTERRUPT_ID_XRDP_QUEUE_8            _2MAP(INTERRUPT_XRDP_QUEUE_8)
#define INTERRUPT_ID_XRDP_QUEUE_9            _2MAP(INTERRUPT_XRDP_QUEUE_9)
#define INTERRUPT_ID_XRDP_QUEUE_10           _2MAP(INTERRUPT_XRDP_QUEUE_10)
#define INTERRUPT_ID_XRDP_QUEUE_11           _2MAP(INTERRUPT_XRDP_QUEUE_11)
#define INTERRUPT_ID_XRDP_QUEUE_12           _2MAP(INTERRUPT_XRDP_QUEUE_12)
#define INTERRUPT_ID_XRDP_QUEUE_13           _2MAP(INTERRUPT_XRDP_QUEUE_13)
#define INTERRUPT_ID_XRDP_QUEUE_14           _2MAP(INTERRUPT_XRDP_QUEUE_14)
#define INTERRUPT_ID_XRDP_QUEUE_15           _2MAP(INTERRUPT_XRDP_QUEUE_15)
#define INTERRUPT_ID_XRDP_QUEUE_16           _2MAP(INTERRUPT_XRDP_QUEUE_16)
#define INTERRUPT_ID_XRDP_QUEUE_17           _2MAP(INTERRUPT_XRDP_QUEUE_17)
#define INTERRUPT_ID_XRDP_QUEUE_18           _2MAP(INTERRUPT_XRDP_QUEUE_18)
#define INTERRUPT_ID_XRDP_QUEUE_19           _2MAP(INTERRUPT_XRDP_QUEUE_19)
#define INTERRUPT_ID_XRDP_QUEUE_20           _2MAP(INTERRUPT_XRDP_QUEUE_20)
#define INTERRUPT_ID_XRDP_QUEUE_21           _2MAP(INTERRUPT_XRDP_QUEUE_21)
#define INTERRUPT_ID_XRDP_QUEUE_22           _2MAP(INTERRUPT_XRDP_QUEUE_22)
#define INTERRUPT_ID_XRDP_QUEUE_23           _2MAP(INTERRUPT_XRDP_QUEUE_23)
#define INTERRUPT_ID_XRDP_QUEUE_24           _2MAP(INTERRUPT_XRDP_QUEUE_24)
#define INTERRUPT_ID_XRDP_QUEUE_25           _2MAP(INTERRUPT_XRDP_QUEUE_25)
#define INTERRUPT_ID_XRDP_QUEUE_26           _2MAP(INTERRUPT_XRDP_QUEUE_26)
#define INTERRUPT_ID_XRDP_QUEUE_27           _2MAP(INTERRUPT_XRDP_QUEUE_27)
#define INTERRUPT_ID_XRDP_QUEUE_28           _2MAP(INTERRUPT_XRDP_QUEUE_28)
#define INTERRUPT_ID_XRDP_QUEUE_39           _2MAP(INTERRUPT_XRDP_QUEUE_29)
#define INTERRUPT_ID_XRDP_QUEUE_30           _2MAP(INTERRUPT_XRDP_QUEUE_30)
#define INTERRUPT_ID_XRDP_QUEUE_31           _2MAP(INTERRUPT_XRDP_QUEUE_31)
#define INTERRUPT_ID_XRDP_FPM                _2MAP(INTERRUPT_XRDP_FPM)
#define INTERRUPT_PCM_DMA_IRQ                _2MAP(INTERRUPT_PCM_DMA0) 
#define INTERRUPT_ID_WAN_XGTX_INTR0       _2MAP(INTERRUPT_WAN_XGTX_OUT0)
#define INTERRUPT_ID_WAN_XGTX_INTR1       _2MAP(INTERRUPT_WAN_XGTX_OUT1)
#define INTERRUPT_ID_WAN_XGRX             _2MAP(INTERRUPT_WAN_XGRX)

#ifdef __BOARD_DRV_ARMV7__
unsigned int bcm_phys_irqs_to_map[] =
{
    INTERRUPT_DG,
    INTERRUPT_HS_UART,
    INTERRUPT_NAND_FLASH,
    INTERRUPT_PER_EXT_0,
    INTERRUPT_PER_EXT_1,
    INTERRUPT_PER_EXT_2,
    INTERRUPT_PER_EXT_3,
    INTERRUPT_PER_EXT_4,
    INTERRUPT_PER_EXT_5,
    INTERRUPT_PER_EXT_6,
    INTERRUPT_PER_EXT_7,
    INTERRUPT_UBUS2AXI_WLAN_CCM,
    INTERRUPT_UBUS2AXI_WLAN0_D11MAC,
    INTERRUPT_UBUS2AXI_WLAN0_M2MDMA,
    INTERRUPT_USB_OHCI,
    INTERRUPT_USB_EHCI,
    INTERRUPT_USB_XHCI,
    INTERRUPT_WAN_GPON_RX,
    INTERRUPT_WAN_GPON_TX,
    INTERRUPT_WAN_XGTX_OUT0,
    INTERRUPT_WAN_XGTX_OUT1,
    INTERRUPT_WAN_XGRX,
    INTERRUPT_XRDP_QUEUE_0,
    INTERRUPT_XRDP_QUEUE_1,
    INTERRUPT_XRDP_QUEUE_2,
    INTERRUPT_XRDP_QUEUE_3,
    INTERRUPT_XRDP_QUEUE_4,
    INTERRUPT_XRDP_QUEUE_5,
    INTERRUPT_XRDP_QUEUE_6,
    INTERRUPT_XRDP_QUEUE_7,
    INTERRUPT_XRDP_QUEUE_8,
    INTERRUPT_XRDP_QUEUE_9,
    INTERRUPT_XRDP_QUEUE_10,
    INTERRUPT_XRDP_QUEUE_11,
    INTERRUPT_XRDP_QUEUE_12,
    INTERRUPT_XRDP_QUEUE_13,
    INTERRUPT_XRDP_QUEUE_14,
    INTERRUPT_XRDP_QUEUE_15,
    INTERRUPT_XRDP_QUEUE_16,
    INTERRUPT_XRDP_QUEUE_17,
    INTERRUPT_XRDP_QUEUE_18,
    INTERRUPT_XRDP_QUEUE_19,
    INTERRUPT_XRDP_QUEUE_20,
    INTERRUPT_XRDP_QUEUE_21,
    INTERRUPT_XRDP_QUEUE_22,
    INTERRUPT_XRDP_QUEUE_23,
    INTERRUPT_XRDP_QUEUE_24,
    INTERRUPT_XRDP_QUEUE_25,
    INTERRUPT_XRDP_QUEUE_26,
    INTERRUPT_XRDP_QUEUE_27,
    INTERRUPT_XRDP_QUEUE_28,
    INTERRUPT_XRDP_QUEUE_29,
    INTERRUPT_XRDP_QUEUE_30,
    INTERRUPT_XRDP_QUEUE_31,
    INTERRUPT_XRDP_FPM,
    INTERRUPT_PCM_DMA0
};
unsigned int bcm_legacy_irq_map[256];
#else
extern unsigned int bcm_phys_irqs_to_map[];
extern unsigned int bcm_legacy_irq_map[];
#endif
#endif

#define NUM_EXT_INT    (INTERRUPT_PER_EXT_7-INTERRUPT_PER_EXT_0+1)

#ifdef __cplusplus
    }
#endif                    

#endif  /* __BCM6855_H */

