/****************************************************************************
 *
 * <:copyright-BRCM:2015:DUAL/GPL:voice
 * 
 *    Copyright (c) 2015 Broadcom 
 *    All Rights Reserved
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, version 2, as published by
 * the Free Software Foundation (the "GPL").
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * 
 * A copy of the GPL is available at http://www.broadcom.com/licenses/GPLv2.php, or by
 * writing to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 * 
 * :>
 *
 ***************************************************************************/
#ifndef _IUDMA_H
#define _IUDMA_H

#include <dsphal.h>

#include <linux/dma-direction.h>
#include <linux/dma-mapping.h>
#if defined(CONFIG_BCM963158)
#include<apm_regs.h>
#endif
#if (defined(CONFIG_BCM96858) || defined (CONFIG_BCM963158))
#include<pcm_regs.h>
#endif
#include <dsphal_chip.h>

/****************************************************************************
* Typedefs and Constants
****************************************************************************/
#define IUDMA_STATE_MASK           0xc0000000
#define IUDMA_STATE_SHIFT          30
#define IUDMA_BYTESDONE_MASK       0x0fff0000
#define IUDMA_BYTESDONE_SHIFT      16
#define IUDMA_RINGOFFSET_MASK      0x00003fff
#define IUDMA_RINGOFFSET_SHIFT     0

struct iudma_ctrl_regs
{
   uint32_t ctrl_config;
#define IUDMA_REGS_CTRLCONFIG_MASTER_EN        0x0001
#define IUDMA_REGS_CTRLCONFIG_FLOWC_CH1_EN     0x0002
#define IUDMA_REGS_CTRLCONFIG_FLOWC_CH3_EN     0x0004
#define IUDMA_REGS_CTRLCONFIG_FLOWC_CH5_EN     0x0008
#define IUDMA_REGS_CTRLCONFIG_FLOWC_CH7_EN     0x0010

   // Flow control Ch1
   uint32_t ch1_FC_Low_Thr;
   uint32_t ch1_FC_High_Thr;
   uint32_t ch1_Buff_Alloc;

   // Flow control Ch3
   uint32_t ch3_FC_Low_Thr;
   uint32_t ch3_FC_High_Thr;
   uint32_t ch3_Buff_Alloc;

   // Flow control Ch5
   uint32_t ch5_FC_Low_Thr;
   uint32_t ch5_FC_High_Thr;
   uint32_t ch5_Buff_Alloc;

   // Flow control Ch7
   uint32_t ch7_FC_Low_Thr;
   uint32_t ch7_FC_High_Thr;
   uint32_t ch7_Buff_Alloc;

   uint32_t channel_reset;
   uint32_t channel_debug;

   uint32_t reserved;
   uint32_t gbl_int_stat;
   uint32_t gbl_int_mask;
#if IUDMA_NUM_CHANNELS == 6
  #define IUDMA_IRQ_TX_PCM      0x00000020
  #define IUDMA_IRQ_RX_PCM      0x00000010
  #define IUDMA_IRQ_TX_B        0x00000008
  #define IUDMA_IRQ_RX_B        0x00000004
  #define IUDMA_IRQ_TX_A        0x00000002
  #define IUDMA_IRQ_RX_A        0x00000001
#else
  #define IUDMA_IRQ_TX_PCM      0x00000002
  #define IUDMA_IRQ_RX_PCM      0x00000001
#endif
};

struct iudma_chan_ctrl
{
    uint32_t config;
#define IUDMA_CONFIG_ENDMA         0x00000001
#define IUDMA_CONFIG_PKTHALT       0x00000002
#define IUDMA_CONFIG_BURSTHALT     0x00000004

    uint32_t int_status;
#define IUDMA_INTSTAT_BDONE        0x00000001
#define IUDMA_INTSTAT_PDONE        0x00000002
#define IUDMA_INTSTAT_NOTVLD       0x00000004
#define IUDMA_INTSTAT_MASK         0x00000007

    uint32_t int_mask;
#define IUDMA_INTMASK_BDONE        0x00000001
#define IUDMA_INTMASK_PDONE        0x00000002
#define IUDMA_INTMASK_NOTVLD       0x00000004

    uint32_t max_burst;
#define IUDMA_MAXBURST_SIZE        1 /* 32-bit words */
};

struct iudma_state_ram
{
   uint32_t base_desc_pointer;
   uint32_t state_bytes_done_ring_offset;
#define IUDMA_STRAM_DESC_RING_OFFSET  0x3fff
   uint32_t flags_length_status;
   uint32_t current_buffer_pointer;
};

struct iudma_descr
{
   uint32_t flags;
#define IUDMA_FLAGS_LENGTH_MASK    0xffff0000
#define IUDMA_FLAGS_LENGTH_SHIFT   16
#define IUDMA_FLAGS_STATUS_MASK    0x0000ffff
#define IUDMA_FLAGS_STATUS_SHIFT   0

#define IUDMA_STATUS_OWN           0x8000
#define IUDMA_STATUS_EOP           0x4000
#define IUDMA_STATUS_SOP           0x2000
#define IUDMA_STATUS_WRAP          0x1000
#define IUDMA_STATUS_PERIPH        0x0fff

   uint32_t addr;
};

struct iudma
{
   struct iudma_ctrl_regs  regs;
   uint32_t                reserved1[110];
   struct iudma_chan_ctrl  ctrl[IUDMA_NUM_CHANNELS];
   uint32_t                reserved2[104];
#if IUDMA_NUM_CHANNELS == 2
   uint32_t                reserved3[16];
#endif
   struct iudma_state_ram  stram[IUDMA_NUM_CHANNELS];

};
#define IUDMA    ((volatile struct iudma * const) IUDMA_BASE)


/****************************************************************************
* Function Definitions
****************************************************************************/
int iudma_request_chan(unsigned int chan, int count, size_t size,
                       struct dma_addr *bufp);
int iudma_release_chan(unsigned int chan);
int iudma_config_chan(unsigned int chan, int burst_size,
      enum dma_data_direction direction,
      void (*data_cb)(unsigned int chan, char *bufp, size_t size,
                      dma_addr_t bufp_dma),
      int interrupt_ch, int tick);
int iudma_enable_chan(unsigned int chan);
int iudma_get_next_buf(unsigned int chan, char **buf, size_t *size);
void iudma_idle(int idle);
int iudma_start(void);
int iudma_stop(void);
int iudma_configure(void);


#endif /* _IUDMA_H */
