#ifndef MERLIN_HOST_H
#define MERLIN_HOST_H

#define SERDES_CORE_BASE            0x000000
#define SERDES_CORE_OFFSET          0x080000
#define SERDES_INDIR_ACC_CNTRL_BASE 0x080100
#define SERDES_MISC_REG_BASE        0x080000
#define SERDES_REG_OFFSET           0x000000

#define MERLIN_REVID           0x82000
#define MERLIN_CTRL            0x82014
#define MERLIN_STATUS          0x82018
#define MERLIN_APD_CTRL        0x000C
#define MERLIN_INDIR_ACC_CNTRL 0x82100
#define MERLIN_INDIR_ACC_ADDR  0x82004
#define MERLIN_INDIR_ACC_MASK  0x82008

//cross check with vlib/host_sim_model.v
#define MERLIN_SERDES_CTRL_TESTSEL_OFFSET      20
#define MERLIN_SERDES_CTRL_TEST_EN_OFFSET      16
#define MERLIN_SERDES_CTRL_LN_OFFSET_OFFSET    11
#define MERLIN_SERDES_CTRL_PRTAD_OFFSET        6
#define MERLIN_SERDES_CTRL_REFSEL_OFFSET       3
#define MERLIN_SERDES_CTRL_RESET_OFFSET        2
#define MERLIN_SERDES_CTRL_REFCLK_RESET_OFFSET 1
#define MERLIN_SERDES_CTRL_IDDQ_OFFSET         0

#define MERLIN_SERDES_CTRL_TESTSEL_MASK       0x7  //3-bit
#define MERLIN_SERDES_CTRL_TEST_EN_MASK       0x1
#define MERLIN_SERDES_CTRL_LN_OFFSET_MASK     0x1f //5-bit
#define MERLIN_SERDES_CTRL_PRTAD_MASK         0x1f //5-bit
#define MERLIN_SERDES_CTRL_REFSEL_MASK        0x7  //3-bit
#define MERLIN_SERDES_CTRL_RESET_MASK         0x1
#define MERLIN_SERDES_CTRL_REFCLK_RESET_MASK  0x1
#define MERLIN_SERDES_CTRL_IDDQ_MASK          0x1
//

#define MERLIN_SERDES_STATUS_PLL_LOCK_OFFSET          6
#define MERLIN_SERDES_STATUS_LINK_STATUS_OFFSET       4
#define MERLIN_SERDES_STATUS_CDR_LOCK_OFFSET          2
#define MERLIN_SERDES_STATUS_SIGDET_OFFSET            0
#define MERLIN_SERDES_PLL_LOCK_OFFSET          6
#define MERLIN_SERDES_LINK_STATUS_OFFSET       4
#define MERLIN_SERDES_CDR_LOCK_OFFSET          2
#define MERLIN_SERDES_SIGDET_OFFSET            0

#define MERLIN_PMI_BC_ADDR     0x1F
#define MERLIN_PMI_BC_CNTRL    (MERLIN_PMI_BC_ADDR<<8)+0x00

#endif //MERLIN_HOST_H
