# Mount function in the case we have different partitions on the box
mount_ext4() {
    mount_directory=$1
    ext4_vol=$2

    if [ -z "$ext4_vol" ]; then
        # partition not found
        echo "${ext4_vol} not found! Exit without mounting."
        return
    fi

    # Mount partition
    mount -t ext4 -o nosuid,nodev,noexec,noatime ${ext4_vol} ${mount_directory}

    if [ ! $? -eq 0 ] || [ ! -f ${mount_directory}/formatted ]; then
        echo "Formatting ${ext4_vol} to ext4."

	umount ${mount_directory}
        echo y | mkfs.ext4 ${ext4_vol}

        mount -t ext4 -o nosuid,nodev,noexec,noatime ${ext4_vol} ${mount_directory}
        if [ ! $? -eq 0 ]; then
   	    echo "Failed to mount ${ext4_vol} to ${mount_directory} after reformatting."
            return
        fi

        # Mark as formatted
        touch ${mount_directory}/formatted
    fi

}


# Mount function in the case we only one data partition on the box
check_dir_content_ext4_single_partition() {
    local dir=$1

    if [ ! -d $dir ]; then
        echo "Creating directory $dir"
        mkdir -p $dir
        touch $dir/formatted
    fi

    if [ ! -f $dir/formatted ]; then
        echo "Formatting directory $dir"
        rm -rf $dir/*
        touch $dir/formatted
    fi
}

mount_ext4_single_partition() {
    mount_directory=$1

    check_dir_content_ext4_single_partition /data/$mount_directory
 
    # Mount folders
    mount --bind /data/$mount_directory /$mount_directory
    if [ ! $? -eq 0 ]; then
        echo "mount --bind /data/$mount_directory /$mount_directory failed!"
    fi
}

mount_ext4_single_data_partition() {
    # Format the single data partition
    # Make sure $ext4_partition_name contains an ext4 filesystem
    if [ -z "`blkid ${1} | grep 'TYPE="ext4"'`" ]; then
        echo "Formatting ${1} as ext4"
        echo y | mkfs.ext4 ${1}
    fi
    # Mount the single data partition to /data
    mount -t ext4 -o nosuid,nodev,noexec,noatime ${1} /data
    if [ ! $? -eq 0 ]; then
        echo "Corrupted ${1}. Formatting as ext4."
        echo y | mkfs.ext4 ${1}
        mount -t ext4 -o nosuid,nodev,noexec,noatime ${1} /data
        if [ ! $? -eq 0 ]; then
            echo "Failed to mount /data, after reformatting ${1}"
            return
        fi
    fi
}
