#!/bin/sh

############################################################################################################################
# Functions for prpl flashing layout
############################################################################################################################

PRPL_LAYOUT_VAR_PREFIX="PRPL_LAYOUT_"

#Delete previous PRPL_LAYOUT_ variables

function delete_prpl_layout_vars() {
    for var in $(env | grep ^$PRPL_LAYOUT_VAR_PREFIX | cut -d'=' -f1); do
        unset $var;
    done
}

function create_prpl_layout_array() {
    #Declare an array with the PRPL_LAYOUT_ partlabels
    local array=""
    for var in $(env | grep ^$PRPL_LAYOUT_VAR_PREFIX 2> /dev/null); do
        array="$(echo $var | cut -d'=' -f2 2> /dev/null) $array"
    done
    echo "$array"
}

function is_label_prpl_layout() {
    local label="$1"
    local prpl_partlabels=$(create_prpl_layout_array 2> /dev/null)
    [ -z "$prpl_partlabels" ] && return 1
    for partlabel in `echo $prpl_partlabels`; do
        if [[ "$label" == "$partlabel" ]]; then
            return 0
        fi
    done
    return 1
}

