# Read/Write test script V0.2
# V0.1: 2018-03-16 by Leo Chen		Modify for LCS1
# V0.2: 2018-03-29 by Leo Chen		Modify for USB / NAND
# V0.3: 2018-04-02 by Leo Chen		Modify USB parts to show errors if mount fail
# V0.31:2018-07-10 by Leo Chen		Add umount command in script.
# V0.4: 2022-09-21 by Tracy Tsai    Add mount sda sda1 different
# V0.5: 2023-02-23 by Shelly Su     Remove test.img after test, show debug message
# This script will create a file, and keep read/write file
#


LOOP_COUNT=-1
COUNTER=0
TARGET=0


help() {
	echo "Flash_mnt_USB_eMMC.sh <target> <Loop>"
	echo "Target > 2=Flash , 1=USB"
	echo "Loop > How many loops you want to check"
	echo "     > No loop parameter=infinity loop."
	exit
}

if [ $# -lt 1 -o $# -gt 2 ] ; then
	help
fi


if [ $1 -eq 1 ] ; then
	TARGET=1
elif [ $1 -eq 2 ] ; then
	TARGET=2
else
	help
fi

if [ $# -eq 2 ] ; then
	LOOP_COUNT=$2
fi

if [ $TARGET -eq 1 ] ; then
	
	mkdir /mnt/usb_test_1 -p
#detect USB
	if [ "$(ls /sys/block/|grep sda)" == "sda" ] ;
    then
        echo "SDA detect"
        if [ "$(ls /dev/[sh]d*|wc -l)" == "1" ] ;
        then
            mount /dev/sda /mnt/usb_test_1
            echo "sda mount"
        else
            mount /dev/sda1 /mnt/usb_test_1
            echo "sda1 mount"
        fi
    elif [ "$(ls /sys/block/|grep sdb)" == "sdb" ] ;
    then
		echo "SDB detect"
        if [ "$(ls /dev/[sh]d*|wc -l)" == "1" ] ;
        then
            mount /dev/sdb /mnt/usb_test_1
            echo "sdb mount"
        else
            mount /dev/sdb1 /mnt/usb_test_1
            echo "sdb1 mount"
        fi
    elif [ "$(ls /sys/block/|grep sdc)" == "sdc" ] ;
    then
		echo "SDC detect"
        if [ "$(ls /dev/[sh]d*|wc -l)" == "1" ] ;
        then
            mount /dev/sdc /mnt/usb_test_1
            echo "sdc mount"
        else
            mount /dev/sdc1 /mnt/usb_test_1
            echo "sdc1 mount"
        fi
	else
		echo "USB not found."
		exit
	fi

	if [ "$(df | grep /mnt/usb_test_1)" == "" ] ; then
		echo "USB mount fail."
		echo "Please check USB partition and format (FAT/FAT32)."
		exit
	fi

	echo "Read / Write Tests for USB."

#create test file (10M*5=50MB)
	if [ -f "/tmp/testing.img" ] ; then
	rm /tmp/testing.img
	fi
	cd /tmp
	dd if=/dev/zero of=/tmp/testing.img bs=10M count=5
	md5sum testing.img > testing.img.md5

else
	mkdir /mnt/Flash_test
	echo "Read / Write Tests for FLASH."

#create test file (10M*5=50MB)
	rm /tmp/Ftesting.img
	cd /tmp
	dd if=/dev/zero of=/tmp/Ftesting.img bs=10M count=5
	md5sum Ftesting.img > Ftesting.img.md5
fi

while [ $LOOP_COUNT -ne 0 ]
do
	if [ $TARGET -eq 1 ] ; then
# USB Test
		cp /tmp/testing.img /mnt/usb_test_1/
		cp /tmp/testing.img.md5 /mnt/usb_test_1/
		cd /mnt/usb_test_1
		if [ "$(md5sum -c /mnt/usb_test_1/testing.img.md5)" != "testing.img: OK" ] ; then
			echo "check sum error in usb 1"
		fi

		if [ -f "/mnt/usb_test_1/testing.img" ] ; then
			rm /mnt/usb_test_1/testing.img
            echo "Delete testing.img"
		fi

		if [ -f "/mnt/usb_test_1/testing.img.md5" ] ; then
            rm /mnt/usb_test_1/testing.img.md5
            echo "Delete testing.img.md5"	
		fi
	else
#Flash Test
		cp /tmp/Ftesting.img /mnt/Flash_test/
		cp /tmp/Ftesting.img.md5 /mnt/Flash_test/
		cd /mnt/Flash_test
		if [ "$(md5sum -c /mnt/Flash_test/Ftesting.img.md5)" != "Ftesting.img: OK" ] ; then
			echo "check sum error in Flash"
		fi
		rm /mnt/Flash_test/Ftesting.img*
	fi
	
	if [ $LOOP_COUNT -gt 0 ] ; then
		LOOP_COUNT=$(($LOOP_COUNT - 1));
		echo "$(($2-$LOOP_COUNT)) Cycle Test."
	else
		COUNTER=$(($COUNTER + 1))
		echo "$(($COUNTER)) Cycle Test."
	fi
    sleep 5
done
	if [ -f "/tmp/testing.img" ] ; then
		rm /tmp/testing.img*
	fi

	if [ -f "/tmp/Ftesting.img" ] ; then
                rm /tmp/Ftesting.img*
        fi

	if [ $TARGET -eq 1 ] ; then
		cd /
		sync
		umount /mnt/usb_test_1/
        echo "Umount USB done"
	fi

exit
	
