#!/bin/sh

size=$1
loop=$2
node=$3

if [ -z $1 ] || [ -z $2 ] || [ -z $3 ]; then
        echo "usage:$0 <size:1-30M> <loop:1-3000times> <eMMC partition: 30>"
else
#check partition node
if [ $3 != "30" ]; then
        echo "partition:$3 can't be used"
        echo "usage:$0 <size:1-30M> <loop:1-3000times> <eMMC partition: 30>"
else
i=1
j=0
k=0
echo "eMMC test image size:$size"
echo "Loop times:$loop"
echo "Test partition:echo $node"

#Remove urandom binary
if [ -e "/tmp/random.bin" ]; then
    rm -rf /tmp/random.bin
    echo "Remove urandom binary done"
fi

#generate urandom binary
echo "generate random pattern image:$size"
dd if=/dev/urandom of=/tmp/random.bin bs=$size count=1

md1=`md5sum /tmp/random.bin|awk -F " " '{print $1}'`
echo "random file md5sum:$md1"

t1=`date +%s`
#echo $t1
while [ $i -le $loop ]
do
        echo "loop:$i test start!!!"
        echo "===========erase==========="
        t_start=`date +%s`
        #erase partition $node
        dd if=/dev/zero of=/dev/mmcblk0p$node
        sync
        t_erase=`date +%s`
        echo "erase time:$(($t_erase - $t_start))"

        echo "===========write==========="
        #write partition $node
        dd if=/tmp/random.bin of=/dev/mmcblk0p$node bs=$size count=1
        sync
        t_write=`date +%s`
        echo "write time:$(($t_write - $t_erase))"

        echo "===========dump ==========="
        #dump partition
        dd if=/dev/mmcblk0p$node of=/tmp/verify.bin bs=$size count=1
        sync
        t_dump=`date +%s`
        echo "dump time:$(($t_dump - $t_write))"

        echo "======compare  md5sum======"
        #md5sum compare
        md2=`md5sum /tmp/verify.bin|awk -F " " '{print $1}'`
        echo "verify file md5sum:$md2"
        if [ $md1 != $md2 ]; then
                echo "loop:$i" >> /NG
                date >> /NG
                k=$(($k+1))
                echo "erase/write/read partition error" >> /NG
                echo "loop no.$i test NG"
                dmesg |grep "I/O error"
                echo "SHOW I/O ERROR LOG"
        else
                echo "loop no.$i" >> /PASS
                date >> /PASS
                j=$(($j+1))
                echo "erase/write/read partition success" >> /PASS
                echo "loop no.$i test PASS"
        fi
        t_md5sum=`date +%s`
        echo "loop:$i test time:$(($t_md5sum - $t_start))"
        rm -rf /tmp/verify.bin
        if [ -e "/tmp/verify.bin" ]; then
                echo "verify.bin exist"
        else
                echo "remove /tmp/verify.bin"
        fi
        i=$(($i+1))
        echo "PASS time=$j"
        echo "NG time=$k"
done
fi
fi
