#!/bin/sh
# LPS22DF barometer
# Define the I2C bus and device address
I2C_BUS=0
SENSOR_ADDRESS=0x5D  # Replace with the actual address of your sensor
if [ -f "/mnt/data/baro_offset" ];
then
  offset=$(cat /mnt/data/baro_offset)
else
  if [ -n "$(fw_printenv | grep baro_offset)" ];
  then
    offset=$(fw_printenv | grep baro_offset | cut -d '=' -f2)
  else
    offset=$(($1))
  fi
fi
# Function to read pressure data from the sensor
read_LPS22() {
    # Read pressure data from the sensor
    # Oneshot measurement
        i2ctransfer -y 0 w2@$SENSOR_ADDRESS 0x11 0x01
        # Get result
        temp_data_l=$(i2cget -y $I2C_BUS $SENSOR_ADDRESS 0x2b)
        temp_data_h=$(i2cget -y $I2C_BUS $SENSOR_ADDRESS 0x2c)
        #echo "$temp_data_h $temp_data_l"

        pressure_data_xl=$(i2cget -y $I2C_BUS $SENSOR_ADDRESS 0x28)
        pressure_data_l=$(i2cget -y $I2C_BUS $SENSOR_ADDRESS 0x29)
        pressure_data_h=$(i2cget -y $I2C_BUS $SENSOR_ADDRESS 0x2a)
        #echo "$pressure_data_h $pressure_data_l $pressure_data_xl"

    # Convert the raw data to a meaningful value
        temp_data=$((($temp_data_h << 8) + ($temp_data_l)))
        temp_value=$(awk "BEGIN { printf(\"%.2f\", $temp_data / 100) }")

        pressure_data=$(((($pressure_data_h << 16) + ($pressure_data_l << 8) + ($pressure_data_xl))))
        pressure_value=$(awk "BEGIN { printf(\"%.3f\",($pressure_data / 4096)+($offset/100)) }")

        echo "Temperature: $temp_value C"
        echo "Pressure:    $pressure_value hPa"
}

read_BMP5()
{
  RAW=$(bmp5_read_forced | grep 'AVG,')
  #echo $RAW
  pressure_pa=$(echo $RAW | cut -d ", " -f 2)
  pressure_value=$(awk "BEGIN { printf(\"%.3f\", ($pressure_pa / 100)+($offset/100)) }")
  temp_raw=$(echo $RAW | cut -d ", " -f 3)
  temp_value=$(awk "BEGIN { printf(\"%.2f\", $temp_raw) }")

  echo "Temperature: $temp_value C"
  echo "Pressure:    $pressure_value hPa"
}

# Main script
echo "Reading pressure sensor..."
# Check barometer
if [ "$(i2cget -y 0 0x5d 0x0f 2>/tmp/err)" = "0xb4" ]
then
  echo "LPS22DF"
  read_LPS22
fi

if [ "$(i2cget -y 0 0x47 0x01 2>/tmp/err)" = "0x50" ]
then
  echo "BMP581"
  read_BMP5
fi

#if [ "$(i2cget -y 0 0x77 0x0d 2>/tmp/err)" = "0x11" ]
#then
#  echo "ZTS8032"
#fi

