#!/bin/sh

METHOD=$1

show_help() {
    echo "Usage: $0 <option>"
    echo
    echo "Options:"
    echo "  qdisc-noqueue-eth           Enable PPE and set noqueue qdisc on ethernet interfaces"
    echo "  ethtool-disable-gro-gso     Disable GRO and GSO on ethernet interfaces"
    echo "  fdb-flush                   Disable FDB flush and flush FDB entries"
    echo "  cpu-tune                    Set CPU frequency scaling governor to performance"
    echo "  qdisc-noqueue-wlan          Set noqueue qdisc on wlan interfaces"
    echo "  disable-wlan-stats          Disable WLAN stats and QDSS tracing"
    echo "  disable-wlan-latency-stats  Disable WLAN latency stats"
    echo "  disable-wlan-trace-qdss     Disable WLAN trace QDSS"
    echo "  inc-buf                     Increase skb recycler buffer size"
    echo "  set-ageing                  Set bridge ageing time"
    echo "  full                        Enable full performance boost"
    echo "  help                        Show this help message"
}

case $METHOD in
    qdisc-noqueue-eth)
        echo "enabing ppe" > /dev/console
        tc qdisc replace dev eth0 root noqueue
        tc qdisc replace dev eth1 root noqueue
        tc qdisc replace dev eth2 root noqueue
        ;;
    ethtool-disable-gro-gso)
        echo "disabling gro gso" > /dev/console
        ethtool -K eth0 gro off
        ethtool -K eth0 gso off
        ethtool -K eth1 gro off
        ethtool -K eth1 gso off
        ethtool -K eth2 gro off
        ethtool -K eth2 gso off
        ;;
    fdb-flush)
        echo "disable fdb-flush" > /dev/console
        ssdk_sh fdb learnCtrl set disable
        ssdk_sh fdb entry flush 1
        sysctl -w net.bridge.bridge-nf-call-ip6tables=1
        sysctl -w net.bridge.bridge-nf-call-iptables=1
        echo 1 > /sys/kernel/debug/ecm/ecm_db/defunct_all
        ;;
    cpu-tune)
        echo "enabing cpu" > /dev/console
        echo "performance" > /sys/devices/system/cpu/cpu0/cpufreq/scaling_governor
        echo "performance" > /sys/devices/system/cpu/cpu1/cpufreq/scaling_governor
        echo "performance" > /sys/devices/system/cpu/cpu2/cpufreq/scaling_governor
        echo "performance" > /sys/devices/system/cpu/cpu3/cpufreq/scaling_governor
        ;;
    qdisc-noqueue-wlan)
        #Disable QDISC ON wlan interface as well in addition to ethernet interfaces
        echo "enabing ppe-wlan" > /dev/console
        tc qdisc replace dev wlan0 root noqueue
        tc qdisc replace dev wlan1 root noqueue
        tc qdisc replace dev wlan2 root noqueue
        ;;
    disable-wlan-stats)
        echo "disabling wlan stats" > /dev/console
        #Disables stats and QDSS tracing for reducing CPU load leaving more room for actual data traffic
        for dir in /sys/kernel/debug/ath11k/* /sys/kernel/debug/ath12k/*; do
            if [ -f "$dir/stats_disable" ]; then
                echo 0 > "$dir/stats_disable"
                echo 1 > "$dir/stats_disable"
            fi
        done
        ;;
    disable-wlan-latency-stats)
        echo "Disabling latency stats" > /dev/console
        #Disables stats and QDSS tracing for reducing CPU load leaving more room for actual data traffic
        for dir in /sys/kernel/debug/ath11k/* /sys/kernel/debug/ath12k/*; do
            if [ -f "$dir/ce_latency_stats" ]; then
                echo 0 > "$dir/ce_latency_stats"
            fi
        done
        ;;
    disable-wlan-trace-qdss)
        echo "Disabling trace qdss" > /dev/console
        #Disables stats and QDSS tracing for reducing CPU load leaving more room for actual data traffic
        for dir in /sys/kernel/debug/ath11k/* /sys/kernel/debug/ath12k/*; do
            if [ -f "$dir/trace_qdss" ]; then
                echo 0 > "$dir/trace_qdss"
            fi
        done
        ;;
    inc-buf)
        echo "increasing recycler" > /dev/console
        echo "16384" > /proc/net/skb_recycler/max_skbs
        ;;
    set-ageing)
        echo "setting ageing" > /dev/console
        brctl setageing br-lan 3000
        ;;
    full)
        echo "enabing full" > /dev/console
        ./lib/boost_performance.sh
        ;;
    help|*)
        show_help
        exit 1
        ;;
esac
