#!/bin/sh

WIFI_2G_CAL=/lib/firmware/qcn9224/caldata_2.bin
WIFI_5G_CAL=/lib/firmware/qcn9224/caldata_4.bin
WIFI_6G_CAL=/lib/firmware/qcn9224/caldata_3.bin
TMP_WIFI_2G_CAL=/tmp/tmp_caldata_2g.bin
TMP_WIFI_5G_CAL=/tmp/tmp_caldata_5g.bin
TMP_WIFI_6G_CAL=/tmp/tmp_caldata_6g.bin
EMPTY_MD5=638817caaab58d879a2711ef122aee89
WKK_FILESIZE=184320
ART_BLOCK=/dev/mmcblk0p21

caldata_md5()
{
	path=$1
	md5=$EMPTY_MD5

	if [ -f $path ]; then
		md5=`md5sum $path | cut -d " " -f1`
	fi

	echo $md5
}

create_tmp_caldata()
{
	dd if=$ART_BLOCK of=$TMP_WIFI_2G_CAL bs=1 count=$WKK_FILESIZE skip=362496
	dd if=$ART_BLOCK of=$TMP_WIFI_5G_CAL bs=1 count=$WKK_FILESIZE skip=772096
	dd if=$ART_BLOCK of=$TMP_WIFI_6G_CAL bs=1 count=$WKK_FILESIZE skip=567296
}

check_caldata_match()
{
	create_tmp_caldata 2>/dev/null
	md5sum_tmp_2g=`caldata_md5 $TMP_WIFI_2G_CAL`
	md5sum_tmp_5g=`caldata_md5 $TMP_WIFI_5G_CAL`
	md5sum_tmp_6g=`caldata_md5 $TMP_WIFI_6G_CAL`
	md5sum_2g=`caldata_md5 $WIFI_2G_CAL`
	md5sum_5g=`caldata_md5 $WIFI_5G_CAL`
	md5sum_6g=`caldata_md5 $WIFI_6G_CAL`

	if [ "$md5sum_tmp_2g" != "$md5sum_2g" ]; then
		echo "2G ART not match caldata"
	else
		if [ "$md5sum_2g" == "$EMPTY_MD5" ]; then
			echo "WiFi_2G_MD5: empty"
		else
			echo "WiFi_2G_MD5: $md5sum_2g"
		fi
	fi
	if [ "$md5sum_tmp_5g" != "$md5sum_5g" ]; then
		echo "5G ART not match caldata"
	else
		if [ "$md5sum_5g" == "$EMPTY_MD5" ]; then
			echo "WiFi_5G_MD5: empty"
		else
			echo "WiFi_5G_MD5: $md5sum_5g"
		fi
	fi
	if [ "$md5sum_tmp_6g" != "$md5sum_6g" ]; then
		echo "6G ART not match caldata"
	else
		if [ "$md5sum_6g" == "$EMPTY_MD5" ]; then
			echo "WiFi_6G_MD5: empty"
		else
			echo "WiFi_6G_MD5: $md5sum_6g"
		fi
	fi
}

get_caldata_mac()
{
	caldata=$1
	mac0=`hexdump -s 0x10 -n 1 $caldata | head -n1 | sed 's/.* 00//g' | sed 's/ //g'`
	mac1=`hexdump -s 0x11 -n 1 $caldata | head -n1 | sed 's/.* 00//g' | sed 's/ //g'`
	mac2=`hexdump -s 0x12 -n 1 $caldata | head -n1 | sed 's/.* 00//g' | sed 's/ //g'`
	mac3=`hexdump -s 0x13 -n 1 $caldata | head -n1 | sed 's/.* 00//g' | sed 's/ //g'`
	mac4=`hexdump -s 0x14 -n 1 $caldata | head -n1 | sed 's/.* 00//g' | sed 's/ //g'`
	mac5=`hexdump -s 0x15 -n 1 $caldata | head -n1 | sed 's/.* 00//g' | sed 's/ //g'`
	echo ${mac0}:${mac1}:${mac2}:${mac3}:${mac4}:${mac5}
}

check_caldata_mac()
{
	mlo=`cat /sys/module/ath12k/parameters/mlo_capable`

	if [ $mlo -eq 0 ]; then
		wifi_2g_caldata_mac=`get_caldata_mac $TMP_WIFI_2G_CAL`
		wifi_5g_caldata_mac=`get_caldata_mac $TMP_WIFI_5G_CAL`
		wifi_6g_caldata_mac=`get_caldata_mac $TMP_WIFI_6G_CAL`
		wifi_2g_phy_mac=`cat /sys/class/ieee80211/phy0/macaddress`
		wifi_5g_phy_mac=`cat /sys/class/ieee80211/phy2/macaddress`
		wifi_6g_phy_mac=`cat /sys/class/ieee80211/phy1/macaddress`
		if [ "$wifi_2g_caldata_mac" != "$wifi_2g_phy_mac" ]; then
			echo "WiFi_2G_MAC not match"
		else
			echo "WiFi_2G_MAC: ${wifi_2g_caldata_mac}"
		fi
		if [ "$wifi_5g_caldata_mac" != "$wifi_5g_phy_mac" ]; then
			echo "WiFi_5G_MAC not match"
		else
			echo "WiFi_5G_MAC: ${wifi_5g_caldata_mac}"
		fi
		if [ "$wifi_6g_caldata_mac" != "$wifi_6g_phy_mac" ]; then
			echo "WiFi_6G_MAC not match"
		else
			echo "WiFi_6G_MAC: ${wifi_6g_caldata_mac}"
		fi
	elif [ $mlo -eq 1 ]; then
		wifi_2g_caldata_mac=`get_caldata_mac $TMP_WIFI_2G_CAL`
		wifi_5g_caldata_mac=`get_caldata_mac $TMP_WIFI_5G_CAL`
		wifi_6g_caldata_mac=`get_caldata_mac $TMP_WIFI_6G_CAL`
		wifi_2g_phy_mac=`cat /sys/class/ieee80211/phy0/macaddress`
		if [ "$wifi_2g_caldata_mac" != "$wifi_2g_phy_mac" ]; then
			echo "WiFi 2G MAC not match"
		else
			echo "WiFi 2G MAC: ${wifi_2g_caldata_mac}"
			echo "WiFi 5G MAC: ${wifi_5g_caldata_mac}"
			echo "WiFi 6G MAC: ${wifi_6g_caldata_mac}"
		fi
	fi
}

check_caldata_match
check_caldata_mac
