#!/bin/sh

size=$1
loop=$2
node=$3
logName="/eMMC_stress.log"

echoLog()
{
	local string

	string=$1
	echo $string >> $logName
	echo $string
}

if [ -z $1 ] || [ -z $2 ] || [ -z $3 ]; then
	echo "usage:$0 <size:1-30M> <loop:1-3000times> <eMMC partition number>"
	return 1
fi

rm $logName

i=1
passCount=0
failCount=0
echoLog "eMMC test image size: $size"
echoLog "Loop times: $loop"
echoLog "Test partition: $node"

#generate urandom binary
echoLog "generate random pattern image:$size"
dd if=/dev/urandom of=/tmp/mmc_random.bin bs=$size count=1

md1=`md5sum /tmp/mmc_random.bin|awk -F " " '{print $1}'`
echoLog "random file md5sum:$md1"

t1=`date +%s`
#echo $t1
while [ $i -le $loop ]
do
	echoLog "loop:$i test start!!!"
	echoLog "=========== erase ==========="
	t_start=`date +%s`
	#erase partition $node
	dd if=/dev/zero of=/dev/mmcblk0p$node bs=$size count=1
	t_erase=`date +%s`
	echoLog "erase time:$(($t_erase - $t_start))"

	echoLog "=========== write ==========="
	#write partition $node
	dd if=/tmp/mmc_random.bin of=/dev/mmcblk0p$node bs=$size count=1
	t_write=`date +%s`
	echoLog "write time:$(($t_write - $t_erase))"

	echoLog "=========== dump ==========="
	#dump partition
	dd if=/dev/mmcblk0p$node of=/tmp/mmc_verify.bin bs=$size count=1
	t_dump=`date +%s`
	echoLog "dump time:$(($t_dump - $t_write))"

	echoLog "=========== verify ==========="
	#md5sum compare
	md2=`md5sum /tmp/mmc_verify.bin|awk -F " " '{print $1}'`
	if [ $md1 != $md2 ]; then
		echoLog "test FAIL"
		failCount=$(($failCount+1))
	else
		echoLog "test PASS"
		passCount=$(($passCount+1))
	fi
	t_md5sum=`date +%s`
	echoLog "=========== summarize ==========="
	echoLog "test time:$(($t_md5sum - $t_start))"
	echoLog "PASS: $passCount"
	echoLog "FAIL: $failCount"
	rm -rf /tmp/mmc_verify.bin
	if [ -e "/tmp/mmc_verify.bin" ]; then
		echoLog "/tmp/mmc_verify.bin still exist..."
	fi
	i=$(($i+1))
	echoLog ""
done

