#!/bin/sh

CPU_TRIGGER=93
WIFI_2G_TRIGGER=98
WIFI_5G_TRIGGER=98
WIFI_6G_TRIGGER=98
NGPON2_TRIGGER=72
MoCA_TRIGGER=94

CPU_CLEAR_TRIGGER=88
WIFI_2G_CLEAR_TRIGGER=93
WIFI_5G_CLEAR_TRIGGER=93
WIFI_6G_CLEAR_TRIGGER=93
NGPON2_CLEAR_TRIGGER=67
MoCA_CLEAR_TRIGGER=91

INTERVAL=5
LAST_TRIGGER=0
LAST_CLEAR_TRIGGER=0
SHOW_LOG_TIME=0

VOLTAGE_STATUS="high"

# for testing
get_target_temp() {
    CPU_TRIGGER=$(cat /tmp/cpu_temp)
    WIFI_2G_TRIGGER=$(cat /tmp/wifi_2g_temp)
    WIFI_5G_TRIGGER=$(cat /tmp/wifi_5g_temp)
    WIFI_6G_TRIGGER=$(cat /tmp/wifi_6g_temp)
    NGPON2_TRIGGER=$(cat /tmp/ngpon2_temp)
    MoCA_TRIGGER=$(cat /tmp/moca_temp)
}

get_cpu_temp() {
    TEMP0=$(cat /sys/devices/virtual/thermal/thermal_zone0/temp)
    TEMP1=$(cat /sys/devices/virtual/thermal/thermal_zone1/temp)
    TEMP2=$(cat /sys/devices/virtual/thermal/thermal_zone2/temp)
    TEMP3=$(cat /sys/devices/virtual/thermal/thermal_zone3/temp)
    TEMP4=$(cat /sys/devices/virtual/thermal/thermal_zone4/temp)
    AVERAGE=$(awk "BEGIN {printf \"%d\", ($TEMP0 + $TEMP1 + $TEMP2 + $TEMP3 + $TEMP4) / 5 / 1000}")
    echo "$AVERAGE"
}

check_wifi_interface() {
    local band=$1
    local uci_key="wireless.radio0_band${band}.disabled"
    uci get $uci_key > /dev/null 2>&1
    if [ $? -eq 0 ]; then
        status=$(uci get $uci_key)
        if [ "$status" -eq 0 ]; then
            echo "1"
        else
            echo "0"
        fi
    else
        echo "-1"
    fi
}

get_2G_temp() {
    FILES="/sys/class/ieee80211/phy00/hwmon14/temp1_input"
    cat $FILES > /dev/null 2>&1
    if [ $? -eq 1 ]; then
        echo "0"
    else
        TEMP0=$(cat $FILES)
        AVERAGE=$(awk "BEGIN {printf \"%d\", ($TEMP0) / 1000}")
        echo "$AVERAGE"
    fi
}

get_5G_temp() {
    FILES="/sys/class/ieee80211/phy00/hwmon16/temp1_input"
    cat $FILES > /dev/null 2>&1
    if [ $? -eq 1 ]; then
        echo "0"
    else
        TEMP0=$(cat /sys/class/ieee80211/phy00/hwmon16/temp1_input)
        AVERAGE=$(awk "BEGIN {printf \"%d\", ($TEMP0) / 1000}")
        echo "$AVERAGE"
    fi
}

get_6G_temp() {
    FILES="/sys/class/ieee80211/phy00/hwmon15/temp1_input"
    cat $FILES > /dev/null 2>&1
    if [ $? -eq 1 ]; then
        echo "0"
    else
        TEMP0=$(cat /sys/class/ieee80211/phy00/hwmon15/temp1_input)
        AVERAGE=$(awk "BEGIN {printf \"%d\", ($TEMP0) / 1000}")
        echo "$AVERAGE"
    fi
}

get_ngpon2_temp() {
    local TEMP0_DEC=0
    local TEMP1_DEC=0

    TEMP0_HEX=$(i2cget -y -f 0 0x51 0x60 2>/dev/null)
    if [ $? -ne 0 ]; then
        TEMP0_HEX=0
    else
        TEMP0_DEC=$(printf "%d" $TEMP0_HEX)
    fi

    TEMP1_HEX=$(i2cget -y -f 0 0x51 0x61 2>/dev/null)
    if [ $? -ne 0 ]; then
        TEMP0_DEC=0
    else
        TEMP1_DEC=$(printf "%d" $TEMP1_HEX)
    fi

    COMBINED_TEMP=$((((TEMP0_DEC << 8) | TEMP1_DEC )/256))
    echo "$COMBINED_TEMP"
}

get_moca_temp() {
    TEMP0=$(moca_temp.sh | awk '{print int($4)}' 2>/dev/null)
    if [ $? -ne 0 ]; then
        TEMP0=0
    fi

    echo "$TEMP0"
}

dc_detect_status() {
    STATUS=$(cat /sys/kernel/debug/gpio | grep gpio63 | awk -F' ' '{print $4}')
    echo "$STATUS"
}

FAN_CONTROL_ENABLE() {
    wnc-fan-ctrl -e 1
    wnc-fan-ctrl -a 0
}

FAN_CONTROL_SPEED() {
    wnc-fan-ctrl -S $1
}

GET_FAN_RPM() {
    # current_rpm=$(cat /proc/wnc_read_rpm)
    current_rpm=$(cat /sys/class/pwm/pwmchip0/pwm2/duty_cycle)
    if [ "$current_rpm" -eq 0 ]; then
        current_rpm=0
        # ret=$((current_rpm % 400))
        # current_rpm=$((current_rpm - ret))
        # if [ "$ret" -gt 200 ]; then
        #     current_rpm=$((current_rpm + 400))
        # fi
    else
        current_rpm=2800
    fi
    echo "$current_rpm"
}

FAN_CONTROL_ENABLE

FAN_CONTROL_SPEED 0

while [ TRUE ];
do
    # for testing
    # get_target_temp

    VOLTAGE_STATUS=$(dc_detect_status)
    CPU_TEMP=$(get_cpu_temp)
    WIFI_2G_TEMP=0
    WIFI_5G_TEMP=0
    WIFI_6G_TEMP=0
    NGPON2_TEMP=$(get_ngpon2_temp)
    MoCA_TEMP=$(get_moca_temp)
    TRIGGER=0
    CLEAR_TRIGGER=0
    CLEAR_TARGET_TIME=1

    Interface_MoCA_status=$(cat /proc/moca_sfp_present)
    Interface_NGPON2_status=$(cat /proc/ngpon2_sfp_present)

    if [ $CPU_TEMP -gt $CPU_TRIGGER ]; then
        echo "CPU Temp is too high, value: $CPU_TEMP, over target temp: $CPU_TRIGGER"
        TRIGGER=1
    else
        if [ $CPU_TEMP -lt $CPU_CLEAR_TRIGGER ]; then
            echo "CPU Temp is clear, value: $CPU_TEMP, under target temp: $CPU_CLEAR_TRIGGER"
            CLEAR_TRIGGER=$(($CLEAR_TRIGGER + 1))
        fi
    fi


    WIFI_2G_TEMP=$(get_2G_temp)
    if [ $WIFI_2G_TEMP -ne 0 ]; then
        CLEAR_TARGET_TIME=$(($CLEAR_TARGET_TIME + 1))
        if [ $WIFI_2G_TEMP -gt $WIFI_2G_TRIGGER ]; then
            echo "WIFI 2G Temp is too high, value: $WIFI_2G_TEMP, over target temp: $WIFI_2G_TRIGGER"
            TRIGGER=1
        else
            if [ $WIFI_2G_TEMP -lt $WIFI_2G_CLEAR_TRIGGER ]; then
                echo "WIFI 2G Temp is clear, value: $WIFI_2G_TEMP, under target temp: $WIFI_2G_CLEAR_TRIGGER"
                CLEAR_TRIGGER=$(($CLEAR_TRIGGER + 1))
            fi
        fi
    fi


    WIFI_5G_TEMP=$(get_5G_temp)
    if [ $WIFI_5G_TEMP -ne 0 ]; then
        CLEAR_TARGET_TIME=$(($CLEAR_TARGET_TIME + 1))
        if [ $WIFI_5G_TEMP -gt $WIFI_5G_TRIGGER ]; then
            echo "WIFI 5G Temp is too high, value: $WIFI_5G_TEMP, over target temp: $WIFI_5G_TRIGGER"
            TRIGGER=1
        else
            if [ $WIFI_5G_TEMP -lt $WIFI_5G_CLEAR_TRIGGER ]; then
                echo "WIFI 5G Temp is clear, value: $WIFI_5G_TEMP, under target temp: $WIFI_5G_CLEAR_TRIGGER"
                CLEAR_TRIGGER=$(($CLEAR_TRIGGER + 1))
            fi
        fi
    fi


    WIFI_6G_TEMP=$(get_6G_temp)
    if [ $WIFI_6G_TEMP -ne 0 ]; then
        CLEAR_TARGET_TIME=$(($CLEAR_TARGET_TIME + 1))
        if [ $WIFI_6G_TEMP -gt $WIFI_6G_TRIGGER ]; then
            echo "WIFI 6G Temp is too high, value: $WIFI_6G_TEMP, over target temp: $WIFI_6G_TRIGGER"
            TRIGGER=1
        else
            if [ $WIFI_6G_TEMP -lt $WIFI_6G_CLEAR_TRIGGER ]; then
                echo "WIFI 6G Temp is clear, value: $WIFI_6G_TEMP, under target temp: $WIFI_6G_CLEAR_TRIGGER"
                CLEAR_TRIGGER=$(($CLEAR_TRIGGER + 1))
            fi
        fi
    fi

    if [ $Interface_NGPON2_status -eq 1 ]; then
        CLEAR_TARGET_TIME=$(($CLEAR_TARGET_TIME + 1))
        if [ $NGPON2_TEMP -gt $NGPON2_TRIGGER ]; then
            echo "NGPON2 Temp is too high, value: $NGPON2_TEMP, over target temp: $NGPON2_TRIGGER"
            TRIGGER=1
        else
            if [ $NGPON2_TEMP -lt $NGPON2_CLEAR_TRIGGER ]; then
                echo "NGPON2 Temp is clear, value: $NGPON2_TEMP, under target temp: $NGPON2_CLEAR_TRIGGER"
                CLEAR_TRIGGER=$(($CLEAR_TRIGGER + 1))
            fi
        fi
    fi

    if [ $Interface_MoCA_status -eq 1 ]; then
        CLEAR_TARGET_TIME=$(($CLEAR_TARGET_TIME + 1))
        if [ $MoCA_TEMP -gt $MoCA_TRIGGER ]; then
            echo "MoCA Temp is too high, value: $MoCA_TEMP, over target temp: $MoCA_TRIGGER"
            TRIGGER=1
        else
            if [ $MoCA_TEMP -lt $MoCA_CLEAR_TRIGGER ]; then
                echo "MoCA Temp is clear, value: $MoCA_TEMP, under target temp: $MoCA_CLEAR_TRIGGER"
                CLEAR_TRIGGER=$(($CLEAR_TRIGGER + 1))
            fi
        fi
    fi

    FAN_RPM_VALUE=$(GET_FAN_RPM)
    if [ $SHOW_LOG_TIME -eq 300 ]; then
        SHOW_LOG_TIME=0
        logger -p notice -t thermal_monitor "============= Start ============="
        logger -p notice -t thermal_monitor "FAN RPM       : $FAN_RPM_VALUE"
        logger -p notice -t thermal_monitor "Voltage       : $VOLTAGE_STATUS"
        logger -p notice -t thermal_monitor "CPU Temp      : $CPU_TEMP"
        logger -p notice -t thermal_monitor "WiFi 2G Temp  : $WIFI_2G_TEMP"
        logger -p notice -t thermal_monitor "WiFi 5G Temp  : $WIFI_5G_TEMP"
        logger -p notice -t thermal_monitor "WiFi 6G Temp  : $WIFI_6G_TEMP"
        logger -p notice -t thermal_monitor "NGPON2 Temp   : $NGPON2_TEMP"
        logger -p notice -t thermal_monitor "MoCA Temp     : $MoCA_TEMP"
        logger -p notice -t thermal_monitor "Target Time   : $CLEAR_TARGET_TIME"
        logger -p notice -t thermal_monitor "============= End ============="
    fi

    if [ $TRIGGER -eq 1 ] && [ $LAST_TRIGGER -ne $TRIGGER ]; then
        if [ "$VOLTAGE_STATUS" == "high" ]; then
            echo "12V detected"
            echo "set FAN speed to 2800"
            FAN_CONTROL_SPEED 2800
        else
            echo "9V detected"
            echo "set FAN speed 2800"
            FAN_CONTROL_SPEED 2800
        fi
        LAST_TRIGGER=$TRIGGER
        LAST_CLEAR_TRIGGER=0
    elif [ $CLEAR_TRIGGER -eq $CLEAR_TARGET_TIME ] && [ $LAST_CLEAR_TRIGGER -ne 1 ]; then
        echo "set FAN speed to 0"
        FAN_CONTROL_SPEED 0
        LAST_CLEAR_TRIGGER=1
        LAST_TRIGGER=0
    fi

    sleep $INTERVAL
    SHOW_LOG_TIME=$(($SHOW_LOG_TIME + $INTERVAL))
done
