#!/bin/sh

VERSION="8.0.0"
DIR="/tmp/dump_logs"
LAN_LOG="${DIR}/aqr_lan.log"
WAN_LOG="${DIR}/aqr_wan.log"
SWITCH_LOG="${DIR}/switch.log"
SYS_LOG="${DIR}/system.log"
WIFI_LOG="${DIR}/wifi.log"
GPIO_LOG="${DIR}/gpio.log"

clean() {
    rm -rf "${DIR}"
}

dump_eth() {

    local file
    local phy
    local interface

    if [ "${1}" == "lan" ]; then
        phy=0x0
        file="${LAN_LOG}"
        interface=""
    elif [ "${1}" == "wan" ]; then
        phy=0x8
        file="${WAN_LOG}"
        interface="eth2"
    fi

    ##AQR
    echo "====[Script Version:v8]====" >>$file
    date >>$file
    #Common
    echo "AQR Common" >>$file

    echo "PMA Standard Control(1.0):" >>$file
    ssdk_sh debug phy get "${phy}" 0x40010000 | awk -F':' '{print $2}' >>$file

    echo "PMA Standard Status(1.1):" >>$file
    ssdk_sh debug phy get "${phy}" 0x40010001 | awk -F':' '{print $2}' >>$file

    echo "PMA 10G Rx Signal Power Channel A (1.8D):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001008D | awk -F':' '{print $2}' >>$file

    echo "PMA 10G Rx Signal Power Channel B (1.8E):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001008E | awk -F':' '{print $2}' >>$file

    echo "PMA 10G Rx Signal Power Channel C (1.8F):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001008F | awk -F':' '{print $2}' >>$file

    echo "PMA 10G Rx Signal Power Channel D (1.90):" >>$file
    ssdk_sh debug phy get "${phy}" 0x40010090 | awk -F':' '{print $2}' >>$file

    echo "PMA Receive Vendor State(1.E800):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001E800 | awk -F':' '{print $2}' >>$file

    echo "PCS Standard Control(3.0):" >>$file
    ssdk_sh debug phy get "${phy}" 0x40030000 | awk -F':' '{print $2}' >>$file

    echo "PCS Standard status(3.1):" >>$file
    ssdk_sh debug phy get "${phy}" 0x40030001 | awk -F':' '{print $2}' >>$file

    echo "PHY XS Standard Control(4.0):" >>$file
    ssdk_sh debug phy get "${phy}" 0x40040000 | awk -F':' '{print $2}' >>$file

    echo "PHY XS Standard status(4.1):" >>$file
    ssdk_sh debug phy get "${phy}" 0x40040001 | awk -F':' '{print $2}' >>$file

    echo "PHY XS System Interface Connection Status(4.E812):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4004E812 | awk -F':' '{print $2}' >>$file

    echo "PHY XS Receive Vendor Alarm2(4.EC01):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4004EC01 | awk -F':' '{print $2}' >>$file

    echo "Global Thermal Status(1E.C820):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401EC820 | awk -F':' '{print $2}' >>$file

    echo "Global Fault Message(1E.C850):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401EC850 | awk -F':' '{print $2}' >>$file

    echo "Global Firmware ID(1E.20):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401E0020 | awk -F':' '{print $2}' >>$file

    echo "Uptime/NVR/Build ID(1E.C885):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401EC885 | awk -F':' '{print $2}' >>$file

    echo "Uptime(1E.C886):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401EC886 | awk -F':' '{print $2}' >>$file

    echo "Global Alarms 3(1E.CC02):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401ECC02 | awk -F':' '{print $2}' >>$file

    echo "Marvell identify register 1(1.C41D):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001C41D | awk -F':' '{print $2}' >>$file

    echo "Marvell identify register 2(1.C41E):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001C41E | awk -F':' '{print $2}' >>$file

    #Line Side
    echo "AQR Line Side Status" >>$file

    echo "Auto-Nego Control 1(7.0):" >>$file
    ssdk_sh debug phy get "${phy}" 0x40070000 | awk -F':' '{print $2}' >>$file

    echo "Auto-Nego Control 2(7.10):" >>$file
    ssdk_sh debug phy get "${phy}" 0x40070010 | awk -F':' '{print $2}' >>$file

    echo "Auto-Nego Status(7.1):" >>$file
    ssdk_sh debug phy get "${phy}" 0x40070001 | awk -F':' '{print $2}' >>$file

    echo "Link Parner Auto-Nego Ability(7.13):" >>$file
    ssdk_sh debug phy get "${phy}" 0x40070013 | awk -F':' '{print $2}' >>$file

    echo "Auto-Nego 10G Control 1(7.20):" >>$file
    ssdk_sh debug phy get "${phy}" 0x40070020 | awk -F':' '{print $2}' >>$file

    echo "Auto-Nego 10G Status 1(7.21):" >>$file
    ssdk_sh debug phy get "${phy}" 0x40070021 | awk -F':' '{print $2}' >>$file

    echo "Autonego Vendor Provision 1(7.C400):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4007C400 | awk -F':' '{print $2}' >>$file

    echo "Autonego Vendor Reserved Provision 1(7.C410):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4007C410 | awk -F':' '{print $2}' >>$file

    echo "Autonego Vendor Status(7.C800):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4007C800 | awk -F':' '{print $2}' >>$file

    echo "Autonego Reserved Vendor Status(7.C810):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4007C810 | awk -F':' '{print $2}' >>$file

    echo "Autonego Reserved Vendor Status(7.C810):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4007C810 | awk -F':' '{print $2}' >>$file

    echo "Autonego Reserved Vendor Status(7.C810):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4007C810 | awk -F':' '{print $2}' >>$file

    echo "Autonego Reserved Vendor Status(7.C810):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4007C810 | awk -F':' '{print $2}' >>$file

    echo "Autonego Reserved Vendor Status(7.C810):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4007C810 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(7.C811):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4007C811 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(7.CC00):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4007CC00 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(7.E820):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4007E820 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(7.E821):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4007E821 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(7.E822):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4007E822 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(7.E823):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4007E823 | awk -F':' '{print $2}' >>$file

    echo "Autonego Rx Reserved Vendor Status 1(7.E830):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4007E830 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(7.E832):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4007E832 | awk -F':' '{print $2}' >>$file

    #System Side
    echo "AQR System Side Status" >>$file

    echo "PCS 10GBASE-T Status 1(3.20):" >>$file
    ssdk_sh debug phy get "${phy}" 0x40030020 | awk -F':' '{print $2}' >>$file

    echo "PCS 10GBASE-T Status 2(3.21):" >>$file
    ssdk_sh debug phy get "${phy}" 0x40030021 | awk -F':' '{print $2}' >>$file

    echo "PCS Tx Vendor Alarms 1(3.CC00):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003CC00 | awk -F':' '{print $2}' >>$file

    echo "PCS Tx Vendor Alarms 4(3.CC03):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003CC03 | awk -F':' '{print $2}' >>$file

    echo "PCS Rx Vendor Alarm 1(3.EC00):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003EC00 | awk -F':' '{print $2}' >>$file

    echo "PCS Rx Vendor Alarm 6(3.EC05):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003EC05 | awk -F':' '{print $2}' >>$file

    echo "PCS Rx Vendor Alarm 7(3.EC06):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003EC06 | awk -F':' '{print $2}' >>$file

    echo "PCS Rx XFI0 Vendor State 6(3.E865):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003E865 | awk -F':' '{print $2}' >>$file

    echo "PCS Rx XFI0 Vendor State 7(3.E866):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003E866 | awk -F':' '{print $2}' >>$file

    echo "PHY XS Standard XGXS Lane Status(4.18):" >>$file
    ssdk_sh debug phy get "${phy}" 0x40040018 | awk -F':' '{print $2}' >>$file

    echo "PHY XS Tx (XAUI RX) Reserved Vendor Provisioning 2(4.C441):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4004C441 | awk -F':' '{print $2}' >>$file

    echo "PHY XS Tx (XAUI RX) Reserved Vendor Provisioning 3(4.C442):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4004C442 | awk -F':' '{print $2}' >>$file

    echo "PHY XS Tx (XAUI RX) Reserved Vendor Provisioning 4(4.C443):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4004C443 | awk -F':' '{print $2}' >>$file

    echo "PHY XS Rx (XAUI Tx) Reserved Vendor Provisioning 1(4.E410):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4004E410 | awk -F':' '{print $2}' >>$file

    echo "PHY XS Rx (XAUI Tx) Reserved Vendor Provisioning 2(4.E411):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4004E411 | awk -F':' '{print $2}' >>$file

    #EEE
    echo "EEE function" >>$file
    echo "EEE mode(1E.C4A0):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401EC4A0 | awk -F':' '{print $2}' >>$file

    echo "PCS Tx TPL Vendor State(3.C830):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003C830 | awk -F':' '{print $2}' >>$file

    echo "PCS Rx RPL Vendor State(3.E834):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003E834 | awk -F':' '{print $2}' >>$file

    echo "GE PHY TGE Status 4(1D.D203):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401DD203 | awk -F':' '{print $2}' >>$file

    echo "GE PHY TGE Status 3(1D.D202):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401DD202 | awk -F':' '{print $2}' >>$file

    #Counter
    echo "AQR Counter" >>$file

    echo "Rx CRC8 Errors MSW(3.E811):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003E811 | awk -F':' '{print $2}' >>$file

    echo "Rx CRC8 Errors LSW(3.E810):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003E810 | awk -F':' '{print $2}' >>$file

    echo "Rx LDPC Errors MSW(3.E821):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003E821 | awk -F':' '{print $2}' >>$file

    echo "Rx LDPC Errors LSW(3.E820):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003E820 | awk -F':' '{print $2}' >>$file

    echo "TPL/Tx Line Side Good MSW(3.C821):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003C821 | awk -F':' '{print $2}' >>$file

    echo "TPL/Tx Line Side Good LSW(3.C820):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003C820 | awk -F':' '{print $2}' >>$file

    echo "TPL/Tx Line Side Bad MSW(3.C823):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003C823 | awk -F':' '{print $2}' >>$file

    echo "TPL/Tx Line Side Bad LSW(3.C822):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003C822 | awk -F':' '{print $2}' >>$file

    echo "RPL/Rx Line Side Good MSW(3.E813):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003E813 | awk -F':' '{print $2}' >>$file

    echo "RPL/Rx Line Sied Good LSW(3.E812):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003E812 | awk -F':' '{print $2}' >>$file

    echo "RPL/Rx Line Side Bad MSW(3.E815):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003E815 | awk -F':' '{print $2}' >>$file

    echo "RPL/Rx Line Sied Bad LSW(3.E814):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003E814 | awk -F':' '{print $2}' >>$file

    echo "TKL/Tx System Side Good MSW(3.C861):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003C861 | awk -F':' '{print $2}' >>$file

    echo "TKL/Tx System Side Good LSW(3.C860):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003C860 | awk -F':' '{print $2}' >>$file

    echo "TKL/Tx System Side bad MSW(3.C863):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003C863 | awk -F':' '{print $2}' >>$file

    echo "TKL/Tx System Side bad LSW(3.C862):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003C862 | awk -F':' '{print $2}' >>$file

    echo "RKL/Rx System Side Good MSW(3.E861):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003E861 | awk -F':' '{print $2}' >>$file

    echo "RKL/Rx System Side Good LSW(3.E860):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003E860 | awk -F':' '{print $2}' >>$file

    echo "RKL/Rx System Side bad MSW(3.E863):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003E863 | awk -F':' '{print $2}' >>$file

    echo "RKL/Rx System Side bad LSW(3.E862):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003E862 | awk -F':' '{print $2}' >>$file

    echo "RSI/Tx System Side Good MSW(1D.D314):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401DD314 | awk -F':' '{print $2}' >>$file

    echo "RSI/Tx System Side Good LSW(1D.D313):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401DD313 | awk -F':' '{print $2}' >>$file

    echo "RSI/Tx System Side bad MSW(1D.D316):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401DD316 | awk -F':' '{print $2}' >>$file

    echo "RSI/Tx System Side bad LSW(1D.D315):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401DD315 | awk -F':' '{print $2}' >>$file

    echo "TSI/Rx System Side Good MSW(1D.D293):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401DD293 | awk -F':' '{print $2}' >>$file

    echo "TSI/Rx System Side Good LSW(1D.D292):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401DD292 | awk -F':' '{print $2}' >>$file

    echo "TSI/Rx System Side bad MSW(1D.D295):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401DD295 | awk -F':' '{print $2}' >>$file

    echo "TSI/Rx System Side bad LSW(1D.D294):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401DD294 | awk -F':' '{print $2}' >>$file

    ##Marvell debug register
    echo "Debug Register(1.8):" >>$file
    ssdk_sh debug phy get "${phy}" 0x40010008 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.9):" >>$file
    ssdk_sh debug phy get "${phy}" 0x40010009 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.82):" >>$file
    ssdk_sh debug phy get "${phy}" 0x40010082 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.83):" >>$file
    ssdk_sh debug phy get "${phy}" 0x40010083 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.85):" >>$file
    ssdk_sh debug phy get "${phy}" 0x40010085 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.86):" >>$file
    ssdk_sh debug phy get "${phy}" 0x40010086 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.87):" >>$file
    ssdk_sh debug phy get "${phy}" 0x40010087 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.88):" >>$file
    ssdk_sh debug phy get "${phy}" 0x40010088 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.89):" >>$file
    ssdk_sh debug phy get "${phy}" 0x40010089 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.8A):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001008A | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.8B):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001008B | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.8C):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001008C | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.C021):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001C021 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.C022):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001C022 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.C023):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001C023 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.C024):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001C024 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.C025):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001C025 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.C026):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001C026 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.C027):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001C027 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.C028):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001C028 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.C100):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001C100 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.C112):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001C112 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.C113):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001C113 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.C116):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001C116 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.C124):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001C124 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.C125):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001C125 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.C126):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001C126 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.C127):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001C127 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.C128):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001C128 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.C129):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001C129 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.C134):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001C134 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.C135):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001C135 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.C136):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001C136 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.C137):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001C137 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.C138):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001C138 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.C141):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001C141 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.C142):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001C142 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.C152):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001C152 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.C153):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001C153 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.C154):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001C154 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.C155):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001C155 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.C410):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001C410 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.C810):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001C810 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.C811):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001C811 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.CC00):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001CC00 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.D800):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001D800 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.E400):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001E400 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.E800):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001E800 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.E810):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001E810 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.E811):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001E811 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.E920):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001E920 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.E921):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001E921 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.E922):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001E922 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.E923):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001E923 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.E924):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001E924 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.E925):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001E925 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.E926):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001E926 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.E927):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001E927 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.EC01):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001EC01 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.EC02):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001EC02 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.EC03):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001EC03 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.EC04):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001EC04 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.EC05):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001EC05 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.EC06):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001EC06 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1.EC07):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001EC07 | awk -F':' '{print $2}' >>$file

    ##
    echo "Debug Register(3.8):" >>$file
    ssdk_sh debug phy get "${phy}" 0x40030008 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(3.CC01):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003CC01 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(3.EC04):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003EC04 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(3.D800):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003D800 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(3.D801):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003D801 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(3.E810):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003E811 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(3.E820):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003E820 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(3.E821):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003E821 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(3.E822):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003E822 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(3.E823):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003E823 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(3.E840):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003E840 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(3.E841):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003E841 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(3.E842):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003E842 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(3.E843):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003E843 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(3.E844):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003E844 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(3.E845):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003E845 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(3.E846):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003E846 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(3.E847):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003E847 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(3.E848):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003E848 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(3.E849):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003E849 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(3.E84A):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003E84A | awk -F':' '{print $2}' >>$file

    echo "Debug Register(3.E84B):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003E84B | awk -F':' '{print $2}' >>$file

    echo "Debug Register(3.E84C):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003E84C | awk -F':' '{print $2}' >>$file

    echo "Debug Register(3.E84D):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003E84D | awk -F':' '{print $2}' >>$file

    echo "Debug Register(3.E84E):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003E84E | awk -F':' '{print $2}' >>$file

    echo "Debug Register(3.E84F):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003E84F | awk -F':' '{print $2}' >>$file

    echo "Debug Register(3.E850):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003E850 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(3.E851):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003E851 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(3.E852):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003E852 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(3.F800):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003F800 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(4.0):" >>$file
    ssdk_sh debug phy get "${phy}" 0x40040000 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(4.1):" >>$file
    ssdk_sh debug phy get "${phy}" 0x40040001 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(4.8):" >>$file
    ssdk_sh debug phy get "${phy}" 0x40040008 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(4.18):" >>$file
    ssdk_sh debug phy get "${phy}" 0x40040018 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(4.C802):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4004C802 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(4.C803):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4004C803 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(4.C804):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4004C804 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(4.C805):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4004C805 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(4.CC01):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4004CC01 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(4.CC03):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4004CC03 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(4.CC04):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4004CC04 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(4.E402):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4004E402 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(4.E403):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4004E403 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(4.E404):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4004E404 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(4.E405):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4004E405 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(4.E802):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4004E802 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(4.E803):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4004E803 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(4.E804):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4004E804 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(4.E805):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4004E805 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(4.EC00):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4004EC00 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(4.EC02):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4004EC02 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(4.F801):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4004F801 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(4.F802):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4004F802 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1D.C280):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401DC280 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1D.C500):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401DC500 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1D.D280):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401DD280 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1D.D282):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401DD282 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1D.D283):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401DD283 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1D.D284):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401DD284 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1D.D285):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401DD285 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1D.D300):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401DD300 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1D.D302):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401DD302 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1D.D303):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401DD303 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1D.D304):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401DD304 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1D.D305):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401DD305 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1D.D30B):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401DD30B | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1D.D30C):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401DD30C | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1D.E010):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401DE010 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1D.E030):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401DE030 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.0):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401E0000 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.20):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401E0020 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.1000):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401E1000 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.1001):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401E1001 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.1002):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401E1002 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.1003):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401E1003 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.1004):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401E1004 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.1005):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401E1005 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.1200):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401E1200 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.1201):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401E1201 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.1202):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401E1202 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.1203):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401E1203 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.1204):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401E1204 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.1205):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401E1205 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.C001):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401EC001 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.C472):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401EC472 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.C473):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401EC473 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.C474):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401EC474 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.C475):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401EC475 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.C476):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401EC476 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.C477):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401EC477 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.C820):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401EC820 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.C821):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401EC821 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.C840):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401EC840 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.C841):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401EC841 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.C842):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401EC842 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.C843):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401EC843 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.C844):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401EC844 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.C845):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401EC845 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.C846):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401EC846 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.C847):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401EC847 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.C848):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401EC848 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.C849):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401EC849 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.C84A):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401EC84A | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.C84B):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401EC84B | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.C84C):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401EC84C | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.C84D):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401EC84D | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.C84E):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401EC84E | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.C84F):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401EC84F | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.C850):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401EC850 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.C851):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401EC851 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.C870):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401EC870 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.C880):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401EC880 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.C881):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401EC881 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.C882):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401EC882 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.C883):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401EC883 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.C884):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401EC884 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.C885):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401EC885 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.C886):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401EC886 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.C890):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401EC890 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.C891):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401EC891 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.C892):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401EC892 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.C893):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401EC893 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.C894):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401EC894 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.CC01):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401ECC01 | awk -F':' '{print $2}' >>$file

    echo "Debug Register(1E.CC02):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401ECC02 | awk -F':' '{print $2}' >>$file

    echo "PMA Fast Retrain(1.93):" >>$file
    ssdk_sh debug phy get "${phy}" 0x40010093 | awk -F':' '{print $2}' >>$file

    echo "Global Thermal Provisioning(1E.C421):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401EC421 | awk -F':' '{print $2}' >>$file

    echo "Global Thermal Provisioning(1E.C421):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401EC421 | awk -F':' '{print $2}' >>$file

    #get EEE capability
    echo "PHY MAC path EEE 10G (1E.31f):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401E031F | awk -F':' '{print $2}' >>$file
    echo "PHY MAC path EEE 5G (1E.31e):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401E031E | awk -F':' '{print $2}' >>$file
    echo "PHY MAC path EEE 2.5G (1E.31d):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401E031D | awk -F':' '{print $2}' >>$file
    echo "PHY MAC path EEE 1G (1E.31c):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401E031C | awk -F':' '{print $2}' >>$file
    echo "EEE Capability Advertisement 10G/1G(7.3c):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4007003C | awk -F':' '{print $2}' >>$file
    echo "EEE Capability Advertisement 5G/2.5G(7.3e):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4007003E | awk -F':' '{print $2}' >>$file
    echo "PHY-control EEE 1 (1E.4000):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401E4000 | awk -F':' '{print $2}' >>$file
    echo "PHY-control EEE 2(1E.4001):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401E4001 | awk -F':' '{print $2}' >>$file
    echo "PHY-control EEE 3 (1E.7000):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401E7000 | awk -F':' '{print $2}' >>$file

    #LPI
    echo "LPI Timer Increment bit0, Wake Up threshold Increment bit1 (1E.4003):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401E4003 | awk -F':' '{print $2}' >>$file
    echo "LPI Wake Time[F:8] (1E.403E):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401E403E | awk -F':' '{print $2}' >>$file
    echo "LPI Threshold [F:0] (1E.403F):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401E403F | awk -F':' '{print $2}' >>$file
    echo "Wake Up Wait Threshold [F:0] (1E.4040):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401E4040 | awk -F':' '{print $2}' >>$file

    echo "MDI TX in LPI Mode Indicator (3.C830):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003C830 | awk -F':' '{print $2}' >>$file
    echo "MDI RX in LPI Mode Indicator (3.E834):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4003E834 | awk -F':' '{print $2}' >>$file
    echo "MDI EEE Wake Error Counter (3.16):" >>$file
    ssdk_sh debug phy get "${phy}" 0x40030016 | awk -F':' '{print $2}' >>$file

    echo "MDI TX in LPI Mode Indicator 1G (1D.D203):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401DD203 | awk -F':' '{print $2}' >>$file
    echo "MDI RX in LPI Mode Indicator 1G (1D.D202):" >>$file
    ssdk_sh debug phy get "${phy}" 0x401DD202 | awk -F':' '{print $2}' >>$file

    #PMA TX
    echo "PMA TX Alarm (1.CC02):" >>$file
    ssdk_sh debug phy get "${phy}" 0x4001CC02 | awk -F':' '{print $2}' >>$file

    #echo "debug Trace dump" >> $file
    #./lib/debug/aqr113c/wan_debugtrace >> $file

    ##QCA
    echo "RX_FRAME_COUNT_GOOD_BAD_LOW:" >>$file
    devmem 0x3A003900 >>$file
    echo -n >>$file

    echo "RX_FRAME_COUNT_GOOD_BAD_HIGH:" >>$file
    devmem 0x3A003904 >>$file
    echo -n >>$file

    echo "RX_OCTET_COUNT_GOOD_LOW:" >>$file
    devmem 0x3A003910 >>$file
    echo -n >>$file

    echo "RX_OCTET_COUNT_GOOD_HIGH:" >>$file
    devmem 0x3A003914 >>$file
    echo -n >>$file

    echo "RX_CRC_ERROR_FRAMES_LOW:" >>$file
    devmem 0x3A003928 >>$file
    echo -n >>$file

    echo "RX_CRC_ERROR_FRAMES_HIGH:" >>$file
    devmem 0x3A00392C >>$file
    echo -n >>$file

    echo "TX_FRAME_COUNT_GOOD_LOW:" >>$file
    devmem 0x3A00388C >>$file
    echo -n >>$file

    echo "TX_FRAME_COUNT_GOOD_HIGH:" >>$file
    devmem 0x3A003890 >>$file
    echo -n >>$file

    #Eth statistics

    if [ -n "${interface}" ]; then
        echo "collisions:" >>$file
        cat /sys/class/net/"${interface}"/statistics/collisions >>$file
        echo -n >>$file

        echo "multicast:" >>$file
        cat /sys/class/net/"${interface}"/statistics/multicast >>$file
        echo -n >>$file

        echo "rx_bytes:" >>$file
        cat /sys/class/net/"${interface}"/statistics/rx_bytes >>$file
        echo -n >>$file

        echo "rx_compressed:" >>$file
        cat /sys/class/net/"${interface}"/statistics/rx_compressed >>$file
        echo -n >>$file

        echo "rx_crc_errors:" >>$file
        cat /sys/class/net/"${interface}"/statistics/rx_crc_errors >>$file
        echo -n >>$file

        echo "rx_dropped:" >>$file
        cat /sys/class/net/"${interface}"/statistics/rx_dropped >>$file
        echo -n >>$file

        echo "rx_errors:" >>$file
        cat /sys/class/net/"${interface}"/statistics/rx_errors >>$file
        echo -n >>$file

        echo "rx_fifo_errors:" >>$file
        cat /sys/class/net/"${interface}"/statistics/rx_fifo_errors >>$file
        echo -n >>$file

        echo "rx_frame_errors:" >>$file
        cat /sys/class/net/"${interface}"/statistics/rx_frame_errors >>$file
        echo -n >>$file

        echo "rx_length_errors:" >>$file
        cat /sys/class/net/"${interface}"/statistics/rx_length_errors >>$file
        echo -n >>$file

        echo "rx_missed_errors:" >>$file
        cat /sys/class/net/"${interface}"/statistics/rx_missed_errors >>$file
        echo -n >>$file

        echo "rx_over_errors:" >>$file
        cat /sys/class/net/"${interface}"/statistics/rx_over_errors >>$file
        echo -n >>$file

        echo "rx_packets:" >>$file
        cat /sys/class/net/"${interface}"/statistics/rx_packets >>$file
        echo -n >>$file

        echo "tx_aborted_errors:" >>$file
        cat /sys/class/net/"${interface}"/statistics/tx_aborted_errors >>$file
        echo -n >>$file

        echo "tx_bytes:" >>$file
        cat /sys/class/net/"${interface}"/statistics/tx_bytes >>$file
        echo -n >>$file

        echo "tx_carrier_errors:" >>$file
        cat /sys/class/net/"${interface}"/statistics/tx_carrier_errors >>$file
        echo -n >>$file

        echo "tx_compressed:" >>$file
        cat /sys/class/net/"${interface}"/statistics/tx_compressed >>$file
        echo -n >>$file

        echo "tx_dropped:" >>$file
        cat /sys/class/net/"${interface}"/statistics/tx_dropped >>$file
        echo -n >>$file

        echo "tx_errors:" >>$file
        cat /sys/class/net/"${interface}"/statistics/tx_errors >>$file
        echo -n >>$file

        echo "tx_fifo_errors:" >>$file
        cat /sys/class/net/"${interface}"/statistics/tx_fifo_errors >>$file
        echo -n >>$file

        echo "tx_heartbeat_errors:" >>$file
        cat /sys/class/net/"${interface}"/statistics/tx_heartbeat_errors >>$file
        echo -n >>$file

        echo "tx_packets:" >>$file
        cat /sys/class/net/"${interface}"/statistics/tx_packets >>$file
        echo -n >>$file

        echo "tx_window_errors:" >>$file
        cat /sys/class/net/"${interface}"/statistics/tx_window_errors >>$file
        echo -n >>$file
        echo -n >>$file
    fi

}

dump_wifi() {
    local wifi_file="${WIFI_LOG}"

    if grep -q "ATH" "/etc/version"; then
        echo "ATH Version" >>$wifi_file
	echo "===Log Time:" >>$wifi_file
	date >>$wifi_file
	echo '' >>$wifi_file

	echo "===Wifi FW Version Information:" >>$wifi_file
	strings /lib/firmware/qcn9224/amss.bin |grep VERSION >>$wifi_file
	echo '' >>$wifi_file

	echo "===Wifi FW BDF Information:" >>$wifi_file
	md5sum /lib/firmware/ath12k/QCN92XX/hw1.0/board-2.bin >>$wifi_file
	echo '' >>$wifi_file

	echo "===Wifi AP Status:" >>$wifi_file
	iw dev >>$wifi_file
	echo '' >>$wifi_file

	echo "===Wifi 2G Station Status:" >>$wifi_file
	iw dev wlan0 station dump >>$wifi_file
	echo '' >>$wifi_file

	echo "===Wifi 5G Station Status:" >>$wifi_file
	iw dev wlan1 station dump >>$wifi_file
	echo '' >>$wifi_file

	echo "===Wifi 6G Station Status:" >>$wifi_file
	iw dev wlan2 station dump >>$wifi_file
	echo '' >>$wifi_file

	echo "===Wifi 2G MAC:" >>$wifi_file
	cat /sys/kernel/debug/ath12k/qcn9274\ hw2.0_0001:01:00.0/mac0/fw_stats/vdev_stats | grep MAC >>$wifi_file
	echo '' >>$wifi_file

	echo "===Wifi 5G MAC:" >>$wifi_file
	cat /sys/kernel/debug/ath12k/qcn9274\ hw2.0_0003:01:00.0/mac0/fw_stats/vdev_stats | grep MAC >>$wifi_file
	echo '' >>$wifi_file

	echo "===Wifi 6G MAC:" >>$wifi_file
	cat /sys/kernel/debug/ath12k/qcn9274\ hw2.0_0002:01:00.0/mac0/fw_stats/vdev_stats | grep MAC >>$wifi_file
	echo '' >>$wifi_file

	echo "===Wifi 2G RSSI:" >>$wifi_file
	echo 10 > /sys/kernel/debug/ath12k/qcn9274\ hw2.0_0001:01:00.0/mac0/htt_stats_type
	cat /sys/kernel/debug/ath12k/qcn9274\ hw2.0_0001:01:00.0/mac0/htt_stats | grep rssi_in_dbm >>$wifi_file
	echo '' >>$wifi_file

	echo "===Wifi 5G RSSI:" >>$wifi_file
	echo 10 > /sys/kernel/debug/ath12k/qcn9274\ hw2.0_0003:01:00.0/mac0/htt_stats_type
	cat /sys/kernel/debug/ath12k/qcn9274\ hw2.0_0003:01:00.0/mac0/htt_stats | grep rssi_in_dbm >>$wifi_file
	echo '' >>$wifi_file

	echo "===Wifi 6G RSSI:" >>$wifi_file
	echo 10 > /sys/kernel/debug/ath12k/qcn9274\ hw2.0_0002:01:00.0/mac0/htt_stats_type
	cat /sys/kernel/debug/ath12k/qcn9274\ hw2.0_0002:01:00.0/mac0/htt_stats | grep rssi_in_dbm >>$wifi_file
	echo '' >>$wifi_file\

	echo "===Reset Wifi Tx/Rx MCS:" >>$wifi_file
	echo 1 > /sys/kernel/debug/ath12k/qcn9274\ hw2.0_0001:01:00.0/mac0/htt_stats_reset
	echo 1 > /sys/kernel/debug/ath12k/qcn9274\ hw2.0_0003:01:00.0/mac0/htt_stats_reset
	echo 1 > /sys/kernel/debug/ath12k/qcn9274\ hw2.0_0002:01:00.0/mac0/htt_stats_reset
	sleep 5

	echo "===Wifi 2G Tx/Rx MCS counter:" >>$wifi_file
	echo 9 > /sys/kernel/debug/ath12k/qcn9274\ hw2.0_0001:01:00.0/mac0/htt_stats_type
	cat /sys/kernel/debug/ath12k/qcn9274\ hw2.0_0001:01:00.0/mac0/htt_stats | grep ^tx_mcs >>$wifi_file
	echo 10 > /sys/kernel/debug/ath12k/qcn9274\ hw2.0_0001:01:00.0/mac0/htt_stats_type
	cat /sys/kernel/debug/ath12k/qcn9274\ hw2.0_0001:01:00.0/mac0/htt_stats | grep ^rx_mcs >>$wifi_file
	echo '' >>$wifi_file

	echo "===Wifi 5G Tx/Rx MCS counter:" >>$wifi_file
	echo 9 > /sys/kernel/debug/ath12k/qcn9274\ hw2.0_0003:01:00.0/mac0/htt_stats_type
	cat /sys/kernel/debug/ath12k/qcn9274\ hw2.0_0003:01:00.0/mac0/htt_stats | grep ^tx_mcs >>$wifi_file
	echo 10 > /sys/kernel/debug/ath12k/qcn9274\ hw2.0_0003:01:00.0/mac0/htt_stats_type
	cat /sys/kernel/debug/ath12k/qcn9274\ hw2.0_0003:01:00.0/mac0/htt_stats | grep ^rx_mcs >>$wifi_file
	echo '' >>$wifi_file

	echo "===Wifi 6G Tx/Rx MCS counter:" >>$wifi_file
	echo 9 > /sys/kernel/debug/ath12k/qcn9274\ hw2.0_0002:01:00.0/mac0/htt_stats_type
	cat /sys/kernel/debug/ath12k/qcn9274\ hw2.0_0002:01:00.0/mac0/htt_stats | grep ^tx_mcs >>$wifi_file
	echo 10 > /sys/kernel/debug/ath12k/qcn9274\ hw2.0_0002:01:00.0/mac0/htt_stats_type
	cat /sys/kernel/debug/ath12k/qcn9274\ hw2.0_0002:01:00.0/mac0/htt_stats | grep ^rx_mcs >>$wifi_file
	echo '' >>$wifi_file
    fi

    if grep -q "SPF" "/etc/version"; then
        echo "SPF Version" >>$wifi_file
	echo "===Log Time:" >>$wifi_file
	date >>$wifi_file
	echo '' >>$wifi_file

	echo "===Wifi FW Version Information:" >>$wifi_file
	strings /lib/firmware/qcn9224/amss.bin |grep VERSION >>$wifi_file
	echo '' >>$wifi_file

	echo "===Wifi FW BDF Information:" >>$wifi_file
	md5sum /lib/firmware/qcn9224/bdwlan.b000* >>$wifi_file
	echo '' >>$wifi_file

	echo "===Wifi AP Status:" >>$wifi_file
	iw dev >>$wifi_file
	echo '' >>$wifi_file

	echo "===Wifi 2G Station Status:" >>$wifi_file
	wlanconfig ath0 list sta >>$wifi_file
	echo '' >>$wifi_file

	echo "===Wifi 5G Station Status:" >>$wifi_file
	wlanconfig ath2 list sta >>$wifi_file
	echo '' >>$wifi_file

	echo "===Wifi 6G Station Status:" >>$wifi_file
	wlanconfig ath1 list sta >>$wifi_file
	echo '' >>$wifi_file

	echo "===Wifi 2G MAC:" >>$wifi_file
	ifconfig -a | grep HWaddr | grep ath0 >>$wifi_file
	echo '' >>$wifi_file

	echo "===Wifi 5G MAC:" >>$wifi_file
	ifconfig -a | grep HWaddr | grep ath2 >>$wifi_file
	echo '' >>$wifi_file

	echo "===Wifi 6G MAC:" >>$wifi_file
	ifconfig -a | grep HWaddr | grep ath1 >>$wifi_file
	echo '' >>$wifi_file

	echo "===Wifi 2G RSSI:" >>$wifi_file
	wifistats wifi0 10 | grep rssi_in_dbm >>$wifi_file
	echo '' >>$wifi_file

	echo "===Wifi 5G RSSI:" >>$wifi_file
	wifistats wifi2 10 | grep ssi_in_dbm >>$wifi_file
	echo '' >>$wifi_file

	echo "===Wifi 6G RSSI:" >>$wifi_file
	wifistats wifi1 10 | grep rssi_in_dbm >>$wifi_file
	echo '' >>$wifi_file\

	echo "===Reset Wifi Tx/Rx MCS:" >>$wifi_file
	wifistats wifi0 0 9
	wifistats wifi2 0 9
	wifistats wifi1 0 9
	wifistats wifi0 0 10
	wifistats wifi2 0 10
	wifistats wifi1 0 10
	sleep 5

	echo "===Wifi 2G Tx/Rx MCS counter:" >>$wifi_file
	wifistats wifi0 9 | grep ^tx_mcs >>$wifi_file
	wifistats wifi0 10 | grep ^rx_mcs >>$wifi_file
	echo '' >>$wifi_file

	echo "===Wifi 5G Tx/Rx MCS counter:" >>$wifi_file
	wifistats wifi2 9 | grep ^tx_mcs >>$wifi_file
	wifistats wifi2 10 | grep ^rx_mcs >>$wifi_file
	echo '' >>$wifi_file

	echo "===Wifi 6G Tx/Rx MCS counter:" >>$wifi_file
	wifistats wifi1 9 | grep ^tx_mcs >>$wifi_file
	wifistats wifi1 10 | grep ^rx_mcs >>$wifi_file
	echo '' >>$wifi_file
    fi
}

dump_syslog() {
    syslog_file="${SYS_LOG}"
    echo "====[Syslog]====" >>$syslog_file
    date >>$syslog_file
    logread >>$syslog_file
}

dump_switch() {
    local switch_file="${SWITCH_LOG}"

    date >>$switch_file
    echo '' >>$switch_file

    echo '-- get-status --' >>$switch_file
    switch-shell get-status >>$switch_file
    echo '' >>$switch_file

    echo '-- get-sds --' >>$switch_file
    switch-shell get-sds >>$switch_file
    echo '' >>$switch_file

    echo '-- get-mac-link-status --' >>$switch_file
    switch-shell get-mac-link-status >>$switch_file
    echo '' >>$switch_file

    echo '-- get-phy-link-status --' >>$switch_file
    switch-shell get-phy-link-status >>$switch_file
    echo '' >>$switch_file

    echo '-- get-vlan-config --' >>$switch_file
    switch-shell get-vlan-config >>$switch_file
    echo '' >>$switch_file

}

dump_gpio() {
    local gpio_file="${GPIO_LOG}"
    date >>$gpio_file
    echo '' >>$gpio_file
    cat /sys/kernel/debug/gpio >>$gpio_file
}

mkdir -p "${DIR}"
echo "Version: ${VERSION}" >"${DIR}/version.txt"

if [ "${1}" == "clean" ]; then
    clean
elif [ ${1} == "all" ]; then
    dump_syslog
    dump_switch
    dump_eth lan
    dump_eth wan
    dump_wifi
elif [ "${1}" == "syslog" ]; then
    dump_syslog
elif [ "${1}" == "eth" ]; then
    dump_eth ${2}
elif [ "${1}" == "switch" ]; then
    dump_switch
elif [ "${1}" == "wifi" ]; then
    dump_wifi
elif [ "${1}" == "gpio" ]; then
    dump_gpio
fi
