#!/bin/sh

# This script collects LXC debug information
# Usage: /etc/init.d/cthulhu debuginfo


process_lxcpath_dir() {
    local lxcpath=$1

    # Loop over all containers dir
    for dir in "$lxcpath"/*/; do
        if [ -d "$dir" ]; then
            echo "Directory: $dir"

            # print the content of all available config files
            for file in "$dir"*; do
                if [ -f "$file" ]; then
                    echo "--> File: $file :"
                    # Print the content of the file
                    cat "$file"
                    echo ""
                fi
            done
        fi
    done
}

dump_lxc_containers() {
    LXC_LS=$(lxc-ls -f)
    echo -e "lxc-containers:\n ${LXC_LS}"

    # List info from all containers
    CTR_LIST=$(lxc-ls)
    if [ -n "${CTR_LIST}" ]; then
        for ctr in ${CTR_LIST}; do
            echo "lxc-info -n $ctr"
            lxc-info -n "$ctr"
        done
    fi

    # Get list of processes from running containers
    CTR_LIST=$(lxc-ls --running)
    if [ -n "${CTR_LIST}" ]; then
        for ctr in ${CTR_LIST}; do
	    echo "lxc-attach -n \"$ctr\" -- ps"
	    lxc-attach -n "$ctr" -- ps
        done
    fi
}

main() {
    echo "##### LXC Debug #####"
    LXCPATH=$(lxc-config lxc.lxcpath)

    echo "##### LXC config and containers"
    echo -e "lxc path config:\n ${LXCPATH}"
    dump_lxc_containers

    echo "##### Containers config"
    if [ -z "$LXCPATH" ]; then
        echo "lxcpath config is empty ! -> getting config files not possible"
        exit 1
    fi
    process_lxcpath_dir "${LXCPATH}"
}

main
