#!/bin/sh

# This script collects debug information
# Usage: /etc/init.d/cthulhu debuginfo

echo "##### Cthulhu data Debug #####"
## Not using 'ba-cli -l' to allow getting the config even if the cli configuration is changed
STORAGE_DIR=$(ba-cli "Cthulhu.Config.StorageLocation?" | grep "Cthulhu.Config.StorageLocation=" | awk -F '=' '{gsub(/"/, "", $2); print $2}')

if [ -z "$STORAGE_DIR" ]; then
        if [ -n "$1" ]; then
            echo "Cthulhu storage dir cannot be retrieved from Cthulhu config. Falling back to default: $1"
            STORAGE_DIR=$1
        else
           echo "Cthulhu storage location cannot be retrived and no default is found"
           exit 1
        fi
fi

echo "#### Cthulhu storage dir content"
## Excluding particular dirs
BLOB_STORE="$STORAGE_DIR/blob_store"
LAYERS_DIR="$STORAGE_DIR/layers"
ROOTFS_DIR="$STORAGE_DIR/rootfs"
find "$STORAGE_DIR" -path "${LAYERS_DIR}" -prune -o -path "${ROOTFS_DIR}" -prune -o -path "${BLOB_STORE}" -prune -o -print

echo "#### Cthulhu layers/rootfs/blob_store dirs"
find "$LAYERS_DIR" -maxdepth 2
find "$ROOTFS_DIR" -maxdepth 1
find "$BLOB_STORE" -maxdepth 2

echo "#### Cthulhu SB data content"
find "${STORAGE_DIR}"/sb_host_data/ -type f | while IFS= read -r file; do
    echo "--> File: $file"
    cat "$file"
    echo ""
done
