#!/bin/sh

# This script collects debug information
# Usage: /etc/init.d/rlyeh debuginfo

# Process images dir recursively
process_images_dir() {
    local dir="$1"

    if [ -z "$(ls -A "$dir")" ]; then
        echo "Directory: $dir is empty"
        return
    fi

    echo "Directory: $dir"
    # Loop over all dirs recursively and print the files content
    for item in "$dir"/*; do
        if [ -d "$item" ]; then
            process_images_dir "$item"
        elif [ -f "$item" ]; then
            echo "--> File: $item:"
            cat "$item"
            echo ""
        fi
    done
}

# Process blobs dir
process_blob_dir() {
    local dir="$1"

    if [ -z "$(ls -A "$dir")" ]; then
        echo "Directory: $dir is empty"
        return
    fi

    echo "Directory: $dir"
    # Loop over all blobs and print their names and check destination if symlink
    for item in "$dir"/*; do
        if [ -L "$item" ]; then
            if [ -e "$item" ]; then
                echo "--> File: $item, pointing to $(readlink "$item")"
            else
                echo "--> File: ($item) target does NOT exist: $(readlink "$item")"
            fi
        else
            echo "--> File: $item"
        fi
    done
}

echo "##### Rlyeh data Debug #####"
# Retrieve ImageLocation/StorageLocation to use them instead of the default if defined
IMAGE_LOCATION=$(ba-cli "Rlyeh.ImageLocation?" | grep "Rlyeh.ImageLocation=" | awk -F '=' '{gsub(/"/, "", $2); print $2}')
STORAGE_LOCATION=$(ba-cli "Rlyeh.StorageLocation?" | grep "Rlyeh.StorageLocation=" | awk -F '=' '{gsub(/"/, "", $2); print $2}')

if [ -z "$STORAGE_LOCATION" ] || [ -z "$IMAGE_LOCATION" ]; then
        if [ -n "$1" ]; then
            echo "Rlyeh image and storage location cannot be retrieved from Rlyeh config. Falling back to default: $1/images, $1/blobs"
            IMAGE_LOCATION="$1/images"
            STORAGE_LOCATION="$1/blobs"
        else
           echo "Rlyeh image/blob location cannot be retrieved and no default is found"
           exit 1
        fi
fi


echo "##### Rlyeh images"
process_images_dir $IMAGE_LOCATION

echo "##### Rlyeh blobs"
process_blob_dir $STORAGE_LOCATION/sha256
