#!/bin/sh

PLUGIN_NAME=$1
REASON=$2
OPENWRT_SCRIPT=/lib/functions/network.sh
DDNS_FUNCTIONS_SCRIPTS=/usr/lib/ddns/

LINE_SETS_HTTPS="[ \$use_https -ne 0 ] && __URL=\$(echo \$__URL | sed -e 's#^http:#https:#')"
LINE_SETS_HTTP="[ \$use_https -eq 0 ] && __URL=\$(echo \$__URL | sed -e 's#^https:#http:#')"

echo "Patching ddns-scripts before $PLUGIN_NAME $REASON"

if [ ! -d "$DDNS_FUNCTIONS_SCRIPTS" ]; then
    echo "Failed to patch ddns-scripts - Directory '$DDNS_FUNCTIONS_SCRIPTS' does not exist."
    exit 1
fi

if [ ! -f "$OPENWRT_SCRIPT" ]; then
    echo "Failed to patch ddns-scripts - $OPENWRT_SCRIPT doesn't exist"
    exit 1
fi

# Iterate over .sh files in the directory
for file in "$DDNS_FUNCTIONS_SCRIPTS"/*.sh; do
    PATCH_FAILED=0

    # Check if any .sh files exist
    [ -e "$file" ] || continue

    # Add feature to replace https by http
    if ! grep -q "$LINE_SETS_HTTP" "$file"; then
        escaped_line_sets_https=$(printf "%s\n" "$LINE_SETS_HTTPS" | sed 's/[&/\]/\\&/g')
        if ! sed -i "/$escaped_line_sets_https/a $LINE_SETS_HTTP" "$file"; then
            echo "$PLUGIN_NAME - ERROR: Add feature to replace https by http failed."
            PATCH_FAILED=1
        fi
    fi

    # Replace the network_get_device by ddns_get_device
    if ! grep -q "ddns_get_device" "$file"; then
        if ! sed -i 's/network_get_device/ddns_get_device/g' "$file"; then
            echo "$PLUGIN_NAME - ERROR: Replace network_get_device by ddns_get_device failed."
            PATCH_FAILED=1
        fi
    fi

    if [ $PATCH_FAILED -eq 1 ]; then
        echo "$PLUGIN_NAME - ERROR: Failed to patch ddns-scripts - Patch of file $file failed."
    fi
done

# Add the ddns_get_device function to /lib/functions/network.sh
if ! grep -q "ddns_get_device" "$OPENWRT_SCRIPT"; then
    echo "ddns_get_device() { __tmp=\"\$1=\$2\"; eval \"\$__tmp\"; }" >> "$OPENWRT_SCRIPT"
fi