#!/bin/sh

PHY_NAME=phy00

# wait driver loading
while ! lsmod | cut -d " " -f 0 | grep ath12k; do
    logger -s "wld: driver ath12k not loaded yet, wait...";
    sleep 1;
done

# wait phy class creation
while [ ! -e "/sys/class/ieee80211/$PHY_NAME" ]; do
    logger -s "wld: $PHY_NAME class not created, wait...";
    sleep 2;
done

# wait phy interface creation
while ! iw $PHY_NAME info > /dev/null; do
    logger -s "wld: $PHY_NAME interface not created yet, wait...";
    sleep 1;
done
