#!/bin/sh

LIBDEBUG=/usr/lib/debuginfo/debug_functions.sh

if [ ! -f "$LIBDEBUG" ]; then
    echo "No debug library found : $LIBDEBUG"
    exit 1
fi

. $LIBDEBUG

show_title "show meminfos"
show_cmd cat /proc/meminfo

show_title "show slabinfo"
show_cmd $SUDO cat /proc/slabinfo

show_title "show disk usage"
INTERNAL_STORAGE="$(ls -d /*/ | grep -v mnt)"
show_cmd $SUDO du -hs $INTERNAL_STORAGE

show_title "show df information"
EXCLUDED_MOUNT_PATH="(/mnt/external-storage[1-9]+)|(/sys/fs/cgroup/*)"
INTERNAL_PARTITIONS="$(mount | awk '{print $3}' | grep -Ev "$EXCLUDED_MOUNT_PATH")"
show_cmd df $INTERNAL_PARTITIONS
