#!/bin/sh

ARCHIVE_PATH="$1"
DEFAULT_BACKUP_PATH="/cfg/pcm"

test -z "$ARCHIVE_PATH" && echo "no path provided exiting" && exit 1

upc_backup_path="$(grep upc_backup_path /etc/amx/pcm-manager/pcm-manager.odl | cut -d \" -f 2)"

backup_path="${upc_backup_path:-$DEFAULT_BACKUP_PATH}"

if [ ! -d "$backup_path" ]; then
    echo "Pcm backup path does not exist: $backup_path"
    exit 1
fi

tar zcf "$ARCHIVE_PATH" -C "$(dirname "$backup_path")" "$(basename "$backup_path")"
