#!/bin/sh

LIBDEBUG=/usr/lib/debuginfo/debug_functions.sh
ARCHIVE_DIR="$1"

if [ ! -f "$LIBDEBUG" ]; then
    echo "No debug library found : $LIBDEBUG"
    exit 1
fi

. "$LIBDEBUG"

for script in $(ls /etc/rc.d/S*)
do 
# check at least if the debuginfo keyword is available in the start script
    if grep -q debuginfo "$script"; then
        show_title "$script" debuginfo
        DEBUG_INFO_ARCHIVE_DIR="$ARCHIVE_DIR" \
            show_cmd "$script" debuginfo
    else 
# check at least if the status keyword is available in the start script
	if grep -q status "$script" ; then
            show_title "$script" status
            show_cmd "$script" status
	fi
    fi
done
