datamodel {
    object MSS {
        parameter Mode = "Master";
        parameter Enable = True;
        parameter NetworkId = "SelfOrganizedNetwork";
        object Config {
            parameter AdvertisedName = "$(MODELNAME)";
            parameter MasterElectionTimeout = 10;
            parameter SlaveElectionTimeout = 180;
            parameter DefaultElectionTimeout = 60;
            parameter ConnectionTimeout = 20;
            parameter AllowMasterNoUplink = true;
            parameter AllowMasterOnWiFi = false;
            parameter StartPairingImmediately = false;
            parameter AutoPairingEnable = true;
            parameter EnableReelection = false;
            parameter MasterIPAddress = "";
            parameter MasterDNSSDName = "";
            parameter ConnectPort = 8883;
            parameter Interface = "lan";
        }
        object Certificates {
            parameter RootCACert = "VZ_CYBERTRUST_ROOT_CA";
            parameter ClientCert = "devcert";
            parameter ClientKey = "pkcs11:token=$(PKCS11_TOKEN_DEVICEKEY);pin-source=$(PKCS11_USER_PIN_FILE_DEVICEKEY)";
            parameter CAPath = "/security";
            parameter ClientCertPath = "/var/run/cert";
            parameter ClientKeyPath = "";
            parameter TlsEngine = false;
        }
    }
}
